/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.tests.stubs.component;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.core.component.TmfProviderManager;
import org.eclipse.tracecompass.tmf.core.component.TmfEventProvider;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.request.TmfEventRequest;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfContext;
import org.eclipse.tracecompass.tmf.tests.stubs.component.TmfEventProviderStub;
import org.eclipse.tracecompass.tmf.tests.stubs.event.TmfSyntheticEventStub;

public class TmfSyntheticEventProviderStub
extends TmfEventProvider {
    public static final int NB_EVENTS = 1000;
    private final BlockingQueue<ITmfEvent> fDataQueue = new LinkedBlockingQueue<ITmfEvent>(1000);
    private static final int TIMEOUT = 10000;

    public TmfSyntheticEventProviderStub() {
        super("TmfSyntheticEventProviderStub", TmfSyntheticEventStub.class);
    }

    public ITmfContext armRequest(ITmfEventRequest request) {
        TmfEventProvider[] eventProviders = TmfProviderManager.getProviders(ITmfEvent.class, TmfEventProviderStub.class);
        TmfEventProvider provider = eventProviders[0];
        TmfTimeRange range = request.getRange();
        TmfEventRequest subRequest = new TmfEventRequest(ITmfEvent.class, range, 0L, 1000, ITmfEventRequest.ExecutionType.FOREGROUND){

            public void handleData(ITmfEvent event) {
                super.handleData(event);
                TmfSyntheticEventProviderStub.this.handleIncomingData(event);
            }
        };
        provider.sendRequest((ITmfEventRequest)subRequest);
        return new TmfContext();
    }

    private void handleIncomingData(@NonNull ITmfEvent e) {
        this.queueResult(new TmfSyntheticEventStub(e));
        this.queueResult(new TmfSyntheticEventStub(e));
    }

    public TmfSyntheticEventStub getNext(ITmfContext context) {
        TmfSyntheticEventStub data = null;
        try {
            data = (TmfSyntheticEventStub)this.fDataQueue.poll(10000L, TimeUnit.MILLISECONDS);
            if (data == null) {
                throw new InterruptedException();
            }
        }
        catch (InterruptedException interruptedException) {}
        return data;
    }

    public void queueResult(TmfSyntheticEventStub data) {
        boolean ok = false;
        try {
            ok = this.fDataQueue.offer((ITmfEvent)data, 10000L, TimeUnit.MILLISECONDS);
            if (!ok) {
                throw new InterruptedException();
            }
        }
        catch (InterruptedException interruptedException) {}
    }
}

