/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.tests.stubs.trace.text;

import com.google.common.collect.ImmutableList;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventType;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfBaseAspects;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfContentFieldAspect;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimePreferences;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampFormat;
import org.eclipse.tracecompass.tmf.core.trace.text.TextTrace;
import org.eclipse.tracecompass.tmf.core.trace.text.TextTraceEventContent;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.text.SyslogEvent;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.text.SyslogEventType;

public class SyslogTrace
extends TextTrace<SyslogEvent> {
    private static final int CACHE_SIZE = 100;
    public static final String TIMESTAMP_FORMAT = "MMM dd HH:mm:ss";
    public static final SimpleDateFormat TIMESTAMP_SIMPLEDATEFORMAT = new SimpleDateFormat("MMM dd HH:mm:ss", TmfTimePreferences.getLocale());
    public static final Pattern LINE1_PATTERN = Pattern.compile("\\s*(\\S\\S\\S \\d\\d? \\d\\d:\\d\\d:\\d\\d)\\s*(\\S*)\\s*(\\S*):+\\s*(\\S*):([0-9]*)\\s*(.*\\S)?");
    private static final Calendar CURRENT = Calendar.getInstance();
    public static final @NonNull Collection<ITmfEventAspect<?>> ASPECTS = ImmutableList.of((Object)TmfBaseAspects.getTimestampAspect(), (Object)new TmfContentFieldAspect("Host", new String[]{"Host"}), (Object)new TmfContentFieldAspect("Logger", new String[]{"Logger"}), (Object)new TmfContentFieldAspect("File", new String[]{"File"}), (Object)new TmfContentFieldAspect("Line", new String[]{"Line"}), (Object)new TmfContentFieldAspect("Message", new String[]{"Message"}));

    public SyslogTrace() {
        this.setCacheSize(100);
    }

    protected Pattern getFirstLinePattern() {
        return LINE1_PATTERN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SyslogEvent parseFirstLine(Matcher matcher, String line) {
        ITmfTimestamp timestamp = null;
        try {
            SimpleDateFormat simpleDateFormat = TIMESTAMP_SIMPLEDATEFORMAT;
            synchronized (simpleDateFormat) {
                TIMESTAMP_SIMPLEDATEFORMAT.setTimeZone(TmfTimestampFormat.getDefaulTimeFormat().getTimeZone());
                Date date = TIMESTAMP_SIMPLEDATEFORMAT.parse(matcher.group(1));
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(date);
                calendar.set(1, CURRENT.get(1));
                if (calendar.after(CURRENT)) {
                    calendar.set(1, CURRENT.get(1) - 1);
                }
                long ns = calendar.getTimeInMillis() * 1000000L;
                timestamp = this.createTimestamp(ns);
            }
        }
        catch (ParseException parseException) {
            timestamp = TmfTimestamp.create((long)0L, (int)0);
        }
        TextTraceEventContent content = new TextTraceEventContent(5);
        content.setValue((Object)new StringBuffer(line));
        content.addField("Host", (Object)matcher.group(2));
        content.addField("Logger", (Object)matcher.group(3));
        content.addField("File", (Object)matcher.group(4));
        content.addField("Line", (Object)matcher.group(5));
        content.addField("Message", (Object)new StringBuffer(matcher.group(6) != null ? matcher.group(6) : ""));
        SyslogEvent event = new SyslogEvent(this, timestamp, (ITmfEventType)SyslogEventType.INSTANCE, content);
        return event;
    }

    protected void parseNextLine(SyslogEvent event, String line) {
        TextTraceEventContent content = event.getContent();
        ((StringBuffer)content.getValue()).append("\n").append(line);
        if (line.trim().length() > 0) {
            ((StringBuffer)content.getFieldValue("Message")).append(" | " + line.trim());
        }
    }

    public ITmfTimestamp getInitialRangeOffset() {
        return TmfTimestamp.fromSeconds((long)60L);
    }

    public Iterable<ITmfEventAspect<?>> getEventAspects() {
        return ASPECTS;
    }

    public static interface Field {
        public static final @NonNull String HOST = "Host";
        public static final @NonNull String LOGGER = "Logger";
        public static final @NonNull String FILE = "File";
        public static final @NonNull String LINE = "Line";
        public static final @NonNull String MESSAGE = "Message";
    }
}

