/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers.table;

import java.util.Collections;
import java.util.Comparator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.deferred.DeferredContentProvider;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.tmf.ui.viewers.TmfViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.table.ISortingLazyContentProvider;

public class TmfSimpleTableViewer
extends TmfViewer {
    private static final int DEFAULT_COL_WIDTH = 200;
    private final TableViewer fTableViewer;
    private int fDirection;
    private int fSelectedColumn;
    private MenuManager fTablePopupMenuManager;

    public TmfSimpleTableViewer(TableViewer table) {
        super(table.getControl().getParent());
        this.fTableViewer = table;
        Table tableControl = this.fTableViewer.getTable();
        tableControl.setHeaderVisible(true);
        tableControl.setLinesVisible(true);
        this.fDirection = 1024;
        this.fTableViewer.setUseHashlookup(true);
        this.fTableViewer.getControl().addMouseListener((MouseListener)new MouseColumnListener());
        this.fTablePopupMenuManager = new MenuManager();
        this.fTablePopupMenuManager.setRemoveAllWhenShown(true);
        this.fTablePopupMenuManager.addMenuListener(manager -> {
            TableViewer viewer = this.getTableViewer();
            ISelection selection = viewer.getSelection();
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection sel = (IStructuredSelection)selection;
                if (manager != null) {
                    this.appendToTablePopupMenu(manager, sel);
                }
            }
        });
        Menu tablePopup = this.fTablePopupMenuManager.createContextMenu((Control)this.getTableViewer().getTable());
        this.getTableViewer().getTable().setMenu(tablePopup);
        tableControl.addDisposeListener(e -> this.internalDispose());
    }

    public void dispose() {
        if (this.fTableViewer != null) {
            this.fTableViewer.getControl().dispose();
        }
    }

    private void internalDispose() {
        if (this.fTablePopupMenuManager != null) {
            this.fTablePopupMenuManager.dispose();
        }
        super.dispose();
    }

    protected void appendToTablePopupMenu(@NonNull IMenuManager manager, @NonNull IStructuredSelection sel) {
    }

    public final <T> TableColumn createColumn(String name, ColumnLabelProvider provider, @Nullable Comparator<T> comparator) {
        TableViewerColumn col = new TableViewerColumn(this.fTableViewer, 0);
        col.setLabelProvider((CellLabelProvider)provider);
        TableColumn column = col.getColumn();
        column.setWidth(200);
        column.setText(name);
        column.setResizable(true);
        column.setMoveable(true);
        if (comparator == null) {
            column.addSelectionListener(new ColumnSorter<Object>(column, new ColumnLabelComparator((ILabelProvider)provider)));
        } else {
            column.addSelectionListener(new ColumnSorter<T>(column, comparator));
        }
        return column;
    }

    private void flipSortDirection() {
        this.fDirection = this.fDirection == 1024 ? 128 : 1024;
    }

    @Override
    public final Control getControl() {
        return this.fTableViewer.getControl();
    }

    public final TableViewer getTableViewer() {
        return this.fTableViewer;
    }

    public final int getColumnIndex() {
        return this.fSelectedColumn;
    }

    @Override
    public final void refresh() {
        this.fTableViewer.refresh();
    }

    private static class ColumnLabelComparator
    implements Comparator<Object> {
        private final ILabelProvider fLabelProvider;

        public ColumnLabelComparator(ILabelProvider labelProvider) {
            this.fLabelProvider = labelProvider;
        }

        @Override
        public int compare(Object o1, Object o2) {
            String s1 = NonNullUtils.nullToEmptyString((Object)this.fLabelProvider.getText(o1));
            String s2 = NonNullUtils.nullToEmptyString((Object)this.fLabelProvider.getText(o2));
            return s1.compareTo(s2);
        }
    }

    private final class ColumnSorter<T>
    extends SelectionAdapter {
        private final @NonNull TableColumn fColumn;
        private final @NonNull Comparator<T> fComparator;

        private ColumnSorter(@NonNull TableColumn column, Comparator<T> comparator) {
            this.fColumn = column;
            this.fComparator = comparator;
        }

        public void widgetSelected(SelectionEvent e) {
            Table table = TmfSimpleTableViewer.this.fTableViewer.getTable();
            TableColumn prevSortcolumn = table.getSortColumn();
            if (prevSortcolumn == this.fColumn) {
                TmfSimpleTableViewer.this.flipSortDirection();
            }
            table.setSortDirection(TmfSimpleTableViewer.this.fDirection);
            table.setSortColumn(this.fColumn);
            Comparator comparator = TmfSimpleTableViewer.this.fDirection == 1024 ? this.fComparator : (Comparator)NonNullUtils.checkNotNull(Collections.reverseOrder(this.fComparator));
            IContentProvider contentProvider = TmfSimpleTableViewer.this.fTableViewer.getContentProvider();
            if (contentProvider instanceof DeferredContentProvider) {
                DeferredContentProvider deferredContentProvider = (DeferredContentProvider)contentProvider;
                deferredContentProvider.setSortOrder(comparator);
            } else if (contentProvider instanceof ISortingLazyContentProvider) {
                ISortingLazyContentProvider sortingLazyContentProvider = (ISortingLazyContentProvider)contentProvider;
                sortingLazyContentProvider.setSortOrder(comparator);
            } else {
                TmfSimpleTableViewer.this.fTableViewer.setComparator(new ElementComparator(comparator));
            }
        }
    }

    private static class ElementComparator<T>
    extends ViewerComparator {
        private Comparator<T> elementComparator;

        public ElementComparator(Comparator<T> comparator) {
            this.elementComparator = comparator;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return this.elementComparator.compare(e1, e2);
        }
    }

    private final class MouseColumnListener
    extends MouseAdapter {
        private MouseColumnListener() {
        }

        public void mouseDown(MouseEvent e) {
            ViewerCell cell = TmfSimpleTableViewer.this.fTableViewer.getCell(new Point(e.x, e.y));
            TmfSimpleTableViewer.this.fSelectedColumn = cell != null ? cell.getColumnIndex() : -1;
        }
    }
}

