/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.core.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.core.search.SearchPlugin;
import org.eclipse.wst.common.core.util.RegistryReader;
import org.eclipse.wst.common.core.util.UITester;

public class UIContextDetermination {
    private static final int UNKNOWN = 100;
    public static final String HEADLESS_CONTEXT_LITERAL = "Headless";
    public static final String UI_CONTEXT_LITERAL = "UI";
    public static final int HEADLESS_CONTEXT = 102;
    public static final int UI_CONTEXT = 101;
    private static Map cachedExtensions = null;
    private static int currentContext = 100;

    protected UIContextDetermination() {
    }

    public static Object createInstance(String key) {
        Object result = null;
        if (cachedExtensions == null) {
            UIContextDetermination.initExtensions();
        }
        IConfigurationElement contextSensitiveClass = (IConfigurationElement)cachedExtensions.get(key);
        try {
            if (contextSensitiveClass != null) {
                result = contextSensitiveClass.createExecutableExtension("className");
            }
        }
        catch (CoreException e) {
            SearchPlugin.logError("Problem loading extension not found for key \"" + key + "\".");
            SearchPlugin.logError(e);
        }
        if (result == null) {
            SearchPlugin.logError("Extension not found for key \"" + key + "\".");
        }
        return result;
    }

    public static int getCurrentContext() {
        if (currentContext == 100) {
            currentContext = 102;
            new UITesterRegistryReader().readRegistry();
        }
        return currentContext;
    }

    private static void initExtensions() {
        if (cachedExtensions == null) {
            cachedExtensions = new HashMap();
            new UIContextDeterminationRegistryReader().readRegistry();
        }
    }

    private static int convertLiteral(String literal) {
        return UI_CONTEXT_LITERAL.equals(literal) ? 101 : 102;
    }

    private static class UIContextDeterminationRegistryReader
    extends RegistryReader {
        public static final String UI_CONTEXT_SENSTIVE_CLASS_ELEMENT = "uiContextSensitiveClass";
        public static final String UI_CONTEXT_SENSTIVE_CLASS_KEY_ATTR = "key";
        public static final String UI_CONTEXT_SENSTIVE_CLASS_CLASSNAME_ATTR = "className";
        public static final String UI_CONTEXT_SENSTIVE_CLASS_CONTEXT_ATTR = "context";

        public UIContextDeterminationRegistryReader() {
            super("org.eclipse.wst.common.core", UI_CONTEXT_SENSTIVE_CLASS_ELEMENT);
        }

        @Override
        public boolean readElement(IConfigurationElement element) {
            boolean result = false;
            if (element.getName().equals(UI_CONTEXT_SENSTIVE_CLASS_ELEMENT)) {
                String key = element.getAttribute(UI_CONTEXT_SENSTIVE_CLASS_KEY_ATTR);
                String context = element.getAttribute(UI_CONTEXT_SENSTIVE_CLASS_CONTEXT_ATTR);
                if (!cachedExtensions.containsKey(key) || UIContextDetermination.getCurrentContext() == UIContextDetermination.convertLiteral(context)) {
                    cachedExtensions.put(key, element);
                }
                result = true;
            }
            return result;
        }
    }

    private static class UITesterRegistryReader
    extends RegistryReader {
        public static final String UI_TESTER_ELEMENT = "uiTester";
        public static final String UI_TESTER_CLASSNAME_ATTR = "className";

        public UITesterRegistryReader() {
            super("org.eclipse.wst.common.core", UI_TESTER_ELEMENT);
        }

        @Override
        public boolean readElement(IConfigurationElement element) {
            boolean result = false;
            if (element.getName().equals(UI_TESTER_ELEMENT)) {
                result = true;
                try {
                    UITester tester;
                    if (currentContext != 101 && UITesterRegistryReader.canCreateExecutableExtension(element) && (tester = (UITester)element.createExecutableExtension(UI_TESTER_CLASSNAME_ATTR)).isCurrentContextUI()) {
                        currentContext = 101;
                    }
                }
                catch (Exception exception) {
                    SearchPlugin.logWarning("UIContextDetermination is proceeding in HEADLESS mode");
                }
            }
            return result;
        }

        @Override
        public void readRegistry() {
            super.readRegistry();
            IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jem.util", this.extensionPointId);
            if (point == null) {
                return;
            }
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                boolean recognized = this.readElement(elements[i]);
                if (!recognized) {
                    this.logError(elements[i], "Error processing extension: " + elements[i]);
                }
                ++i;
            }
        }
    }
}

