/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.comparator;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.publisher.eclipse.FeatureParser;
import org.eclipse.equinox.p2.internal.repository.comparator.java.ClassFormatException;
import org.eclipse.equinox.p2.internal.repository.comparator.java.Disassembler;
import org.eclipse.equinox.p2.internal.repository.comparator.java.Messages;
import org.eclipse.equinox.p2.internal.repository.comparator.java.Utility;
import org.eclipse.equinox.p2.publisher.eclipse.Feature;
import org.eclipse.equinox.p2.publisher.eclipse.FeatureEntry;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.tools.comparator.IArtifactComparator;
import org.eclipse.osgi.util.NLS;

public class JarComparator
implements IArtifactComparator {
    private static final String LINE_SEPARATOR = "\n";
    private static final String CLASS_EXTENSION = ".class";
    private static final String JAR_EXTENSION = ".jar";
    private static final String PROPERTIES_EXTENSION = ".properties";
    private static final String MAPPINGS_EXTENSION = ".mappings";
    private static final String PLUGIN_ID = "org.eclipse.equinox.p2.repository.tools";
    private static final String DESTINATION_ARTIFACT_PREFIX = "destinationartifact";
    private static final String SUFFIX_JAR = ".jar";
    private static final String SOURCE_ARTIFACT_PREFIX = "sourceartifact";
    private static final String OSGI_BUNDLE_CLASSIFIER = "osgi.bundle";
    private static final String FEATURE_CLASSIFIER = "org.eclipse.update.feature";
    private static final String META_INF = "meta-inf/";
    private static final String DSA_EXT = ".dsa";
    private static final String RSA_EXT = ".rsa";
    private static final String SF_EXT = ".sf";
    private String sourceLocation;
    private String destinationLocation;
    private String descriptorString;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus compare(IArtifactRepository source, IArtifactDescriptor sourceDescriptor, IArtifactRepository destination, IArtifactDescriptor destinationDescriptor) {
        String classifier2;
        this.sourceLocation = URIUtil.toUnencodedString((URI)sourceDescriptor.getRepository().getLocation());
        this.destinationLocation = URIUtil.toUnencodedString((URI)destinationDescriptor.getRepository().getLocation());
        this.descriptorString = sourceDescriptor.toString();
        String classifier1 = sourceDescriptor.getArtifactKey().getClassifier();
        if (!classifier1.equals(classifier2 = destinationDescriptor.getArtifactKey().getClassifier())) return Status.OK_STATUS;
        if (!OSGI_BUNDLE_CLASSIFIER.equals(classifier1) && !FEATURE_CLASSIFIER.equals(classifier1)) {
            return Status.OK_STATUS;
        }
        File firstTempFile = null;
        File secondTempFile = null;
        try {
            block11: {
                IStatus iStatus;
                block12: {
                    try {
                        firstTempFile = this.getLocalJarFile(source, sourceDescriptor, SOURCE_ARTIFACT_PREFIX);
                        secondTempFile = this.getLocalJarFile(destination, destinationDescriptor, DESTINATION_ARTIFACT_PREFIX);
                        if (classifier1.equals(OSGI_BUNDLE_CLASSIFIER)) {
                            IStatus iStatus2 = this.compare(firstTempFile, secondTempFile);
                            Object var10_12 = null;
                            if (firstTempFile != null) {
                                firstTempFile.delete();
                            }
                            if (secondTempFile == null) return iStatus2;
                            secondTempFile.delete();
                            return iStatus2;
                        }
                        if (!classifier1.equals(FEATURE_CLASSIFIER)) break block11;
                        iStatus = this.compareFeatures(firstTempFile, secondTempFile);
                        Object var10_13 = null;
                        if (firstTempFile == null) break block12;
                        firstTempFile.delete();
                    }
                    catch (CoreException e) {
                        IStatus iStatus3 = e.getStatus();
                        Object var10_14 = null;
                        if (firstTempFile != null) {
                            firstTempFile.delete();
                        }
                        if (secondTempFile == null) return iStatus3;
                        secondTempFile.delete();
                        return iStatus3;
                    }
                }
                if (secondTempFile == null) return iStatus;
                secondTempFile.delete();
                return iStatus;
            }
            Object var10_16 = null;
            if (firstTempFile != null) {
                firstTempFile.delete();
            }
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            if (firstTempFile != null) {
                firstTempFile.delete();
            }
            if (secondTempFile == null) throw throwable;
            secondTempFile.delete();
            throw throwable;
        }
        if (secondTempFile == null) return Status.OK_STATUS;
        secondTempFile.delete();
        return Status.OK_STATUS;
    }

    public IStatus compareFeatures(File sourceFile, File destinationFile) {
        FeatureEntry[] entries2;
        FeatureParser parser = new FeatureParser();
        Feature feature1 = parser.parse(sourceFile);
        Feature feature2 = parser.parse(destinationFile);
        MultiStatus parent = new MultiStatus(PLUGIN_ID, 0, NLS.bind((String)Messages.differentEntry, (Object[])new String[]{this.descriptorString, this.sourceLocation, this.destinationLocation}), null);
        if (!feature1.getId().equals(feature2.getId())) {
            parent.add(this.newErrorStatus(NLS.bind((String)Messages.featureIdsDontMatch, (Object)feature1.getId(), (Object)feature2.getId())));
        }
        if (!feature1.getVersion().equals(feature2.getVersion())) {
            parent.add(this.newErrorStatus(NLS.bind((String)Messages.featureVersionsDontMatch, (Object)feature1.getVersion(), (Object)feature2.getVersion())));
        }
        HashMap<FeatureEntryWrapper, FeatureEntry> entryMap = new HashMap<FeatureEntryWrapper, FeatureEntry>();
        FeatureEntry[] entries1 = feature1.getEntries();
        if (entries1.length != (entries2 = feature2.getEntries()).length) {
            parent.add(this.newErrorStatus(Messages.featureSize));
        }
        int i = 0;
        while (i < entries1.length) {
            entryMap.put(new FeatureEntryWrapper(entries1[i]), entries1[i]);
            ++i;
        }
        i = 0;
        while (i < entries2.length) {
            FeatureEntry firstEntry = (FeatureEntry)entryMap.get(new FeatureEntryWrapper(entries2[i]));
            if (firstEntry == null) {
                parent.add(this.newErrorStatus(NLS.bind((String)Messages.featureEntry, (Object)entries2[i])));
            } else {
                if (firstEntry.isOptional() != entries2[i].isOptional()) {
                    parent.add(this.newErrorStatus(NLS.bind((String)Messages.featureEntryOptional, (Object)entries2[i])));
                }
                if (firstEntry.isUnpack() != entries2[i].isUnpack()) {
                    parent.add(this.newErrorStatus(NLS.bind((String)Messages.featureEntryUnpack, (Object)entries2[i])));
                }
                if (firstEntry.isRequires() && firstEntry.getMatch() != null && !firstEntry.getMatch().equals(entries2[i].getMatch())) {
                    parent.add(this.newErrorStatus(NLS.bind((String)Messages.featureEntryMatch, (Object)entries2[i])));
                }
                if (firstEntry.getFilter() != null && !firstEntry.getFilter().equals(entries2[i].getFilter())) {
                    parent.add(this.newErrorStatus(NLS.bind((String)Messages.featureEntryFilter, (Object)entries2[i])));
                }
            }
            ++i;
        }
        return parent.getChildren().length == 0 ? Status.OK_STATUS : parent;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus compare(File sourceFile, File destinationFile) {
        ZipFile secondFile;
        ZipFile firstFile;
        block15: {
            MultiStatus multiStatus;
            block14: {
                MultiStatus multiStatus2;
                block12: {
                    firstFile = null;
                    secondFile = null;
                    try {
                        try {
                            firstFile = new ZipFile(sourceFile);
                            secondFile = new ZipFile(destinationFile);
                            int firstFileSize = firstFile.size();
                            int secondFileSize = secondFile.size();
                            MultiStatus parent = new MultiStatus(PLUGIN_ID, 0, NLS.bind((String)Messages.differentEntry, (Object[])new String[]{this.descriptorString, this.sourceLocation, this.destinationLocation}), null);
                            if (firstFileSize != secondFileSize) {
                                parent.add(this.newErrorStatus(NLS.bind((String)Messages.differentNumberOfEntries, (Object[])new String[]{this.descriptorString, this.sourceLocation, Integer.toString(firstFileSize), this.destinationLocation, Integer.toString(secondFileSize)})));
                                multiStatus2 = parent;
                                Object var22_12 = null;
                                break block12;
                            }
                            Enumeration<? extends ZipEntry> enumeration = firstFile.entries();
                            while (enumeration.hasMoreElements()) {
                                IStatus result;
                                block13: {
                                    ZipEntry entry = enumeration.nextElement();
                                    String entryName = entry.getName();
                                    ZipEntry entry2 = secondFile.getEntry(entryName);
                                    result = null;
                                    if (!entry.isDirectory() && entry2 != null) {
                                        Object var20_27;
                                        String lowerCase = entryName.toLowerCase();
                                        if (this.isSigningEntry(lowerCase)) continue;
                                        BufferedInputStream firstStream = null;
                                        BufferedInputStream secondStream = null;
                                        try {
                                            long size2;
                                            long size1;
                                            firstStream = new BufferedInputStream(firstFile.getInputStream(entry));
                                            secondStream = new BufferedInputStream(secondFile.getInputStream(entry2));
                                            result = lowerCase.endsWith(CLASS_EXTENSION) ? this.compareClasses(entryName, firstStream, entry.getSize(), secondStream, entry2.getSize()) : (lowerCase.endsWith(".jar") ? this.compareNestedJars(firstStream, entry.getSize(), secondStream, entry2.getSize(), entryName) : (lowerCase.endsWith(PROPERTIES_EXTENSION) || lowerCase.endsWith(MAPPINGS_EXTENSION) ? this.compareProperties(entryName, firstStream, secondStream) : (entryName.equalsIgnoreCase("META-INF/MANIFEST.MF") ? this.compareManifest(firstStream, secondStream) : ((size1 = entry.getSize()) != (size2 = entry2.getSize()) ? this.newErrorStatus(NLS.bind((String)Messages.binaryDifferentLength, (Object[])new String[]{entryName, String.valueOf(Math.abs(size1 - size2))})) : this.compareBytes(entryName, firstStream, entry.getSize(), secondStream, entry2.getSize())))));
                                        }
                                        catch (Throwable throwable) {
                                            var20_27 = null;
                                            Utility.close(firstStream);
                                            Utility.close(secondStream);
                                            throw throwable;
                                        }
                                        {
                                            var20_27 = null;
                                            Utility.close(firstStream);
                                            Utility.close(secondStream);
                                            break block13;
                                        }
                                    }
                                    if (!entry.isDirectory()) {
                                        result = this.newErrorStatus(NLS.bind((String)Messages.missingEntry, (Object[])new String[]{entryName, this.descriptorString, this.sourceLocation}));
                                    }
                                }
                                if (result == null || result.isOK()) continue;
                                parent.add(result);
                                multiStatus = parent;
                                break block14;
                            }
                            break block15;
                        }
                        catch (IOException e) {
                            IStatus iStatus = this.newErrorStatus(NLS.bind((String)Messages.ioexception, (Object[])new String[]{sourceFile.getAbsolutePath(), destinationFile.getAbsolutePath()}), e);
                            Object var22_14 = null;
                            Utility.close(firstFile);
                            Utility.close(secondFile);
                            return iStatus;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var22_15 = null;
                        Utility.close(firstFile);
                        Utility.close(secondFile);
                        throw throwable;
                    }
                }
                Utility.close(firstFile);
                Utility.close(secondFile);
                return multiStatus2;
            }
            Object var22_13 = null;
            Utility.close(firstFile);
            Utility.close(secondFile);
            return multiStatus;
        }
        Object var22_16 = null;
        Utility.close(firstFile);
        Utility.close(secondFile);
        return Status.OK_STATUS;
    }

    private IStatus compareManifest(InputStream firstStream, InputStream secondStream) throws IOException {
        Manifest manifest = new Manifest(firstStream);
        Manifest manifest2 = new Manifest(secondStream);
        if (manifest == null || manifest2 == null) {
            return Status.OK_STATUS;
        }
        Attributes attributes = manifest.getMainAttributes();
        Attributes attributes2 = manifest2.getMainAttributes();
        if (attributes.size() != attributes2.size()) {
            return this.newErrorStatus(NLS.bind((String)Messages.manifestDifferentSize, (Object)String.valueOf(Math.abs(attributes.size() - attributes2.size()))));
        }
        Iterator<Map.Entry<Object, Object>> iterator = attributes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            Object value2 = attributes2.get(entry.getKey());
            if (value2 == null) {
                return this.newErrorStatus(NLS.bind((String)Messages.manifestMissingEntry, (Object)entry.getKey()));
            }
            if (value2.equals(entry.getValue())) continue;
            return this.newErrorStatus(NLS.bind((String)Messages.manifestDifferentValue, (Object)entry.getKey()));
        }
        return Status.OK_STATUS;
    }

    private IStatus compareClasses(String entryName, InputStream stream1, long size1, InputStream stream2, long size2) throws IOException {
        Disassembler disassembler = new Disassembler();
        byte[] firstEntryClassFileBytes = Utility.getInputStreamAsByteArray(stream1, (int)size1);
        byte[] secondEntryClassFileBytes = Utility.getInputStreamAsByteArray(stream2, (int)size2);
        String contentsFile1 = null;
        try {
            contentsFile1 = disassembler.disassemble(firstEntryClassFileBytes, LINE_SEPARATOR, 9);
        }
        catch (ClassFormatException classFormatException) {}
        String contentsFile2 = null;
        try {
            contentsFile2 = disassembler.disassemble(secondEntryClassFileBytes, LINE_SEPARATOR, 9);
        }
        catch (ClassFormatException classFormatException) {}
        if (contentsFile1 == null || contentsFile2 == null) {
            if (contentsFile1 == null) {
                if (contentsFile2 != null) {
                    return this.newErrorStatus(NLS.bind((String)Messages.classesDifferent, (Object)entryName));
                }
                if (!Arrays.equals(firstEntryClassFileBytes, secondEntryClassFileBytes)) {
                    return this.newErrorStatus(NLS.bind((String)Messages.binaryFilesDifferent, (Object)entryName));
                }
                return Status.OK_STATUS;
            }
            return this.newErrorStatus(NLS.bind((String)Messages.classesDifferent, (Object)entryName));
        }
        if (!contentsFile1.equals(contentsFile2)) {
            return this.newErrorStatus(NLS.bind((String)Messages.classesDifferent, (Object)entryName));
        }
        return Status.OK_STATUS;
    }

    private IStatus compareNestedJars(InputStream stream1, long size1, InputStream stream2, long size2, String entry) throws IOException {
        IStatus iStatus;
        File secondTempFile;
        block4: {
            File firstTempFile = this.getLocalJarFile(stream1, entry, size1);
            secondTempFile = this.getLocalJarFile(stream2, entry, size2);
            try {
                iStatus = this.compare(firstTempFile, secondTempFile);
                Object var10_9 = null;
                if (firstTempFile == null) break block4;
                firstTempFile.delete();
            }
            catch (Throwable throwable) {
                block5: {
                    Object var10_10 = null;
                    if (firstTempFile != null) {
                        firstTempFile.delete();
                    }
                    if (secondTempFile == null) break block5;
                    secondTempFile.delete();
                }
                throw throwable;
            }
        }
        if (secondTempFile != null) {
            secondTempFile.delete();
        }
        return iStatus;
    }

    private IStatus compareProperties(String entryName, InputStream stream1, InputStream stream2) {
        Properties props1 = this.loadProperties(stream1);
        Properties props2 = this.loadProperties(stream2);
        if (props1.size() != props2.size()) {
            return this.newErrorStatus(NLS.bind((String)Messages.propertiesSizesDifferent, (Object)entryName, (Object)String.valueOf(Math.abs(props1.size() - props2.size()))));
        }
        props1.keys();
        Iterator<Object> iterator = props1.keySet().iterator();
        while (iterator.hasNext()) {
            String prop2;
            String key = (String)iterator.next();
            if (!props2.containsKey(key)) {
                return this.newErrorStatus(NLS.bind((String)Messages.missingProperty, (Object)key, (Object)entryName));
            }
            String prop1 = props1.getProperty(key);
            if (prop1.equals(prop2 = props2.getProperty(key))) continue;
            if (prop1.length() < 15 && prop2.length() < 15) {
                return this.newErrorStatus(NLS.bind((String)Messages.differentPropertyValueFull, (Object[])new String[]{entryName, key, prop1, prop2}));
            }
            String[] diff = this.extractDifference(prop1, prop2);
            return this.newErrorStatus(NLS.bind((String)Messages.differentPropertyValueFull, (Object[])new String[]{entryName, key, diff[0], diff[1]}));
        }
        return Status.OK_STATUS;
    }

    private String[] extractDifference(String s1, String s2) {
        int i = 0;
        while (i < s1.length() && i < s2.length()) {
            if (s1.charAt(i) != s2.charAt(i)) {
                String result2;
                String result1;
                if (i > 3) {
                    boolean truncated = i + 7 < s1.length();
                    result1 = "..." + s1.substring(i - 3, truncated ? i + 7 : s1.length()) + (truncated ? "..." : "");
                    truncated = i + 7 < s2.length();
                    result2 = "..." + s2.substring(i - 3, truncated ? i + 7 : s2.length()) + (truncated ? "..." : "");
                } else {
                    boolean truncated = i + 10 < s1.length();
                    result1 = String.valueOf(s1.substring(0, truncated ? i + 10 : s1.length())) + (truncated ? "..." : "");
                    truncated = i + 10 < s2.length();
                    result2 = String.valueOf(s2.substring(0, truncated ? i + 10 : s2.length())) + (truncated ? "..." : "");
                }
                return new String[]{result1, result2};
            }
            ++i;
        }
        return new String[]{s1, s2};
    }

    private IStatus compareBytes(String entryName, InputStream firstStream, long size1, InputStream secondStream, long size2) throws IOException {
        byte[] secondBytes;
        byte[] firstBytes = Utility.getInputStreamAsByteArray(firstStream, (int)size1);
        if (!Arrays.equals(firstBytes, secondBytes = Utility.getInputStreamAsByteArray(secondStream, (int)size2))) {
            return this.newErrorStatus(NLS.bind((String)Messages.binaryFilesDifferent, (Object)entryName));
        }
        return Status.OK_STATUS;
    }

    private Properties loadProperties(InputStream input) {
        Properties result = new Properties();
        try {
            result.load(input);
        }
        catch (IOException iOException) {}
        return result;
    }

    private String normalize(String entryName) {
        StringBuffer buffer = new StringBuffer();
        char[] chars = entryName.toCharArray();
        int i = 0;
        int max = chars.length;
        while (i < max) {
            char currentChar = chars[i];
            if (!Character.isJavaIdentifierPart(currentChar)) {
                buffer.append('_');
            } else {
                buffer.append(currentChar);
            }
            ++i;
        }
        return String.valueOf(buffer);
    }

    private IStatus newErrorStatus(String message, Exception e) {
        return new Status(4, PLUGIN_ID, message, (Throwable)e);
    }

    private IStatus newErrorStatus(String message) {
        return this.newErrorStatus(message, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File getLocalJarFile(IArtifactRepository repository, IArtifactDescriptor descriptor, String prefix) throws CoreException {
        File file = null;
        BufferedOutputStream stream = null;
        try {
            try {
                file = File.createTempFile(prefix, ".jar");
                stream = new BufferedOutputStream(new FileOutputStream(file));
                IStatus status = repository.getArtifact(descriptor, (OutputStream)stream, (IProgressMonitor)new NullProgressMonitor());
                if (!status.isOK()) {
                    throw new CoreException(status);
                }
                stream.flush();
            }
            catch (FileNotFoundException e) {
                throw new CoreException(this.newErrorStatus("FileNotFoundException", e));
            }
            catch (IOException e) {
                throw new CoreException(this.newErrorStatus("IOException", e));
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            Utility.close(stream);
            throw throwable;
        }
        {
            Object var7_11 = null;
        }
        Utility.close(stream);
        return file;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File getLocalJarFile(InputStream inputStream, String entry, long size) throws IOException {
        byte[] firstEntryClassFileBytes = Utility.getInputStreamAsByteArray(inputStream, (int)size);
        File tempFile = null;
        BufferedOutputStream stream = null;
        try {
            tempFile = File.createTempFile(SOURCE_ARTIFACT_PREFIX + this.normalize(entry), ".jar");
            stream = new BufferedOutputStream(new FileOutputStream(tempFile));
            stream.write(firstEntryClassFileBytes);
            stream.flush();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            Utility.close(stream);
            throw throwable;
        }
        {
            Object var8_9 = null;
        }
        Utility.close(stream);
        return tempFile;
    }

    private boolean isSigningEntry(String entry) {
        return entry.startsWith(META_INF) && (entry.endsWith(SF_EXT) || entry.endsWith(RSA_EXT) || entry.endsWith(DSA_EXT));
    }

    private static class FeatureEntryWrapper {
        private FeatureEntry entry;

        public FeatureEntryWrapper(FeatureEntry entry) {
            this.entry = entry;
        }

        public boolean equals(Object o) {
            FeatureEntry otherEntry;
            FeatureEntry featureEntry = otherEntry = o instanceof FeatureEntryWrapper ? ((FeatureEntryWrapper)o).getEntry() : null;
            if (otherEntry == null || !this.entry.equals((Object)otherEntry)) {
                return false;
            }
            String arch = otherEntry.getArch();
            if (arch == null ? this.entry.getArch() != null : !arch.equals(this.entry.getArch())) {
                return false;
            }
            String os = otherEntry.getOS();
            if (os == null ? this.entry.getOS() != null : !os.equals(this.entry.getOS())) {
                return false;
            }
            String ws = otherEntry.getWS();
            return !(ws == null ? this.entry.getWS() != null : !ws.equals(this.entry.getWS()));
        }

        public int hashCode() {
            int hash = this.entry.hashCode();
            if (this.entry.getArch() != null) {
                hash += this.entry.getArch().hashCode();
            }
            if (this.entry.getOS() != null) {
                hash += this.entry.getOS().hashCode();
            }
            if (this.entry.getWS() != null) {
                hash += this.entry.getWS().hashCode();
            }
            return hash;
        }

        public FeatureEntry getEntry() {
            return this.entry;
        }
    }
}

