/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.extend;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.MatchingFrameValueProvider;
import org.eclipse.viatra.query.runtime.localsearch.operations.extend.SingleValueExtendOperationExecutor;
import org.eclipse.viatra.query.runtime.matchers.psystem.IExpressionEvaluator;
import org.eclipse.viatra.query.runtime.matchers.psystem.IValueProvider;

public class ExpressionEval
implements ISearchOperation {
    private final IExpressionEvaluator evaluator;
    private final Map<String, Integer> nameMap;
    private final int position;

    public ExpressionEval(IExpressionEvaluator evaluator, Map<String, Integer> nameMap, int position) {
        this.evaluator = evaluator;
        this.nameMap = nameMap;
        this.position = position;
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    @Override
    public String toString(Function<Integer, String> variableMapping) {
        return "extend    -" + variableMapping.apply(this.position) + " = expression " + this.evaluator.getShortDescription();
    }

    @Override
    public ISearchOperation.ISearchOperationExecutor createExecutor() {
        return new Executor(this.position);
    }

    @Override
    public List<Integer> getVariablePositions() {
        ArrayList<Integer> variables = new ArrayList<Integer>();
        variables.addAll(this.nameMap.values());
        return variables;
    }

    private class Executor
    extends SingleValueExtendOperationExecutor<Object> {
        public Executor(int position) {
            super(position);
        }

        @Override
        public Iterator<?> getIterator(MatchingFrame frame, ISearchContext context) {
            try {
                Object result = ExpressionEval.this.evaluator.evaluateExpression((IValueProvider)new MatchingFrameValueProvider(frame, ExpressionEval.this.nameMap));
                if (result != null) {
                    return Collections.singletonList(result).iterator();
                }
                return Collections.emptyIterator();
            }
            catch (Exception e) {
                context.getLogger().warn((Object)"Error while evaluating expression", (Throwable)e);
                return Collections.emptyIterator();
            }
        }

        @Override
        public ISearchOperation getOperation() {
            return ExpressionEval.this;
        }
    }
}

