/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.context.surrogate;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.viatra.query.runtime.matchers.util.IProvider;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;
import org.eclipse.viatra.query.runtime.matchers.util.SingletonInstanceProvider;

public class SurrogateQueryRegistry {
    private Map<IInputKey, IProvider<PQuery>> registeredSurrogateQueryMap = new HashMap<IInputKey, IProvider<PQuery>>();
    private Map<IInputKey, IProvider<PQuery>> dynamicSurrogateQueryMap = new HashMap<IInputKey, IProvider<PQuery>>();
    private static final SurrogateQueryRegistry INSTANCE = new SurrogateQueryRegistry();

    private SurrogateQueryRegistry() {
    }

    public static SurrogateQueryRegistry instance() {
        return INSTANCE;
    }

    public IProvider<PQuery> registerSurrogateQueryForFeature(IInputKey feature, PQuery surrogateQuery) {
        Preconditions.checkArgument(surrogateQuery != null, "Surrogate query must not be null!");
        return this.registerSurrogateQueryForFeature(feature, new SingletonInstanceProvider<PQuery>(surrogateQuery));
    }

    public IProvider<PQuery> registerSurrogateQueryForFeature(IInputKey feature, IProvider<PQuery> surrogateQueryProvider) {
        Preconditions.checkArgument(feature != null, "Feature must not be null!");
        Preconditions.checkArgument(surrogateQueryProvider != null, "Surrogate query must not be null!");
        return this.registeredSurrogateQueryMap.put(feature, surrogateQueryProvider);
    }

    public IProvider<PQuery> addDynamicSurrogateQueryForFeature(IInputKey feature, PQuery surrogateQuery) {
        Preconditions.checkArgument(surrogateQuery != null, "Surrogate query FQN must not be null!");
        return this.addDynamicSurrogateQueryForFeature(feature, new SingletonInstanceProvider<PQuery>(surrogateQuery));
    }

    public IProvider<PQuery> addDynamicSurrogateQueryForFeature(IInputKey feature, IProvider<PQuery> surrogateQuery) {
        Preconditions.checkArgument(feature != null, "Feature must not be null!");
        Preconditions.checkArgument(surrogateQuery != null, "Surrogate query FQN must not be null!");
        return this.dynamicSurrogateQueryMap.put(feature, surrogateQuery);
    }

    public IProvider<PQuery> removeDynamicSurrogateQueryForFeature(IInputKey feature) {
        Preconditions.checkArgument(feature != null, "Feature must not be null!");
        return this.dynamicSurrogateQueryMap.remove(feature);
    }

    public boolean hasSurrogateQueryFQN(IInputKey feature) {
        Preconditions.checkArgument(feature != null, "Feature must not be null!");
        boolean surrogateExists = this.dynamicSurrogateQueryMap.containsKey(feature);
        if (!surrogateExists) {
            surrogateExists = this.registeredSurrogateQueryMap.containsKey(feature);
        }
        return surrogateExists;
    }

    public PQuery getSurrogateQuery(IInputKey feature) {
        Preconditions.checkArgument(feature != null, "Feature must not be null!");
        IProvider<PQuery> surrogate = this.dynamicSurrogateQueryMap.get(feature);
        if (surrogate == null) {
            surrogate = this.registeredSurrogateQueryMap.get(feature);
        }
        if (surrogate != null) {
            return (PQuery)surrogate.get();
        }
        throw new NoSuchElementException(String.format("Feature %s has no surrogate query defined! Use #hasSurrogateQueryFQN to check existence.", feature));
    }

    public Set<IInputKey> getRegisteredSurrogateQueries() {
        return Collections.unmodifiableSet(this.getRegisteredSurrogateQueriesInternal());
    }

    private Set<IInputKey> getRegisteredSurrogateQueriesInternal() {
        return this.registeredSurrogateQueryMap.keySet();
    }

    public Set<IInputKey> getDynamicSurrogateQueries() {
        return Collections.unmodifiableSet(this.getDynamicSurrogateQueriesInternal());
    }

    private Set<IInputKey> getDynamicSurrogateQueriesInternal() {
        return this.dynamicSurrogateQueryMap.keySet();
    }

    public Set<IInputKey> getAllSurrogateQueries() {
        HashSet<IInputKey> results = new HashSet<IInputKey>(this.getRegisteredSurrogateQueriesInternal());
        results.addAll(this.getDynamicSurrogateQueriesInternal());
        return results;
    }
}

