/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.scopes.tables;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.scopes.tables.AbstractIndexTable;
import org.eclipse.viatra.query.runtime.matchers.scopes.tables.ITableContext;
import org.eclipse.viatra.query.runtime.matchers.scopes.tables.ITableWriterBinary;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;
import org.eclipse.viatra.query.runtime.matchers.util.Accuracy;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.Direction;
import org.eclipse.viatra.query.runtime.matchers.util.IMemoryView;
import org.eclipse.viatra.query.runtime.matchers.util.IMultiLookup;

public class SimpleBinaryTable<Source, Target>
extends AbstractIndexTable
implements ITableWriterBinary.Table<Source, Target> {
    private IMultiLookup<Target, Source> valueToHolderMap;
    private IMultiLookup<Source, Target> holderToValueMap;
    private int totalRowCount = 0;
    private boolean unique;

    public SimpleBinaryTable(IInputKey inputKey, ITableContext tableContext, boolean unique) {
        super(inputKey, tableContext);
        this.unique = unique;
        this.valueToHolderMap = CollectionsFactory.createMultiLookup(Object.class, unique ? CollectionsFactory.MemoryType.SETS : CollectionsFactory.MemoryType.MULTISETS, Object.class);
        if (2 != inputKey.getArity()) {
            throw new IllegalArgumentException(inputKey.toString());
        }
    }

    @Override
    public void write(Direction direction, Source holder, Target value) {
        block11: {
            if (direction == Direction.INSERT) {
                try {
                    boolean changed = this.addToValueToHolderMap(value, holder);
                    if (this.holderToValueMap != null) {
                        this.addToHolderToValueMap(value, holder);
                    }
                    if (!changed) break block11;
                    ++this.totalRowCount;
                    if (this.emitNotifications) {
                        this.deliverChangeNotifications(Tuples.staticArityFlatTupleOf(holder, value), true);
                    }
                }
                catch (IllegalStateException ex) {
                    String msg = String.format("Error: trying to add duplicate value %s to the unique feature %s of host object %s. This indicates some errors in underlying model representation.", value, this.getInputKey().getPrettyPrintableName(), holder);
                    this.logError(msg);
                }
            } else {
                try {
                    boolean changed = this.removeFromValueToHolderMap(value, holder);
                    if (this.holderToValueMap != null) {
                        this.removeFromHolderToValueMap(value, holder);
                    }
                    if (changed) {
                        --this.totalRowCount;
                        if (this.emitNotifications) {
                            this.deliverChangeNotifications(Tuples.staticArityFlatTupleOf(holder, value), false);
                        }
                    }
                }
                catch (IllegalStateException ex) {
                    String msg = String.format("Error: trying to remove non-existing value %s from the feature %s of host object %s. This indicates some errors in underlying model representation.", value, this.getInputKey().getPrettyPrintableName(), holder);
                    this.logError(msg);
                }
            }
        }
    }

    private boolean addToHolderToValueMap(Target value, Source holder) {
        return IMultiLookup.ChangeGranularity.DUPLICATE != this.holderToValueMap.addPair(holder, value);
    }

    private boolean addToValueToHolderMap(Target value, Source holder) {
        return IMultiLookup.ChangeGranularity.DUPLICATE != this.valueToHolderMap.addPair(value, holder);
    }

    private boolean removeFromHolderToValueMap(Target value, Source holder) {
        return IMultiLookup.ChangeGranularity.DUPLICATE != this.holderToValueMap.removePair(holder, value);
    }

    private boolean removeFromValueToHolderMap(Target value, Source holder) {
        return IMultiLookup.ChangeGranularity.DUPLICATE != this.valueToHolderMap.removePair(value, holder);
    }

    @Override
    public int countTuples(TupleMask seedMask, ITuple seed) {
        switch (seedMask.getSize()) {
            case 0: {
                return this.totalRowCount;
            }
            case 1: {
                int seedIndex = seedMask.indices[0];
                if (seedIndex == 0) {
                    Object source = seed.get(0);
                    return this.getDistinctValuesOfHolder(source).size();
                }
                if (seedIndex == 1) {
                    Object target = seed.get(0);
                    return this.getDistinctHoldersOfValue(target).size();
                }
                throw new IllegalArgumentException(seedMask.toString());
            }
            case 2: {
                Object source = seedMask.getValue(seed, 0);
                Object target = seedMask.getValue(seed, 1);
                if (this.containsRow(source, target)) {
                    return 1;
                }
                return 0;
            }
        }
        throw new IllegalArgumentException(seedMask.toString());
    }

    @Override
    public Optional<Long> estimateProjectionSize(TupleMask groupMask, Accuracy requiredAccuracy) {
        if (groupMask.getSize() == 0) {
            return this.totalRowCount == 0 ? Optional.of(0L) : Optional.of(1L);
        }
        if (groupMask.getSize() == 2) {
            return Optional.of(Long.valueOf(this.totalRowCount));
        }
        if (groupMask.indices[0] == 0) {
            return Optional.of(Long.valueOf(this.getHolderToValueMap().countKeys()));
        }
        return Optional.of(Long.valueOf(this.getValueToHolderMap().countKeys()));
    }

    @Override
    public Stream<? extends Tuple> streamTuples(TupleMask seedMask, ITuple seed) {
        switch (seedMask.getSize()) {
            case 0: {
                return this.getAllDistinctValuesStream().flatMap(value -> this.valueToHolderMap.lookup(value).distinctValues().stream().map(source -> Tuples.staticArityFlatTupleOf(source, value)));
            }
            case 1: {
                int seedIndex = seedMask.indices[0];
                if (seedIndex == 0) {
                    Object source2 = seed.get(0);
                    return this.getDistinctValuesOfHolder(source2).stream().map(target -> Tuples.staticArityFlatTupleOf(source2, target));
                }
                if (seedIndex == 1) {
                    Object target2 = seed.get(0);
                    return this.getDistinctHoldersOfValue(target2).stream().map(source -> Tuples.staticArityFlatTupleOf(source, target2));
                }
                throw new IllegalArgumentException(seedMask.toString());
            }
            case 2: {
                Object source3 = seedMask.getValue(seed, 0);
                Object target3 = seedMask.getValue(seed, 1);
                if (this.containsRow(source3, target3)) {
                    return Stream.of(Tuples.staticArityFlatTupleOf(source3, target3));
                }
                return Stream.empty();
            }
        }
        throw new IllegalArgumentException(seedMask.toString());
    }

    @Override
    public Iterable<? extends Object> enumerateValues(TupleMask seedMask, ITuple seed) {
        if (seedMask.getSize() != 1) {
            throw new IllegalArgumentException(seedMask.toString());
        }
        int seedIndex = seedMask.indices[0];
        if (seedIndex == 0) {
            return this.getDistinctValuesOfHolder(seed.get(0));
        }
        if (seedIndex == 1) {
            return this.getDistinctHoldersOfValue(seed.get(0));
        }
        throw new IllegalArgumentException(seedMask.toString());
    }

    @Override
    public Stream<? extends Object> streamValues(TupleMask seedMask, ITuple seed) {
        if (seedMask.getSize() != 1) {
            throw new IllegalArgumentException(seedMask.toString());
        }
        int seedIndex = seedMask.indices[0];
        if (seedIndex == 0) {
            return this.getDistinctValuesOfHolder(seed.get(0)).stream();
        }
        if (seedIndex == 1) {
            return this.getDistinctHoldersOfValue(seed.get(0)).stream();
        }
        throw new IllegalArgumentException(seedMask.toString());
    }

    @Override
    public boolean containsTuple(ITuple seed) {
        return this.containsRow(seed.get(0), seed.get(1));
    }

    public boolean containsRow(Source source, Target target) {
        if (this.valueToHolderMap != null) {
            IMemoryView<Source> holders = this.valueToHolderMap.lookup(target);
            return holders != null && holders.containsNonZero(source);
        }
        throw new UnsupportedOperationException("TODO implement");
    }

    public Iterable<Source> getAllDistinctHolders() {
        return this.getHolderToValueMap().distinctKeys();
    }

    public Stream<Source> getAllDistinctHoldersStream() {
        return this.getHolderToValueMap().distinctKeysStream();
    }

    public Iterable<Target> getAllDistinctValues() {
        return this.getValueToHolderMap().distinctKeys();
    }

    public Stream<Target> getAllDistinctValuesStream() {
        return this.getValueToHolderMap().distinctKeysStream();
    }

    public Set<Source> getDistinctHoldersOfValue(Target value) {
        IMemoryView<Source> holdersMultiset = this.getValueToHolderMap().lookup(value);
        if (holdersMultiset == null) {
            return Collections.emptySet();
        }
        return holdersMultiset.distinctValues();
    }

    public Set<Target> getDistinctValuesOfHolder(Source holder) {
        IMemoryView<Target> valuesMultiset = this.getHolderToValueMap().lookup(holder);
        if (valuesMultiset == null) {
            return Collections.emptySet();
        }
        return valuesMultiset.distinctValues();
    }

    private IMultiLookup<Source, Target> getHolderToValueMap() {
        if (this.holderToValueMap == null) {
            this.holderToValueMap = CollectionsFactory.createMultiLookup(Object.class, CollectionsFactory.MemoryType.SETS, Object.class);
            for (Target value : this.valueToHolderMap.distinctKeys()) {
                for (Source holder : this.valueToHolderMap.lookup(value).distinctValues()) {
                    this.holderToValueMap.addPair(holder, value);
                }
            }
        }
        return this.holderToValueMap;
    }

    private IMultiLookup<Target, Source> getValueToHolderMap() {
        return this.valueToHolderMap;
    }
}

