/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.annotation.Resource;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.eclipse.jetty.annotations.AnnotationIntrospector;
import org.eclipse.jetty.annotations.Util;
import org.eclipse.jetty.plus.annotation.Injection;
import org.eclipse.jetty.plus.annotation.InjectionCollection;
import org.eclipse.jetty.plus.jndi.NamingEntryUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.webapp.MetaData;
import org.eclipse.jetty.webapp.WebAppContext;

public class ResourceAnnotationHandler
extends AnnotationIntrospector.AbstractIntrospectableAnnotationHandler {
    protected WebAppContext _context;

    public ResourceAnnotationHandler(WebAppContext wac) {
        super(true);
        this._context = wac;
    }

    public void doHandle(Class clazz) {
        if (Util.isServletType(clazz)) {
            this.handleClass(clazz);
            Method[] methods = clazz.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                this.handleMethod(clazz, methods[i]);
            }
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                this.handleField(clazz, fields[i]);
            }
        }
    }

    public void handleClass(Class clazz) {
        Resource resource = clazz.getAnnotation(Resource.class);
        if (resource != null) {
            String name = resource.name();
            String mappedName = resource.mappedName();
            Resource.AuthenticationType auth = resource.authenticationType();
            Class type = resource.type();
            boolean shareable = resource.shareable();
            if (name == null || name.trim().equals("")) {
                throw new IllegalStateException("Class level Resource annotations must contain a name (Common Annotations Spec Section 2.3)");
            }
            try {
                if (!NamingEntryUtil.bindToENC((Object)this._context, (String)name, (String)mappedName) && !NamingEntryUtil.bindToENC((Object)this._context.getServer(), (String)name, (String)mappedName)) {
                    throw new IllegalStateException("No resource at " + (mappedName == null ? name : mappedName));
                }
            }
            catch (NamingException e) {
                Log.warn((Throwable)e);
            }
        }
    }

    public void handleField(Class clazz, Field field) {
        block16: {
            Resource resource = field.getAnnotation(Resource.class);
            if (resource != null) {
                Injection injection;
                if (Modifier.isStatic(field.getModifiers())) {
                    Log.warn((String)("Skipping Resource annotation on " + clazz.getName() + "." + field.getName() + ": cannot be static"));
                    return;
                }
                if (Modifier.isFinal(field.getModifiers())) {
                    Log.warn((String)("Skipping Resource annotation on " + clazz.getName() + "." + field.getName() + ": cannot be final"));
                    return;
                }
                String name = clazz.getCanonicalName() + "/" + field.getName();
                name = resource.name() != null && !resource.name().trim().equals("") ? resource.name() : name;
                String mappedName = resource.mappedName() != null && !resource.mappedName().trim().equals("") ? resource.mappedName() : null;
                Class<?> type = field.getType();
                MetaData metaData = this._context.getMetaData();
                if (metaData.getOriginDescriptor("resource-ref." + name + ".injection") != null) {
                    return;
                }
                InjectionCollection injections = (InjectionCollection)this._context.getAttribute("org.eclipse.jetty.injectionCollection");
                if (injections == null) {
                    injections = new InjectionCollection();
                    this._context.setAttribute("org.eclipse.jetty.injectionCollection", (Object)injections);
                }
                if ((injection = injections.getInjection(name, clazz, field)) == null) {
                    try {
                        boolean bound = NamingEntryUtil.bindToENC((Object)this._context, (String)name, (String)mappedName);
                        if (!bound) {
                            bound = NamingEntryUtil.bindToENC((Object)this._context.getServer(), (String)name, (String)mappedName);
                        }
                        if (!bound) {
                            bound = NamingEntryUtil.bindToENC(null, (String)name, (String)mappedName);
                        }
                        if (!bound) {
                            try {
                                InitialContext ic = new InitialContext();
                                String nameInEnvironment = mappedName != null ? mappedName : name;
                                ic.lookup("java:comp/env/" + nameInEnvironment);
                                bound = true;
                            }
                            catch (NameNotFoundException e) {
                                bound = false;
                            }
                        }
                        if (bound) {
                            Log.debug((String)("Bound " + (mappedName == null ? name : mappedName) + " as " + name));
                            injection = new Injection();
                            injection.setTarget(clazz, field, type);
                            injection.setJndiName(name);
                            injection.setMappingName(mappedName);
                            injections.add(injection);
                            metaData.setOrigin("resource-ref." + name + ".injection");
                        } else if (!Util.isEnvEntryType(type)) {
                            throw new IllegalStateException("No resource at " + (mappedName == null ? name : mappedName));
                        }
                    }
                    catch (NamingException e) {
                        if (Util.isEnvEntryType(type)) break block16;
                        throw new IllegalStateException(e);
                    }
                }
            }
        }
    }

    public void handleMethod(Class clazz, Method method) {
        block18: {
            Resource resource = method.getAnnotation(Resource.class);
            if (resource != null) {
                Injection injection;
                if (Modifier.isStatic(method.getModifiers())) {
                    Log.warn((String)("Skipping Resource annotation on " + clazz.getName() + "." + method.getName() + ": cannot be static"));
                    return;
                }
                if (!method.getName().startsWith("set")) {
                    Log.warn((String)("Skipping Resource annotation on " + clazz.getName() + "." + method.getName() + ": invalid java bean, does not start with 'set'"));
                    return;
                }
                if (method.getParameterTypes().length != 1) {
                    Log.warn((String)("Skipping Resource annotation on " + clazz.getName() + "." + method.getName() + ": invalid java bean, not single argument to method"));
                    return;
                }
                if (Void.TYPE != method.getReturnType()) {
                    Log.warn((String)("Skipping Resource annotation on " + clazz.getName() + "." + method.getName() + ": invalid java bean, not void"));
                    return;
                }
                String name = method.getName().substring(3);
                name = name.substring(0, 1).toLowerCase() + name.substring(1);
                name = clazz.getCanonicalName() + "/" + name;
                name = resource.name() != null && !resource.name().trim().equals("") ? resource.name() : name;
                String mappedName = resource.mappedName() != null && !resource.mappedName().trim().equals("") ? resource.mappedName() : null;
                Class<?> paramType = method.getParameterTypes()[0];
                Class resourceType = resource.type();
                MetaData metaData = this._context.getMetaData();
                if (metaData.getOriginDescriptor("resource-ref." + name + ".injection") != null) {
                    return;
                }
                InjectionCollection injections = (InjectionCollection)this._context.getAttribute("org.eclipse.jetty.injectionCollection");
                if (injections == null) {
                    injections = new InjectionCollection();
                    this._context.setAttribute("org.eclipse.jetty.injectionCollection", (Object)injections);
                }
                if ((injection = injections.getInjection(name, clazz, method, paramType)) == null) {
                    try {
                        boolean bound = NamingEntryUtil.bindToENC((Object)this._context, (String)name, (String)mappedName);
                        if (!bound) {
                            bound = NamingEntryUtil.bindToENC((Object)this._context.getServer(), (String)name, (String)mappedName);
                        }
                        if (!bound) {
                            bound = NamingEntryUtil.bindToENC(null, (String)name, (String)mappedName);
                        }
                        if (!bound) {
                            try {
                                InitialContext ic = new InitialContext();
                                String nameInEnvironment = mappedName != null ? mappedName : name;
                                ic.lookup("java:comp/env/" + nameInEnvironment);
                                bound = true;
                            }
                            catch (NameNotFoundException e) {
                                bound = false;
                            }
                        }
                        if (bound) {
                            Log.debug((String)("Bound " + (mappedName == null ? name : mappedName) + " as " + name));
                            injection = new Injection();
                            injection.setTarget(clazz, method, paramType, resourceType);
                            injection.setJndiName(name);
                            injection.setMappingName(mappedName);
                            injections.add(injection);
                            metaData.setOrigin("resource-ref." + name + ".injection");
                        } else if (!Util.isEnvEntryType(paramType)) {
                            throw new IllegalStateException("No resource at " + (mappedName == null ? name : mappedName));
                        }
                    }
                    catch (NamingException e) {
                        if (Util.isEnvEntryType(paramType)) break block18;
                        throw new IllegalStateException(e);
                    }
                }
            }
        }
    }
}

