/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.context;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.AbstractRequestAttributes;
import org.springframework.web.context.request.DestructionCallbackBindingListener;
import org.springframework.web.portlet.util.PortletUtils;

public class PortletRequestAttributes
extends AbstractRequestAttributes {
    public static final String DESTRUCTION_CALLBACK_NAME_PREFIX = String.valueOf(PortletRequestAttributes.class.getName()) + ".DESTRUCTION_CALLBACK.";
    private final PortletRequest request;
    private volatile PortletSession session;
    private final Map<String, Object> sessionAttributesToUpdate = new HashMap<String, Object>();
    private final Map<String, Object> globalSessionAttributesToUpdate = new HashMap<String, Object>();

    public PortletRequestAttributes(PortletRequest request) {
        Assert.notNull((Object)request, (String)"Request must not be null");
        this.request = request;
    }

    public final PortletRequest getRequest() {
        return this.request;
    }

    protected final PortletSession getSession(boolean allowCreate) {
        if (this.isRequestActive()) {
            return this.request.getPortletSession(allowCreate);
        }
        if (this.session == null && allowCreate) {
            throw new IllegalStateException("No session found and request already completed - cannot create new session!");
        }
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String name, int scope) {
        if (scope == 0) {
            if (!this.isRequestActive()) {
                throw new IllegalStateException("Cannot ask for request attribute - request is not active anymore!");
            }
            return this.request.getAttribute(name);
        }
        PortletSession session = this.getSession(false);
        if (session != null) {
            if (scope == 2) {
                Object value = session.getAttribute(name, 1);
                if (value != null) {
                    Map<String, Object> map = this.globalSessionAttributesToUpdate;
                    synchronized (map) {
                        this.globalSessionAttributesToUpdate.put(name, value);
                    }
                }
                return value;
            }
            Object value = session.getAttribute(name);
            if (value != null) {
                Map<String, Object> map = this.sessionAttributesToUpdate;
                synchronized (map) {
                    this.sessionAttributesToUpdate.put(name, value);
                }
            }
            return value;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value, int scope) {
        if (scope == 0) {
            if (!this.isRequestActive()) {
                throw new IllegalStateException("Cannot set request attribute - request is not active anymore!");
            }
            this.request.setAttribute(name, value);
        } else {
            PortletSession session = this.getSession(true);
            if (scope == 2) {
                session.setAttribute(name, value, 1);
                Map<String, Object> map = this.globalSessionAttributesToUpdate;
                synchronized (map) {
                    this.globalSessionAttributesToUpdate.remove(name);
                }
            }
            session.setAttribute(name, value);
            Map<String, Object> map = this.sessionAttributesToUpdate;
            synchronized (map) {
                this.sessionAttributesToUpdate.remove(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name, int scope) {
        if (scope == 0) {
            if (this.isRequestActive()) {
                this.request.removeAttribute(name);
                this.removeRequestDestructionCallback(name);
            }
        } else {
            PortletSession session = this.getSession(false);
            if (session != null) {
                if (scope == 2) {
                    session.removeAttribute(name, 1);
                    Map<String, Object> map = this.globalSessionAttributesToUpdate;
                    synchronized (map) {
                        this.globalSessionAttributesToUpdate.remove(name);
                    }
                }
                session.removeAttribute(name);
                Map<String, Object> map = this.sessionAttributesToUpdate;
                synchronized (map) {
                    this.sessionAttributesToUpdate.remove(name);
                }
            }
        }
    }

    public String[] getAttributeNames(int scope) {
        if (scope == 0) {
            if (!this.isRequestActive()) {
                throw new IllegalStateException("Cannot ask for request attributes - request is not active anymore!");
            }
            return StringUtils.toStringArray((Enumeration)this.request.getAttributeNames());
        }
        PortletSession session = this.getSession(false);
        if (session != null) {
            if (scope == 2) {
                return StringUtils.toStringArray((Enumeration)session.getAttributeNames(1));
            }
            return StringUtils.toStringArray((Enumeration)session.getAttributeNames());
        }
        return new String[0];
    }

    public void registerDestructionCallback(String name, Runnable callback, int scope) {
        if (scope == 0) {
            this.registerRequestDestructionCallback(name, callback);
        } else {
            this.registerSessionDestructionCallback(name, callback);
        }
    }

    public Object resolveReference(String key) {
        if ("request".equals(key)) {
            return this.request;
        }
        if ("session".equals(key)) {
            return this.getSession(true);
        }
        return null;
    }

    public String getSessionId() {
        return this.getSession(true).getId();
    }

    public Object getSessionMutex() {
        return PortletUtils.getSessionMutex(this.getSession(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateAccessedSessionAttributes() {
        Object oldValue;
        Object newValue;
        String name;
        this.session = this.request.getPortletSession(false);
        Map<String, Object> map = this.sessionAttributesToUpdate;
        synchronized (map) {
            if (this.session != null) {
                for (Map.Entry<String, Object> entry : this.sessionAttributesToUpdate.entrySet()) {
                    name = entry.getKey();
                    newValue = entry.getValue();
                    oldValue = this.session.getAttribute(name);
                    if (oldValue != newValue) continue;
                    this.session.setAttribute(name, newValue);
                }
            }
            this.sessionAttributesToUpdate.clear();
        }
        map = this.globalSessionAttributesToUpdate;
        synchronized (map) {
            if (this.session != null) {
                for (Map.Entry<String, Object> entry : this.globalSessionAttributesToUpdate.entrySet()) {
                    name = entry.getKey();
                    newValue = entry.getValue();
                    oldValue = this.session.getAttribute(name, 1);
                    if (oldValue != newValue) continue;
                    this.session.setAttribute(name, newValue, 1);
                }
            }
            this.globalSessionAttributesToUpdate.clear();
        }
    }

    protected void registerSessionDestructionCallback(String name, Runnable callback) {
        PortletSession session = this.getSession(true);
        session.setAttribute(String.valueOf(DESTRUCTION_CALLBACK_NAME_PREFIX) + name, (Object)new DestructionCallbackBindingListener(callback));
    }

    public String toString() {
        return this.request.toString();
    }
}

