/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.joran.action;

import ch.qos.logback.classic.util.JNDIUtil;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.action.ActionUtil;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.util.OptionHelper;
import javax.naming.Context;
import javax.naming.NamingException;
import org.xml.sax.Attributes;

public class InsertFromJNDIAction
extends Action {
    public static String ENV_ENTRY_NAME_ATTR = "env-entry-name";
    public static String AS_ATTR = "as";

    public void begin(InterpretationContext ec, String name, Attributes attributes) {
        String lineColStr;
        int errorCount = 0;
        String envEntryName = ec.subst(attributes.getValue(ENV_ENTRY_NAME_ATTR));
        String asKey = ec.subst(attributes.getValue(AS_ATTR));
        String scopeStr = attributes.getValue("scope");
        ActionUtil.Scope scope = ActionUtil.stringToScope((String)scopeStr);
        if (OptionHelper.isEmpty((String)envEntryName)) {
            lineColStr = this.getLineColStr(ec);
            this.addError("[" + ENV_ENTRY_NAME_ATTR + "] missing, around " + lineColStr);
            ++errorCount;
        }
        if (OptionHelper.isEmpty((String)asKey)) {
            lineColStr = this.getLineColStr(ec);
            this.addError("[" + AS_ATTR + "] missing, around " + lineColStr);
            ++errorCount;
        }
        if (errorCount != 0) {
            return;
        }
        try {
            Context ctx = JNDIUtil.getInitialContext();
            String envEntryValue = JNDIUtil.lookup(ctx, envEntryName);
            if (OptionHelper.isEmpty((String)envEntryValue)) {
                this.addError("[" + envEntryName + "] has null or empty value");
            } else {
                this.addInfo("Setting variable [" + asKey + "] to [" + envEntryValue + "] in [" + scope + "] scope");
                ActionUtil.setProperty((InterpretationContext)ec, (String)asKey, (String)envEntryValue, (ActionUtil.Scope)scope);
            }
        }
        catch (NamingException e) {
            this.addError("Failed to lookup JNDI env-entry [" + envEntryName + "]");
        }
    }

    public void end(InterpretationContext ec, String name) {
    }
}

