/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.repository.internal.management;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.repository.Attribute;
import org.eclipse.virgo.repository.RepositoryAwareArtifactDescriptor;
import org.eclipse.virgo.repository.internal.ArtifactDescriptorDepository;
import org.eclipse.virgo.repository.internal.StandardQuery;
import org.eclipse.virgo.repository.management.ArtifactDescriptorSummary;
import org.eclipse.virgo.repository.management.RepositoryInfo;
import org.eclipse.virgo.util.jmx.ExceptionCleaner;

abstract class AbstractRepositoryInfo
implements RepositoryInfo {
    private final String name;
    private final ArtifactDescriptorDepository artifactDepository;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

    public AbstractRepositoryInfo(String name, ArtifactDescriptorDepository artifactDepository) {
        this.name = name;
        this.artifactDepository = artifactDepository;
    }

    @Override
    public Set<ArtifactDescriptorSummary> getAllArtifactDescriptorSummaries() {
        try {
            Set<RepositoryAwareArtifactDescriptor> artefactDescriptors = this.artifactDepository.resolveArtifactDescriptors(Collections.<Attribute>emptySet());
            HashSet<ArtifactDescriptorSummary> artifactDescriptorSummaries = new HashSet<ArtifactDescriptorSummary>(artefactDescriptors.size());
            for (RepositoryAwareArtifactDescriptor artifactDescriptor : artefactDescriptors) {
                String type = artifactDescriptor.getType();
                String name = artifactDescriptor.getName();
                String version = artifactDescriptor.getVersion().toString();
                artifactDescriptorSummaries.add(new ArtifactDescriptorSummary(type, name, version));
            }
            return artifactDescriptorSummaries;
        }
        catch (Throwable throwable) {
            ExceptionCleaner.aspectOf().ajc$afterThrowing$org_eclipse_virgo_util_jmx_ExceptionCleaner$1$f309547b((Object)this, throwable);
            throw throwable;
        }
    }

    public RepositoryAwareArtifactDescriptor getArtifactDescriptor(String type, String name, String version) {
        Set<RepositoryAwareArtifactDescriptor> artefacts = new StandardQuery(this.artifactDepository, "type", type).addFilter("name", name).addFilter("version", version).run();
        if (artefacts.size() == 1) {
            return artefacts.iterator().next();
        }
        return null;
    }

    @Override
    public String getName() {
        try {
            return this.name;
        }
        catch (Throwable throwable) {
            ExceptionCleaner.aspectOf().ajc$afterThrowing$org_eclipse_virgo_util_jmx_ExceptionCleaner$1$f309547b((Object)this, throwable);
            throw throwable;
        }
    }

    public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
        return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    }

    static {
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.repository.internal.management.AbstractRepositoryInfo");
    }
}

