/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.medic.log.impl.logback;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.status.Status;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.virgo.medic.log.LoggingConfiguration;
import org.eclipse.virgo.medic.log.impl.logback.LoggerContextConfigurationFailedException;
import org.eclipse.virgo.medic.log.impl.logback.LoggerContextConfigurer;
import org.xml.sax.InputSource;

public final class JoranLoggerContextConfigurer
implements LoggerContextConfigurer {
    @Override
    public void applyConfiguration(LoggingConfiguration configuration, LoggerContext loggerContext) throws LoggerContextConfigurationFailedException {
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext((Context)loggerContext);
        String configurationString = configuration.getConfiguration();
        try {
            configurator.doConfigure(new InputSource(new StringReader(configurationString)));
            List statusList = loggerContext.getStatusManager().getCopyOfStatusList();
            ArrayList<String> failureMessages = new ArrayList<String>();
            for (Status status : statusList) {
                if (status.getLevel() == 0) continue;
                Throwable cause = null;
                Throwable t = status.getThrowable();
                if (t != null) {
                    cause = t.getCause();
                }
                failureMessages.add(String.valueOf(status.getMessage()) + (cause != null ? " Caused by " + cause + "." : ""));
            }
            JoranLoggerContextConfigurer.reportFailureIfNecessary(failureMessages);
        }
        catch (JoranException je) {
            throw new LoggerContextConfigurationFailedException("Configuration failed", je);
        }
    }

    private static void reportFailureIfNecessary(List<String> failureMessages) throws LoggerContextConfigurationFailedException {
        if (!failureMessages.isEmpty()) {
            throw new LoggerContextConfigurationFailedException("Configuration failed with the following problems: " + failureMessages);
        }
    }
}

