/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.persistenceunit;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.weaving.LoadTimeWeaverAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.instrument.classloading.InstrumentationLoadTimeWeaver;
import org.springframework.instrument.classloading.LoadTimeWeaver;
import org.springframework.jdbc.datasource.lookup.DataSourceLookup;
import org.springframework.jdbc.datasource.lookup.JndiDataSourceLookup;
import org.springframework.jdbc.datasource.lookup.MapDataSourceLookup;
import org.springframework.orm.jpa.persistenceunit.MutablePersistenceUnitInfo;
import org.springframework.orm.jpa.persistenceunit.PersistenceUnitManager;
import org.springframework.orm.jpa.persistenceunit.PersistenceUnitPostProcessor;
import org.springframework.orm.jpa.persistenceunit.PersistenceUnitReader;
import org.springframework.orm.jpa.persistenceunit.SmartPersistenceUnitInfo;
import org.springframework.orm.jpa.persistenceunit.SpringPersistenceUnitInfo;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPersistenceUnitManager
implements PersistenceUnitManager,
ResourceLoaderAware,
LoadTimeWeaverAware,
InitializingBean {
    public static final String DEFAULT_PERSISTENCE_XML_LOCATION = "classpath*:META-INF/persistence.xml";
    public static final String ORIGINAL_DEFAULT_PERSISTENCE_UNIT_ROOT_LOCATION = "classpath:";
    public static final String ORIGINAL_DEFAULT_PERSISTENCE_UNIT_NAME = "default";
    private static final String ENTITY_CLASS_RESOURCE_PATTERN = "/**/*.class";
    private static final boolean jpa2ApiPresent = ClassUtils.hasMethod(PersistenceUnitInfo.class, (String)"getSharedCacheMode", (Class[])new Class[0]);
    private static final TypeFilter[] entityTypeFilters = new TypeFilter[]{new AnnotationTypeFilter(Entity.class, false), new AnnotationTypeFilter(Embeddable.class, false), new AnnotationTypeFilter(MappedSuperclass.class, false)};
    private String[] persistenceXmlLocations = new String[]{"classpath*:META-INF/persistence.xml"};
    private String defaultPersistenceUnitRootLocation = "classpath:";
    private String defaultPersistenceUnitName = "default";
    private String[] packagesToScan;
    private String[] mappingResources;
    private DataSourceLookup dataSourceLookup = new JndiDataSourceLookup();
    private DataSource defaultDataSource;
    private PersistenceUnitPostProcessor[] persistenceUnitPostProcessors;
    private LoadTimeWeaver loadTimeWeaver;
    private ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
    private final Set<String> persistenceUnitInfoNames = new HashSet<String>();
    private final Map<String, PersistenceUnitInfo> persistenceUnitInfos = new HashMap<String, PersistenceUnitInfo>();

    public void setPersistenceXmlLocation(String persistenceXmlLocation) {
        this.persistenceXmlLocations = new String[]{persistenceXmlLocation};
    }

    public void setPersistenceXmlLocations(String ... persistenceXmlLocations) {
        this.persistenceXmlLocations = persistenceXmlLocations;
    }

    public void setDefaultPersistenceUnitRootLocation(String defaultPersistenceUnitRootLocation) {
        this.defaultPersistenceUnitRootLocation = defaultPersistenceUnitRootLocation;
    }

    public void setDefaultPersistenceUnitName(String defaultPersistenceUnitName) {
        this.defaultPersistenceUnitName = defaultPersistenceUnitName;
    }

    public void setPackagesToScan(String ... packagesToScan) {
        this.packagesToScan = packagesToScan;
    }

    public void setMappingResources(String ... mappingResources) {
        this.mappingResources = mappingResources;
    }

    public void setDataSources(Map<String, DataSource> dataSources) {
        this.dataSourceLookup = new MapDataSourceLookup(dataSources);
    }

    public void setDataSourceLookup(DataSourceLookup dataSourceLookup) {
        this.dataSourceLookup = dataSourceLookup != null ? dataSourceLookup : new JndiDataSourceLookup();
    }

    public DataSourceLookup getDataSourceLookup() {
        return this.dataSourceLookup;
    }

    public void setDefaultDataSource(DataSource defaultDataSource) {
        this.defaultDataSource = defaultDataSource;
    }

    public DataSource getDefaultDataSource() {
        return this.defaultDataSource;
    }

    public void setPersistenceUnitPostProcessors(PersistenceUnitPostProcessor ... postProcessors) {
        this.persistenceUnitPostProcessors = postProcessors;
    }

    public PersistenceUnitPostProcessor[] getPersistenceUnitPostProcessors() {
        return this.persistenceUnitPostProcessors;
    }

    public void setLoadTimeWeaver(LoadTimeWeaver loadTimeWeaver) {
        this.loadTimeWeaver = loadTimeWeaver;
    }

    public LoadTimeWeaver getLoadTimeWeaver() {
        return this.loadTimeWeaver;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourcePatternResolver = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)resourceLoader);
    }

    public void afterPropertiesSet() {
        if (this.loadTimeWeaver == null && InstrumentationLoadTimeWeaver.isInstrumentationAvailable()) {
            this.loadTimeWeaver = new InstrumentationLoadTimeWeaver(this.resourcePatternResolver.getClassLoader());
        }
        this.preparePersistenceUnitInfos();
    }

    public void preparePersistenceUnitInfos() {
        this.persistenceUnitInfoNames.clear();
        this.persistenceUnitInfos.clear();
        List<SpringPersistenceUnitInfo> puis = this.readPersistenceUnitInfos();
        for (SpringPersistenceUnitInfo pui : puis) {
            if (pui.getPersistenceUnitRootUrl() == null) {
                pui.setPersistenceUnitRootUrl(this.determineDefaultPersistenceUnitRootUrl());
            }
            if (pui.getNonJtaDataSource() == null) {
                pui.setNonJtaDataSource(this.defaultDataSource);
            }
            if (this.loadTimeWeaver != null) {
                pui.init(this.loadTimeWeaver);
            } else {
                pui.init(this.resourcePatternResolver.getClassLoader());
            }
            this.postProcessPersistenceUnitInfo(pui);
            String name = pui.getPersistenceUnitName();
            if (!this.persistenceUnitInfoNames.add(name)) {
                StringBuilder msg = new StringBuilder();
                msg.append("Conflicting persistence unit definitions for name '").append(name).append("': ");
                msg.append(pui.getPersistenceUnitRootUrl()).append(", ");
                msg.append(this.persistenceUnitInfos.get(name).getPersistenceUnitRootUrl());
                throw new IllegalStateException(msg.toString());
            }
            SpringPersistenceUnitInfo puiToStore = pui;
            if (jpa2ApiPresent) {
                puiToStore = (PersistenceUnitInfo)Proxy.newProxyInstance(SmartPersistenceUnitInfo.class.getClassLoader(), new Class[]{SmartPersistenceUnitInfo.class}, (InvocationHandler)new Jpa2PersistenceUnitInfoDecorator(pui));
            }
            this.persistenceUnitInfos.put(name, puiToStore);
        }
    }

    private List<SpringPersistenceUnitInfo> readPersistenceUnitInfos() {
        PersistenceUnitReader reader = new PersistenceUnitReader(this.resourcePatternResolver, this.dataSourceLookup);
        LinkedList<SpringPersistenceUnitInfo> infos = new LinkedList<SpringPersistenceUnitInfo>();
        infos.addAll((Collection)Arrays.asList(reader.readPersistenceUnitInfos(this.persistenceXmlLocations)));
        if (this.packagesToScan != null || this.mappingResources != null) {
            infos.add(this.buildDefaultPersistenceUnitInfo());
        }
        return infos;
    }

    private SpringPersistenceUnitInfo buildDefaultPersistenceUnitInfo() {
        int n;
        int n2;
        String[] stringArray;
        SpringPersistenceUnitInfo scannedUnit = new SpringPersistenceUnitInfo();
        scannedUnit.setPersistenceUnitName(this.defaultPersistenceUnitName);
        scannedUnit.excludeUnlistedClasses();
        if (this.packagesToScan != null) {
            stringArray = this.packagesToScan;
            n2 = this.packagesToScan.length;
            n = 0;
            while (n < n2) {
                String pkg = stringArray[n];
                try {
                    String pattern = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)pkg) + ENTITY_CLASS_RESOURCE_PATTERN;
                    Resource[] resources = this.resourcePatternResolver.getResources(pattern);
                    CachingMetadataReaderFactory readerFactory = new CachingMetadataReaderFactory((ResourceLoader)this.resourcePatternResolver);
                    Resource[] resourceArray = resources;
                    int n3 = resources.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Resource resource = resourceArray[n4];
                        if (resource.isReadable()) {
                            MetadataReader reader = readerFactory.getMetadataReader(resource);
                            String className = reader.getClassMetadata().getClassName();
                            if (this.matchesFilter(reader, (MetadataReaderFactory)readerFactory)) {
                                scannedUnit.addManagedClassName(className);
                            }
                        }
                        ++n4;
                    }
                }
                catch (IOException ex) {
                    throw new PersistenceException("Failed to scan classpath for unlisted classes", (Throwable)ex);
                }
                ++n;
            }
        }
        if (this.mappingResources != null) {
            stringArray = this.mappingResources;
            n2 = this.mappingResources.length;
            n = 0;
            while (n < n2) {
                String mappingFileName = stringArray[n];
                scannedUnit.addMappingFileName(mappingFileName);
                ++n;
            }
        }
        return scannedUnit;
    }

    private boolean matchesFilter(MetadataReader reader, MetadataReaderFactory readerFactory) throws IOException {
        TypeFilter[] typeFilterArray = entityTypeFilters;
        int n = entityTypeFilters.length;
        int n2 = 0;
        while (n2 < n) {
            TypeFilter filter = typeFilterArray[n2];
            if (filter.match(reader, readerFactory)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private URL determineDefaultPersistenceUnitRootUrl() {
        if (this.defaultPersistenceUnitRootLocation == null) {
            return null;
        }
        try {
            Resource res = this.resourcePatternResolver.getResource(this.defaultPersistenceUnitRootLocation);
            return res.getURL();
        }
        catch (IOException ex) {
            throw new PersistenceException("Unable to resolve persistence unit root URL", (Throwable)ex);
        }
    }

    protected final MutablePersistenceUnitInfo getPersistenceUnitInfo(String persistenceUnitName) {
        PersistenceUnitInfo pui = this.persistenceUnitInfos.get(persistenceUnitName);
        if (pui != null && Proxy.isProxyClass(pui.getClass())) {
            Jpa2PersistenceUnitInfoDecorator dec = (Jpa2PersistenceUnitInfoDecorator)Proxy.getInvocationHandler(pui);
            return dec.getTarget();
        }
        return (MutablePersistenceUnitInfo)pui;
    }

    protected void postProcessPersistenceUnitInfo(MutablePersistenceUnitInfo pui) {
        PersistenceUnitPostProcessor[] postProcessors = this.getPersistenceUnitPostProcessors();
        if (postProcessors != null) {
            PersistenceUnitPostProcessor[] persistenceUnitPostProcessorArray = postProcessors;
            int n = postProcessors.length;
            int n2 = 0;
            while (n2 < n) {
                PersistenceUnitPostProcessor postProcessor = persistenceUnitPostProcessorArray[n2];
                postProcessor.postProcessPersistenceUnitInfo(pui);
                ++n2;
            }
        }
    }

    @Override
    public PersistenceUnitInfo obtainDefaultPersistenceUnitInfo() {
        if (this.persistenceUnitInfoNames.isEmpty()) {
            throw new IllegalStateException("No persistence units parsed from " + ObjectUtils.nullSafeToString((Object[])this.persistenceXmlLocations));
        }
        if (this.persistenceUnitInfos.isEmpty()) {
            throw new IllegalStateException("All persistence units from " + ObjectUtils.nullSafeToString((Object[])this.persistenceXmlLocations) + " already obtained");
        }
        if (this.persistenceUnitInfos.size() > 1) {
            return this.obtainPersistenceUnitInfo(this.defaultPersistenceUnitName);
        }
        PersistenceUnitInfo pui = this.persistenceUnitInfos.values().iterator().next();
        this.persistenceUnitInfos.clear();
        return pui;
    }

    @Override
    public PersistenceUnitInfo obtainPersistenceUnitInfo(String persistenceUnitName) {
        PersistenceUnitInfo pui = this.persistenceUnitInfos.remove(persistenceUnitName);
        if (pui == null) {
            if (!this.persistenceUnitInfoNames.contains(persistenceUnitName)) {
                throw new IllegalArgumentException("No persistence unit with name '" + persistenceUnitName + "' found");
            }
            throw new IllegalStateException("Persistence unit with name '" + persistenceUnitName + "' already obtained");
        }
        return pui;
    }

    private static class Jpa2PersistenceUnitInfoDecorator
    implements InvocationHandler {
        private final SpringPersistenceUnitInfo target;
        private final Class<? extends Enum> sharedCacheModeEnum;
        private final Class<? extends Enum> validationModeEnum;

        public Jpa2PersistenceUnitInfoDecorator(SpringPersistenceUnitInfo target) {
            this.target = target;
            try {
                this.sharedCacheModeEnum = ClassUtils.forName((String)"javax.persistence.SharedCacheMode", (ClassLoader)PersistenceUnitInfo.class.getClassLoader());
                this.validationModeEnum = ClassUtils.forName((String)"javax.persistence.ValidationMode", (ClassLoader)PersistenceUnitInfo.class.getClassLoader());
            }
            catch (Exception ex) {
                throw new IllegalStateException("JPA 2.0 API enum types not present", ex);
            }
        }

        public final SpringPersistenceUnitInfo getTarget() {
            return this.target;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("getSharedCacheMode")) {
                return Enum.valueOf(this.sharedCacheModeEnum, this.target.getSharedCacheModeName());
            }
            if (method.getName().equals("getValidationMode")) {
                return Enum.valueOf(this.validationModeEnum, this.target.getValidationModeName());
            }
            return method.invoke((Object)this.target, args);
        }
    }
}

