/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.oxm.NodeValue;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.record.MarshalRecord;

public abstract class MappingNodeValue
extends NodeValue {
    public abstract DatabaseMapping getMapping();

    @Override
    public boolean isMappingNodeValue() {
        return true;
    }

    protected void updateNamespaces(QName qname, MarshalRecord marshalRecord, XMLField xmlField) {
        if (qname != null) {
            String prefix;
            if (xmlField != null) {
                if (xmlField.isTypedTextField()) {
                    if (xmlField.getSchemaType() == null ? qname.equals(XMLConstants.STRING_QNAME) : xmlField.isSchemaType(qname)) {
                        return;
                    }
                } else {
                    return;
                }
            }
            if ((prefix = marshalRecord.getNamespaceResolver().resolveNamespaceURI(qname.getNamespaceURI())) == null || prefix.length() == 0) {
                prefix = "http://www.w3.org/2001/XMLSchema".equals(qname.getNamespaceURI()) ? marshalRecord.getNamespaceResolver().generatePrefix("xsd") : marshalRecord.getNamespaceResolver().generatePrefix();
                marshalRecord.namespaceDeclaration(prefix, qname.getNamespaceURI());
            }
            String typeValue = null;
            typeValue = marshalRecord.isNamespaceAware() ? String.valueOf(prefix) + marshalRecord.getNamespaceSeparator() + qname.getLocalPart() : qname.getLocalPart();
            this.addTypeAttribute(marshalRecord, typeValue);
        }
    }

    protected void addTypeAttribute(MarshalRecord marshalRecord, String typeValue) {
        String xsiPrefix = null;
        if (marshalRecord.getNamespaceResolver() != null) {
            xsiPrefix = marshalRecord.getNamespaceResolver().resolveNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
        } else {
            xsiPrefix = "xsi";
            marshalRecord.namespaceDeclaration(xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance");
        }
        if (xsiPrefix == null) {
            xsiPrefix = marshalRecord.getNamespaceResolver().generatePrefix("xsi");
            marshalRecord.namespaceDeclaration(xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance");
        }
        marshalRecord.attributeWithoutQName("http://www.w3.org/2001/XMLSchema-instance", "type", xsiPrefix, typeValue);
    }
}

