/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.model.query;

import java.io.IOException;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.model.Problem;
import org.eclipse.persistence.jpa.jpql.model.query.AbstractIdentificationVariableDeclarationStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.AbstractModifyClauseStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.AbstractStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.IdentificationVariableStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.StateObject;
import org.eclipse.persistence.jpa.jpql.model.query.VariableDeclarationStateObject;
import org.eclipse.persistence.jpa.jpql.parser.RangeVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.util.iterator.IterableListIterator;
import org.eclipse.persistence.jpa.jpql.util.iterator.SingleElementListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRangeVariableDeclarationStateObject
extends AbstractStateObject
implements VariableDeclarationStateObject {
    private boolean as;
    private IdentificationVariableStateObject identificationVariable;
    private boolean identificationVariableOptional;
    private StateObject rootStateObject;
    public static final String AS_PROPERTY = "as";
    public static final String IDENTIFICATION_VARIABLE_PROPERTY = "identificationVariable";

    public AbstractRangeVariableDeclarationStateObject(AbstractIdentificationVariableDeclarationStateObject parent) {
        super(parent);
    }

    public AbstractRangeVariableDeclarationStateObject(AbstractIdentificationVariableDeclarationStateObject parent, String root) {
        super(parent);
        this.setRootPath(root);
    }

    public AbstractRangeVariableDeclarationStateObject(AbstractModifyClauseStateObject parent) {
        super(parent);
        this.setIdentificationVariableOptional(true);
    }

    public AbstractRangeVariableDeclarationStateObject addAs() {
        if (!this.as) {
            this.setAs(true);
        }
        return this;
    }

    @Override
    protected void addChildren(List<StateObject> children) {
        super.addChildren(children);
        children.add(this.rootStateObject);
        children.add(this.identificationVariable);
    }

    @Override
    protected void addProblems(List<Problem> problems) {
        super.addProblems(problems);
    }

    protected abstract StateObject buildRootStateObject();

    @Override
    public RangeVariableDeclaration getExpression() {
        return (RangeVariableDeclaration)super.getExpression();
    }

    public String getIdentificationVariable() {
        return this.identificationVariable.getText();
    }

    public IdentificationVariableStateObject getIdentificationVariableStateObject() {
        return this.identificationVariable;
    }

    public abstract String getRootPath();

    public StateObject getRootStateObject() {
        return this.rootStateObject;
    }

    public boolean hasAs() {
        return this.as;
    }

    public boolean hasIdentificationVariable() {
        return this.identificationVariable.hasText();
    }

    @Override
    public IterableListIterator<IdentificationVariableStateObject> identificationVariables() {
        return new SingleElementListIterator<IdentificationVariableStateObject>(this.identificationVariable);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.rootStateObject = this.buildRootStateObject();
        this.identificationVariable = new IdentificationVariableStateObject(this);
    }

    @Override
    public boolean isEquivalent(StateObject stateObject) {
        if (super.isEquivalent(stateObject)) {
            AbstractRangeVariableDeclarationStateObject declaration = (AbstractRangeVariableDeclarationStateObject)stateObject;
            return this.as == declaration.as && this.identificationVariableOptional == declaration.identificationVariableOptional && this.identificationVariable.isEquivalent(declaration.identificationVariable) && this.areEquivalent(this.rootStateObject, declaration.rootStateObject);
        }
        return false;
    }

    public boolean isIdentificationVariableOptional() {
        return this.identificationVariableOptional;
    }

    public boolean isIdentificationVariableVirtual() {
        return this.identificationVariable.isVirtual();
    }

    public void setAs(boolean as) {
        boolean oldAs = this.as;
        this.as = as;
        this.firePropertyChanged(AS_PROPERTY, oldAs, as);
    }

    public void setExpression(RangeVariableDeclaration expression) {
        super.setExpression(expression);
    }

    public void setIdentificationVariable(String identificationVariable) {
        String oldIdentificationVariable = this.getIdentificationVariable();
        this.identificationVariable.setText(identificationVariable);
        this.firePropertyChanged(IDENTIFICATION_VARIABLE_PROPERTY, oldIdentificationVariable, identificationVariable);
    }

    protected void setIdentificationVariableOptional(boolean identificationVariableOptional) {
        this.identificationVariableOptional = identificationVariableOptional;
    }

    public abstract void setRootPath(String var1);

    public void toggleAs() {
        this.setAs(!this.hasAs());
    }

    @Override
    protected void toTextInternal(Appendable writer) throws IOException {
        this.rootStateObject.toString(writer);
        if (this.as) {
            writer.append(' ');
            writer.append("AS");
            if (!this.identificationVariable.isVirtual()) {
                writer.append(' ');
            }
        }
        if (!this.identificationVariable.isVirtual()) {
            if (this.rootStateObject != null && !this.as) {
                writer.append(' ');
            }
            this.identificationVariable.toString(writer);
        }
    }
}

