/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.util;

import java.util.HashSet;

public final class ClassUtil {
    private ClassUtil() {
    }

    public static Class classForName(String pClassName, boolean pInitialize) {
        HashSet<ClassLoader> tried = new HashSet<ClassLoader>();
        for (ClassLoader loader : new ClassLoader[]{Thread.currentThread().getContextClassLoader(), ClassUtil.class.getClassLoader()}) {
            do {
                try {
                    if (!tried.contains(loader)) {
                        return Class.forName(pClassName, pInitialize, loader);
                    }
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
                tried.add(loader);
            } while ((loader = loader.getParent()) != null);
        }
        return null;
    }

    public static Class classForName(String pClassName) {
        return ClassUtil.classForName(pClassName, true);
    }

    public static boolean checkForClass(String pClassName) {
        return ClassUtil.classForName(pClassName, false) != null;
    }
}

