/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.apps.splash;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.virgo.apps.splash.GZIPResponseStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(ContentServlet.class);
    private static final long serialVersionUID = 1L;
    private static final String HTTP_CONTENT_LENGTH_HEADER = "Content-Length";
    private static final String HTTP_LAST_MODIFIED_HEADER = "Last-Modified";
    private static final String HTTP_EXPIRES_HEADER = "Expires";
    private static final String HTTP_CACHE_CONTROL_HEADER = "Cache-Control";
    private static final String PATH_TO_VERSION_FILE = "lib/.version";
    private static final String VERSION_HOLDER = "<!--@<version@-->";
    private String view = "/WEB-INF/splash.html";
    private boolean gzipEnabled = true;
    private final String version;
    private int cacheTimeout = 60;
    private Map<String, String> defaultMimeTypes = new HashMap();
    private Set<String> compressedMimeTypes;

    public ContentServlet() {
        this.defaultMimeTypes.put(".html", "text/html");
        this.defaultMimeTypes.put(".htm", "text/html");
        this.defaultMimeTypes.put(".xhtml", "text/html");
        this.compressedMimeTypes = new HashSet();
        this.compressedMimeTypes.add("text/.*");
        this.compressedMimeTypes.add(".*/xhtml.xml");
        this.version = this.readServerVersion();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        URL resource = this.getRequestedContentURL(this.view);
        this.prepareContentResponse(response, resource);
        try (PrintWriter out = this.selectOutputStream(request, response);){
            URLConnection resourceConn = resource.openConnection();
            try (InputStream in = resourceConn.getInputStream();){
                this.parse(in, out);
            }
        }
    }

    private void parse(InputStream in, PrintWriter out) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Scanner scanner = new Scanner(in, StandardCharsets.UTF_8.name());){
            while (scanner.hasNextLine()) {
                String parsedLine = this.parseLine(scanner.nextLine());
                if (parsedLine == null || parsedLine.trim().isEmpty()) continue;
                out.append(parsedLine);
                out.append('\n');
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private String parseLine(String line) {
        if (line.contains(VERSION_HOLDER)) {
            int offset = line.indexOf(VERSION_HOLDER);
            line = String.format("%s%s%s", line.substring(0, offset), this.version, line.substring(offset + VERSION_HOLDER.length()));
        }
        return line;
    }

    private PrintWriter selectOutputStream(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String acceptEncoding = request.getHeader("Accept-Encoding");
        String mimeType = response.getContentType();
        if (this.gzipEnabled && acceptEncoding != null && acceptEncoding.indexOf("gzip") > -1 && this.matchesCompressedMimeTypes(mimeType)) {
            log.debug("Enabling GZIP compression for the current response.");
            return new PrintWriter(new OutputStreamWriter((OutputStream)new GZIPResponseStream(response), StandardCharsets.UTF_8));
        }
        return response.getWriter();
    }

    private boolean matchesCompressedMimeTypes(String mimeType) {
        for (String compressedMimeType : this.compressedMimeTypes) {
            if (!mimeType.matches(compressedMimeType)) continue;
            return true;
        }
        return false;
    }

    private void prepareContentResponse(HttpServletResponse response, URL resource) throws IOException {
        URLConnection resourceConn = resource.openConnection();
        String mimeType = this.getServletContext().getMimeType(resource.getPath());
        if (mimeType == null) {
            String extension = resource.getPath().substring(resource.getPath().lastIndexOf(46));
            mimeType = (String)this.defaultMimeTypes.get(extension);
        }
        response.setContentType(mimeType);
        response.setHeader(HTTP_CONTENT_LENGTH_HEADER, Long.toString(resourceConn.getContentLength()));
        response.setDateHeader(HTTP_LAST_MODIFIED_HEADER, resourceConn.getLastModified());
        if (this.cacheTimeout > 0) {
            this.configureCaching(response, this.cacheTimeout);
        }
    }

    protected long getLastModified(HttpServletRequest request) {
        URL resource;
        String rawRequestPath = request.getPathInfo();
        if (log.isDebugEnabled()) {
            log.debug("Checking last modified of content: " + rawRequestPath);
        }
        try {
            resource = this.getRequestedContentURL(rawRequestPath);
        }
        catch (MalformedURLException malformedURLException) {
            return -1L;
        }
        if (resource == null) {
            return -1L;
        }
        try {
            return resource.openConnection().getLastModified();
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    private URL getRequestedContentURL(String rawRequestPath) throws MalformedURLException {
        URL resource = this.getServletContext().getResource(rawRequestPath);
        if (resource == null && log.isDebugEnabled()) {
            log.debug("Content not found: " + rawRequestPath);
        }
        return resource;
    }

    private void configureCaching(HttpServletResponse response, int seconds) {
        response.setDateHeader(HTTP_EXPIRES_HEADER, System.currentTimeMillis() + (long)seconds * 1000L);
        response.setHeader(HTTP_CACHE_CONTROL_HEADER, "max-age=" + seconds);
    }

    private String readServerVersion() {
        String readVersion;
        File versionFile = new File(PATH_TO_VERSION_FILE);
        Properties versions = new Properties();
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(versionFile);
            versions.load(stream);
            readVersion = versions.getProperty("virgo.server.version");
            ((InputStream)stream).close();
        }
        catch (IOException iOException) {
            readVersion = "";
            try {
                if (stream != null) {
                    ((InputStream)stream).close();
                }
            }
            catch (IOException iOException2) {}
        }
        return readVersion;
    }
}

