/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.management;

import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.eclipse.gemini.management.DefaultObjectNameTranslator;
import org.eclipse.gemini.management.ObjectNameTranslator;
import org.eclipse.gemini.management.configurationadmin.ConfigAdminManager;
import org.eclipse.gemini.management.framework.BundleState;
import org.eclipse.gemini.management.framework.BundleWiringState;
import org.eclipse.gemini.management.framework.CustomBundleStateMBean;
import org.eclipse.gemini.management.framework.CustomBundleWiringStateMBean;
import org.eclipse.gemini.management.framework.CustomServiceStateMBean;
import org.eclipse.gemini.management.framework.Framework;
import org.eclipse.gemini.management.framework.PackageState;
import org.eclipse.gemini.management.framework.ServiceState;
import org.eclipse.gemini.management.permissionadmin.PermissionManager;
import org.eclipse.gemini.management.provisioning.Provisioning;
import org.eclipse.gemini.management.useradmin.UserManager;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.jmx.framework.FrameworkMBean;
import org.osgi.jmx.framework.PackageStateMBean;
import org.osgi.jmx.service.cm.ConfigurationAdminMBean;
import org.osgi.jmx.service.permissionadmin.PermissionAdminMBean;
import org.osgi.jmx.service.provisioning.ProvisioningServiceMBean;
import org.osgi.jmx.service.useradmin.UserAdminMBean;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.permissionadmin.PermissionAdmin;
import org.osgi.service.provisioning.ProvisioningService;
import org.osgi.service.useradmin.UserAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator {
    private static final Logger LOGGER = Logger.getLogger(Activator.class.getCanonicalName());
    private final List<MBeanServer> mbeanServers = new CopyOnWriteArrayList<MBeanServer>();
    private final AtomicBoolean servicesRegistered = new AtomicBoolean(false);
    private ObjectNameTranslator objectNameTranslator;
    private ObjectName frameworkName;
    private ObjectName bundleStateName;
    private ObjectName bundleWiringStateName;
    private ObjectName packageStateName;
    private ObjectName serviceStateName;
    private ObjectName configAdminName;
    private ObjectName permissionAdminName;
    private ObjectName provisioningServiceName;
    private ObjectName userAdminName;
    private ServiceTracker<MBeanServer, ?> mbeanServiceTracker;
    private BundleContext bundleContext = null;
    private StandardMBean framework;
    private StandardMBean bundleState;
    private StandardMBean bundleWiringState;
    private StandardMBean packageState;
    private StandardMBean serviceState;
    private ServiceTracker<ConfigurationAdmin, ?> configAdminTracker;
    private ServiceTracker<PermissionAdmin, ?> permissionAdminTracker;
    private ServiceTracker<ProvisioningService, ?> provisioningServiceTracker;
    private ServiceTracker<UserAdmin, ?> userAdminTracker;

    private void createObjectNames() {
        try {
            this.frameworkName = this.translateObjectName("osgi.core:type=framework,version=1.5");
            this.bundleStateName = this.translateObjectName("osgi.core:type=bundleState,version=1.5");
            this.bundleWiringStateName = this.translateObjectName("osgi.core:type=wiringState,version=1.0");
            this.serviceStateName = this.translateObjectName("osgi.core:type=serviceState,version=1.5");
            this.packageStateName = this.translateObjectName("osgi.core:type=packageState,version=1.5");
            this.configAdminName = this.translateObjectName("osgi.compendium:service=cm,version=1.3");
            this.permissionAdminName = this.translateObjectName("osgi.core:service=permissionadmin,version=1.2");
            this.provisioningServiceName = this.translateObjectName("osgi.compendium:service=provisioning,version=1.2");
            this.userAdminName = this.translateObjectName("osgi.compendium:service=useradmin,version=1.1");
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to start Gemini Management, Object name creation failed.", e);
        }
    }

    public void start(BundleContext bundleContext) throws Exception {
        this.objectNameTranslator = DefaultObjectNameTranslator.initialiseObjectNameTranslator(bundleContext);
        this.createObjectNames();
        this.bundleContext = bundleContext;
        this.registerDefaultMBeanServer();
        this.mbeanServiceTracker = new ServiceTracker(this.bundleContext, MBeanServer.class, (ServiceTrackerCustomizer)new MBeanServiceTracker());
        LOGGER.fine("Awaiting initial MBeanServer service registration");
        this.mbeanServiceTracker.open();
    }

    private ObjectName translateObjectName(String objectName) throws MalformedObjectNameException {
        return this.objectNameTranslator.translate(new ObjectName(objectName));
    }

    private void registerDefaultMBeanServer() {
        if ("false".equals(this.bundleContext.getProperty("register.default.mbeanserver"))) {
            return;
        }
        ServiceReference ref = this.bundleContext.getServiceReference(MBeanServer.class);
        if (ref == null) {
            this.bundleContext.registerService(MBeanServer.class.getCanonicalName(), (Object)ManagementFactory.getPlatformMBeanServer(), null);
        }
    }

    public void stop(BundleContext arg0) throws Exception {
        this.mbeanServiceTracker.close();
        for (MBeanServer mbeanServer : this.mbeanServers) {
            this.deregisterServices(mbeanServer);
        }
        this.mbeanServers.clear();
    }

    private synchronized void deregisterServices(MBeanServer mbeanServer) {
        if (!this.servicesRegistered.get()) {
            return;
        }
        LOGGER.fine("Deregistering framework with MBeanServer: " + mbeanServer);
        try {
            mbeanServer.unregisterMBean(this.frameworkName);
        }
        catch (InstanceNotFoundException e) {
            LOGGER.log(Level.FINE, "FrameworkMBean not found on deregistration", e);
        }
        catch (MBeanRegistrationException e) {
            LOGGER.log(Level.FINE, "FrameworkMBean deregistration problem", e);
        }
        this.framework = null;
        LOGGER.fine("Deregistering bundle state with MBeanServer: " + mbeanServer);
        try {
            mbeanServer.unregisterMBean(this.bundleStateName);
        }
        catch (InstanceNotFoundException e) {
            LOGGER.log(Level.FINEST, "OSGi BundleStateMBean not found on deregistration", e);
        }
        catch (MBeanRegistrationException e) {
            LOGGER.log(Level.FINE, "OSGi BundleStateMBean deregistration problem", e);
        }
        this.bundleState = null;
        LOGGER.fine("Deregistering bundle wiring state with MBeanServer: " + mbeanServer);
        try {
            mbeanServer.unregisterMBean(this.bundleWiringStateName);
        }
        catch (InstanceNotFoundException e) {
            LOGGER.log(Level.FINEST, "OSGi BundleWiringStateMBean not found on deregistration", e);
        }
        catch (MBeanRegistrationException e) {
            LOGGER.log(Level.FINE, "OSGi BundleWiringStateMBean deregistration problem", e);
        }
        this.bundleWiringState = null;
        LOGGER.fine("Deregistering services monitor with MBeanServer: " + mbeanServer);
        try {
            mbeanServer.unregisterMBean(this.serviceStateName);
        }
        catch (InstanceNotFoundException e) {
            LOGGER.log(Level.FINEST, "OSGi ServiceStateMBean not found on deregistration", e);
        }
        catch (MBeanRegistrationException e) {
            LOGGER.log(Level.FINE, "OSGi ServiceStateMBean deregistration problem", e);
        }
        this.serviceState = null;
        LOGGER.fine("Deregistering packages monitor with MBeanServer: " + mbeanServer);
        try {
            mbeanServer.unregisterMBean(this.packageStateName);
        }
        catch (InstanceNotFoundException e) {
            LOGGER.log(Level.FINEST, "OSGi PackageStateMBean not found on deregistration", e);
        }
        catch (MBeanRegistrationException e) {
            LOGGER.log(Level.FINE, "OSGi PackageStateMBean deregistration problem", e);
        }
        this.packageState = null;
        LOGGER.fine("Deregistering config admin with MBeanServer: " + mbeanServer);
        this.configAdminTracker.close();
        try {
            mbeanServer.unregisterMBean(this.configAdminName);
        }
        catch (InstanceNotFoundException e) {
            LOGGER.log(Level.FINEST, "OSGi ConfigAdminMBean not found on deregistration", e);
        }
        catch (MBeanRegistrationException e) {
            LOGGER.log(Level.FINE, "OSGi ConfigAdminMBean deregistration problem", e);
        }
        this.configAdminTracker = null;
        LOGGER.fine("Deregistering permission admin with MBeanServer: " + mbeanServer);
        this.permissionAdminTracker.close();
        try {
            mbeanServer.unregisterMBean(this.permissionAdminName);
        }
        catch (InstanceNotFoundException e) {
            LOGGER.log(Level.FINEST, "OSGi PermissionAdminMBean not found on deregistration", e);
        }
        catch (MBeanRegistrationException e) {
            LOGGER.log(Level.FINE, "OSGi PermissionAdminMBean deregistration problem", e);
        }
        this.permissionAdminTracker = null;
        LOGGER.fine("Deregistering provisioning service admin with MBeanServer: " + mbeanServer);
        this.provisioningServiceTracker.close();
        try {
            mbeanServer.unregisterMBean(this.provisioningServiceName);
        }
        catch (InstanceNotFoundException e) {
            LOGGER.log(Level.FINEST, "OSGi ProvisioningServiceMBean not found on deregistration", e);
        }
        catch (MBeanRegistrationException e) {
            LOGGER.log(Level.FINE, "OSGi ProvisioningServiceMBean deregistration problem", e);
        }
        this.provisioningServiceTracker = null;
        LOGGER.fine("Deregistering user admin with MBeanServer: " + mbeanServer);
        this.userAdminTracker.close();
        try {
            mbeanServer.unregisterMBean(this.userAdminName);
        }
        catch (InstanceNotFoundException e) {
            LOGGER.log(Level.FINEST, "OSGi UserAdminMBean not found on deregistration", e);
        }
        catch (MBeanRegistrationException e) {
            LOGGER.log(Level.FINE, "OSGi UserAdminMBean deregistration problem", e);
        }
        this.userAdminTracker = null;
        this.servicesRegistered.set(false);
    }

    private synchronized void registerServices(MBeanServer mbeanServer) {
        try {
            this.framework = new StandardMBean(new Framework(this.bundleContext), FrameworkMBean.class);
        }
        catch (NotCompliantMBeanException e) {
            LOGGER.log(Level.SEVERE, "Unable to create StandardMBean for Framework", e);
            return;
        }
        try {
            this.bundleState = new StandardMBean(new BundleState(this.bundleContext), CustomBundleStateMBean.class);
        }
        catch (NotCompliantMBeanException e) {
            LOGGER.log(Level.SEVERE, "Unable to create StandardMBean for BundleState", e);
            return;
        }
        try {
            this.bundleWiringState = new StandardMBean(new BundleWiringState(this.bundleContext), CustomBundleWiringStateMBean.class);
        }
        catch (NotCompliantMBeanException e) {
            LOGGER.log(Level.SEVERE, "Unable to create StandardMBean for BundleWiringState", e);
            return;
        }
        try {
            this.serviceState = new StandardMBean(new ServiceState(this.bundleContext), CustomServiceStateMBean.class);
        }
        catch (NotCompliantMBeanException e) {
            LOGGER.log(Level.SEVERE, "Unable to create StandardMBean for ServiceState", e);
            return;
        }
        try {
            this.packageState = new StandardMBean(new PackageState(this.bundleContext), PackageStateMBean.class);
        }
        catch (NotCompliantMBeanException e) {
            LOGGER.log(Level.SEVERE, "Unable to create StandardMBean for PackageState", e);
            return;
        }
        LOGGER.fine("Registering Framework with MBeanServer: " + mbeanServer + " with name: " + this.frameworkName);
        try {
            mbeanServer.registerMBean(this.framework, this.frameworkName);
        }
        catch (InstanceAlreadyExistsException e) {
            LOGGER.log(Level.FINE, "Cannot register OSGi framework MBean", e);
        }
        catch (MBeanRegistrationException e) {
            LOGGER.log(Level.SEVERE, "Cannot register OSGi framework MBean", e);
        }
        catch (NotCompliantMBeanException e) {
            LOGGER.log(Level.SEVERE, "Cannot register OSGi framework MBean", e);
        }
        LOGGER.fine("Registering bundle state with MBeanServer: " + mbeanServer + " with name: " + this.bundleStateName);
        try {
            mbeanServer.registerMBean(this.bundleState, this.bundleStateName);
        }
        catch (InstanceAlreadyExistsException e) {
            LOGGER.log(Level.FINE, "Cannot register OSGi BundleStateMBean", e);
        }
        catch (MBeanRegistrationException e) {
            LOGGER.log(Level.SEVERE, "Cannot register OSGi BundleStateMBean", e);
        }
        catch (NotCompliantMBeanException e) {
            LOGGER.log(Level.SEVERE, "Cannot register OSGi BundleStateMBean", e);
        }
        LOGGER.fine("Registering bundle wiring state with MBeanServer: " + mbeanServer + " with name: " + this.bundleStateName);
        try {
            mbeanServer.registerMBean(this.bundleWiringState, this.bundleWiringStateName);
        }
        catch (InstanceAlreadyExistsException e) {
            LOGGER.log(Level.FINE, "Cannot register OSGi BundleWiringStateMBean", e);
        }
        catch (MBeanRegistrationException e) {
            LOGGER.log(Level.SEVERE, "Cannot register OSGi BundleWiringStateMBean", e);
        }
        catch (NotCompliantMBeanException e) {
            LOGGER.log(Level.SEVERE, "Cannot register OSGi BundleWiringStateMBean", e);
        }
        LOGGER.fine("Registering services monitor with MBeanServer: " + mbeanServer + " with name: " + this.serviceStateName);
        try {
            mbeanServer.registerMBean(this.serviceState, this.serviceStateName);
        }
        catch (InstanceAlreadyExistsException e) {
            LOGGER.log(Level.FINE, "Cannot register OSGi ServiceStateMBean", e);
        }
        catch (MBeanRegistrationException e) {
            LOGGER.log(Level.SEVERE, "Cannot register OSGi ServiceStateMBean", e);
        }
        catch (NotCompliantMBeanException e) {
            LOGGER.log(Level.SEVERE, "Cannot register OSGi ServiceStateMBean", e);
        }
        LOGGER.fine("Registering packages monitor with MBeanServer: " + mbeanServer + " with name: " + this.packageStateName);
        try {
            mbeanServer.registerMBean(this.packageState, this.packageStateName);
        }
        catch (InstanceAlreadyExistsException e) {
            LOGGER.log(Level.FINE, "Cannot register OSGi PackageStateMBean", e);
        }
        catch (MBeanRegistrationException e) {
            LOGGER.log(Level.SEVERE, "Cannot register OSGi PackageStateMBean", e);
        }
        catch (NotCompliantMBeanException e) {
            LOGGER.log(Level.SEVERE, "Cannot register OSGi PackageStateMBean", e);
        }
        this.configAdminTracker = new ServiceTracker(this.bundleContext, "org.osgi.service.cm.ConfigurationAdmin", (ServiceTrackerCustomizer)new ConfigAdminTracker());
        this.permissionAdminTracker = new ServiceTracker(this.bundleContext, "org.osgi.service.permissionadmin.PermissionAdmin", (ServiceTrackerCustomizer)new PermissionAdminTracker());
        this.provisioningServiceTracker = new ServiceTracker(this.bundleContext, "org.osgi.service.provisioning.ProvisioningService", (ServiceTrackerCustomizer)new ProvisioningServiceTracker());
        this.userAdminTracker = new ServiceTracker(this.bundleContext, "org.osgi.service.useradmin.UserAdmin", (ServiceTrackerCustomizer)new UserAdminTracker());
        this.configAdminTracker.open();
        this.permissionAdminTracker.open();
        this.provisioningServiceTracker.open();
        this.userAdminTracker.open();
        this.servicesRegistered.set(true);
    }

    private class ConfigAdminTracker
    implements ServiceTrackerCustomizer<ConfigurationAdmin, Object> {
        private StandardMBean manager;

        private ConfigAdminTracker() {
        }

        public Object addingService(ServiceReference<ConfigurationAdmin> reference) {
            ConfigurationAdmin admin;
            try {
                admin = (ConfigurationAdmin)Activator.this.bundleContext.getService(reference);
            }
            catch (ClassCastException e) {
                LOGGER.log(Level.SEVERE, "Incompatible class version for the Configuration Admin Manager", e);
                return Activator.this.bundleContext.getService(reference);
            }
            try {
                this.manager = new StandardMBean(new ConfigAdminManager(admin), ConfigurationAdminMBean.class);
            }
            catch (NotCompliantMBeanException e) {
                LOGGER.log(Level.SEVERE, "Unable to create Configuration Admin Manager", e);
                return admin;
            }
            for (MBeanServer mbeanServer : Activator.this.mbeanServers) {
                LOGGER.fine("Registering configuration admin with MBeanServer: " + mbeanServer + " with name: " + Activator.this.configAdminName);
                try {
                    mbeanServer.registerMBean(this.manager, Activator.this.configAdminName);
                }
                catch (InstanceAlreadyExistsException e) {
                    LOGGER.log(Level.FINE, "Cannot register Configuration Manager MBean", e);
                }
                catch (MBeanRegistrationException e) {
                    LOGGER.log(Level.SEVERE, "Cannot register Configuration Manager MBean", e);
                }
                catch (NotCompliantMBeanException e) {
                    LOGGER.log(Level.SEVERE, "Cannot register Configuration Manager MBean", e);
                }
            }
            return admin;
        }

        public void modifiedService(ServiceReference<ConfigurationAdmin> reference, Object service) {
        }

        public void removedService(ServiceReference<ConfigurationAdmin> reference, Object service) {
            for (MBeanServer mbeanServer : Activator.this.mbeanServers) {
                LOGGER.fine("deregistering configuration admin from: " + mbeanServer + " with name: " + Activator.this.configAdminName);
                try {
                    mbeanServer.unregisterMBean(Activator.this.configAdminName);
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    LOGGER.fine("Configuration Manager MBean was never registered");
                }
                catch (MBeanRegistrationException e) {
                    LOGGER.log(Level.SEVERE, "Cannot deregister Configuration Manager MBean", e);
                }
            }
        }
    }

    private class MBeanServiceTracker
    implements ServiceTrackerCustomizer<MBeanServer, Object> {
        private MBeanServiceTracker() {
        }

        public MBeanServer addingService(ServiceReference<MBeanServer> servicereference) {
            try {
                LOGGER.fine("Adding MBeanServer: " + servicereference);
                final MBeanServer mbeanServer = (MBeanServer)Activator.this.bundleContext.getService(servicereference);
                Activator.this.mbeanServers.add(mbeanServer);
                Runnable registration = new Runnable(){

                    @Override
                    public void run() {
                        Activator.this.registerServices(mbeanServer);
                    }
                };
                Thread registrationThread = new Thread(registration, "JMX Core MBean Registration");
                registrationThread.setDaemon(true);
                registrationThread.start();
                return mbeanServer;
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.SEVERE, "uncaught exception in addingService", e);
                throw e;
            }
        }

        public void modifiedService(ServiceReference<MBeanServer> servicereference, Object obj) {
        }

        public void removedService(ServiceReference<MBeanServer> servicereference, Object obj) {
            try {
                LOGGER.fine("Removing MBeanServer: " + servicereference);
                final MBeanServer mbeanServer = (MBeanServer)Activator.this.bundleContext.getService(servicereference);
                Activator.this.mbeanServers.remove(mbeanServer);
                Runnable deregister = new Runnable(){

                    @Override
                    public void run() {
                        Activator.this.deregisterServices(mbeanServer);
                    }
                };
                Thread deregisterThread = new Thread(deregister, "JMX Core MBean Deregistration");
                deregisterThread.setDaemon(true);
                deregisterThread.start();
            }
            catch (Throwable e) {
                LOGGER.log(Level.FINE, "uncaught exception in removedService", e);
            }
        }
    }

    private class PermissionAdminTracker
    implements ServiceTrackerCustomizer<PermissionAdmin, Object> {
        private StandardMBean manager;

        private PermissionAdminTracker() {
        }

        public Object addingService(ServiceReference<PermissionAdmin> reference) {
            PermissionAdmin admin;
            try {
                admin = (PermissionAdmin)Activator.this.bundleContext.getService(reference);
            }
            catch (ClassCastException e) {
                LOGGER.log(Level.SEVERE, "Incompatible class version for the Permission Admin Manager", e);
                return Activator.this.bundleContext.getService(reference);
            }
            try {
                this.manager = new StandardMBean(new PermissionManager(admin), PermissionAdminMBean.class);
            }
            catch (NotCompliantMBeanException e) {
                LOGGER.log(Level.SEVERE, "Unable to create Permission Admin Manager", e);
                return admin;
            }
            for (MBeanServer mbeanServer : Activator.this.mbeanServers) {
                LOGGER.fine("Registering permission admin with MBeanServer: " + mbeanServer + " with name: " + Activator.this.permissionAdminName);
                try {
                    mbeanServer.registerMBean(this.manager, Activator.this.permissionAdminName);
                }
                catch (InstanceAlreadyExistsException e) {
                    LOGGER.log(Level.FINE, "Cannot register Permission Manager MBean", e);
                }
                catch (MBeanRegistrationException e) {
                    LOGGER.log(Level.SEVERE, "Cannot register Permission Manager MBean", e);
                }
                catch (NotCompliantMBeanException e) {
                    LOGGER.log(Level.SEVERE, "Cannot register Permission Manager MBean", e);
                }
            }
            return admin;
        }

        public void modifiedService(ServiceReference<PermissionAdmin> reference, Object service) {
        }

        public void removedService(ServiceReference<PermissionAdmin> reference, Object service) {
            for (MBeanServer mbeanServer : Activator.this.mbeanServers) {
                LOGGER.fine("deregistering permission admin with MBeanServer: " + mbeanServer + " with name: " + Activator.this.permissionAdminName);
                try {
                    mbeanServer.unregisterMBean(Activator.this.permissionAdminName);
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    LOGGER.fine("Permission Manager MBean was never registered");
                }
                catch (MBeanRegistrationException e) {
                    LOGGER.log(Level.SEVERE, "Cannot deregister Permission Manager MBean", e);
                }
            }
        }
    }

    private class ProvisioningServiceTracker
    implements ServiceTrackerCustomizer<ProvisioningService, Object> {
        private StandardMBean provisioning;

        private ProvisioningServiceTracker() {
        }

        public Object addingService(ServiceReference<ProvisioningService> reference) {
            ProvisioningService service;
            try {
                service = (ProvisioningService)Activator.this.bundleContext.getService(reference);
            }
            catch (ClassCastException e) {
                LOGGER.log(Level.SEVERE, "Incompatible class version for the Provisioning service", e);
                return Activator.this.bundleContext.getService(reference);
            }
            try {
                this.provisioning = new StandardMBean(new Provisioning(service), ProvisioningServiceMBean.class);
            }
            catch (NotCompliantMBeanException e) {
                LOGGER.log(Level.SEVERE, "Unable to create Provisioning Service Manager", e);
                return service;
            }
            for (MBeanServer mbeanServer : Activator.this.mbeanServers) {
                LOGGER.fine("Registering provisioning service with MBeanServer: " + mbeanServer + " with name: " + Activator.this.provisioningServiceName);
                try {
                    mbeanServer.registerMBean(this.provisioning, Activator.this.provisioningServiceName);
                }
                catch (InstanceAlreadyExistsException e) {
                    LOGGER.log(Level.FINE, "Cannot register Provisioning Service MBean", e);
                }
                catch (MBeanRegistrationException e) {
                    LOGGER.log(Level.SEVERE, "Cannot register Provisioning Service MBean", e);
                }
                catch (NotCompliantMBeanException e) {
                    LOGGER.log(Level.SEVERE, "Cannot register Provisioning Service MBean", e);
                }
            }
            return service;
        }

        public void modifiedService(ServiceReference<ProvisioningService> reference, Object service) {
        }

        public void removedService(ServiceReference<ProvisioningService> reference, Object service) {
            for (MBeanServer mbeanServer : Activator.this.mbeanServers) {
                LOGGER.fine("deregistering provisioning service with MBeanServer: " + mbeanServer + " with name: " + Activator.this.provisioningServiceName);
                try {
                    mbeanServer.unregisterMBean(Activator.this.provisioningServiceName);
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    LOGGER.fine("Provisioning Service MBean was never registered");
                }
                catch (MBeanRegistrationException e) {
                    LOGGER.log(Level.SEVERE, "Cannot deregister Provisioning Service MBean", e);
                }
            }
        }
    }

    private class UserAdminTracker
    implements ServiceTrackerCustomizer<UserAdmin, Object> {
        private StandardMBean manager;

        private UserAdminTracker() {
        }

        public Object addingService(ServiceReference<UserAdmin> reference) {
            UserAdmin admin;
            try {
                admin = (UserAdmin)Activator.this.bundleContext.getService(reference);
            }
            catch (ClassCastException e) {
                LOGGER.log(Level.SEVERE, "Incompatible class version for the User Admin manager", e);
                return Activator.this.bundleContext.getService(reference);
            }
            try {
                this.manager = new StandardMBean(new UserManager(admin), UserAdminMBean.class);
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                LOGGER.log(Level.SEVERE, "Unable to create User Admin Manager");
                return admin;
            }
            for (MBeanServer mbeanServer : Activator.this.mbeanServers) {
                LOGGER.fine("Registering user admin with MBeanServer: " + mbeanServer + " with name: " + Activator.this.userAdminName);
                try {
                    mbeanServer.registerMBean(this.manager, Activator.this.userAdminName);
                }
                catch (InstanceAlreadyExistsException e) {
                    LOGGER.log(Level.FINE, "Cannot register User Manager MBean", e);
                }
                catch (MBeanRegistrationException e) {
                    LOGGER.log(Level.SEVERE, "Cannot register User Manager MBean", e);
                }
                catch (NotCompliantMBeanException e) {
                    LOGGER.log(Level.SEVERE, "Cannot register User Manager MBean", e);
                }
            }
            return admin;
        }

        public void modifiedService(ServiceReference<UserAdmin> reference, Object service) {
        }

        public void removedService(ServiceReference<UserAdmin> reference, Object service) {
            for (MBeanServer mbeanServer : Activator.this.mbeanServers) {
                LOGGER.fine("Deregistering user admin with MBeanServer: " + mbeanServer + " with name: " + Activator.this.userAdminName);
                try {
                    mbeanServer.unregisterMBean(Activator.this.userAdminName);
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    LOGGER.fine("User Manager MBean was never registered");
                }
                catch (MBeanRegistrationException e) {
                    LOGGER.log(Level.SEVERE, "Cannot deregister User Manager MBean", e);
                }
            }
        }
    }
}

