/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.filesystem;

import java.io.File;
import org.apache.sshd.server.FileSystemFactory;
import org.apache.sshd.server.FileSystemView;
import org.apache.sshd.server.filesystem.NativeFileSystemView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeFileSystemFactory
implements FileSystemFactory {
    private final Logger LOG = LoggerFactory.getLogger(NativeFileSystemFactory.class);
    private boolean createHome;
    private boolean caseInsensitive;

    public boolean isCreateHome() {
        return this.createHome;
    }

    public void setCreateHome(boolean createHome) {
        this.createHome = createHome;
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    public FileSystemView createFileSystemView(String userName) {
        if (this.createHome) {
            String homeDirStr = "/home/" + userName;
            File homeDir = new File(homeDirStr);
            if (homeDir.isFile()) {
                this.LOG.warn("Not a directory :: " + homeDirStr);
            }
            if (!homeDir.exists() && !homeDir.mkdirs()) {
                this.LOG.warn("Cannot create user home :: " + homeDirStr);
            }
        }
        NativeFileSystemView fsView = new NativeFileSystemView(userName, this.caseInsensitive);
        return fsView;
    }
}

