/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.repository.internal;

import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.virgo.repository.ArtifactDescriptor;
import org.eclipse.virgo.repository.ArtifactDescriptorPersister;
import org.eclipse.virgo.repository.Attribute;
import org.eclipse.virgo.repository.DuplicateArtifactException;
import org.eclipse.virgo.repository.IndexFormatException;
import org.eclipse.virgo.repository.RepositoryAwareArtifactDescriptor;
import org.eclipse.virgo.repository.internal.ArtifactDescriptorDepository;
import org.eclipse.virgo.repository.internal.Index;
import org.eclipse.virgo.repository.internal.StandardQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardArtifactDescriptorDepository
implements ArtifactDescriptorDepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardArtifactDescriptorDepository.class);
    private final ArtifactDescriptorPersister artifactDescriptorPersister;
    private final Set<RepositoryAwareArtifactDescriptor> artifactDescriptors;
    private final Index index;
    private final Object artifactsLock = new Object();

    StandardArtifactDescriptorDepository(ArtifactDescriptorPersister artifactDescriptorPersister, Set<RepositoryAwareArtifactDescriptor> artifactDescriptors) throws IndexFormatException {
        if (artifactDescriptorPersister == null || artifactDescriptors == null) {
            throw new IllegalArgumentException("Arguments must not be null");
        }
        this.artifactDescriptorPersister = artifactDescriptorPersister;
        this.artifactDescriptors = this.artifactDescriptorPersister.loadArtifacts();
        this.artifactDescriptors.addAll(artifactDescriptors);
        this.index = new Index(this.artifactDescriptors);
    }

    StandardArtifactDescriptorDepository(Set<RepositoryAwareArtifactDescriptor> artifactDescriptors) {
        if (artifactDescriptors == null) {
            throw new IllegalArgumentException("Argument must not be null");
        }
        this.artifactDescriptorPersister = null;
        this.artifactDescriptors = new HashSet<RepositoryAwareArtifactDescriptor>(16);
        this.artifactDescriptors.addAll(artifactDescriptors);
        this.index = new Index(this.artifactDescriptors);
    }

    public StandardArtifactDescriptorDepository(ArtifactDescriptorPersister artifactDescriptorPersister) throws IndexFormatException {
        this(artifactDescriptorPersister, new HashSet<RepositoryAwareArtifactDescriptor>(0));
    }

    @Override
    public int getArtifactDescriptorCount() {
        return this.artifactDescriptors.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addArtifactDescriptor(RepositoryAwareArtifactDescriptor artifactDescriptor) throws IllegalArgumentException, DuplicateArtifactException {
        if (artifactDescriptor == null) {
            throw new IllegalArgumentException("Argument can not be null");
        }
        Object object = this.artifactsLock;
        synchronized (object) {
            if (this.artifactDescriptors.contains(artifactDescriptor)) {
                RepositoryAwareArtifactDescriptor original = null;
                for (RepositoryAwareArtifactDescriptor temp : this.artifactDescriptors) {
                    if (!temp.equals(artifactDescriptor)) continue;
                    original = temp;
                }
                throw new DuplicateArtifactException(original, artifactDescriptor);
            }
            this.artifactDescriptors.add(artifactDescriptor);
            this.index.addArtifactDescriptor(artifactDescriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RepositoryAwareArtifactDescriptor removeArtifactDescriptor(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Argument can not be null");
        }
        StandardQuery uriQuery = new StandardQuery(this, "uri", uri.toString());
        Object object = this.artifactsLock;
        synchronized (object) {
            Set<RepositoryAwareArtifactDescriptor> artifacts = uriQuery.run();
            if (artifacts.size() > 1) {
                LOGGER.debug("More than one artifact with URI '{}' in depository {}.", (Object)uri, (Object)this);
                throw new IllegalStateException("Internal failure: multiple artifacts with the same URI.");
            }
            RepositoryAwareArtifactDescriptor artifact = null;
            if (!artifacts.isEmpty()) {
                artifact = artifacts.iterator().next();
                this.index.removeArtifactDescriptor(artifact);
                this.artifactDescriptors.remove(artifact);
            }
            return artifact;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeArtifactDescriptor(RepositoryAwareArtifactDescriptor artifactDescriptor) {
        Object object = this.artifactsLock;
        synchronized (object) {
            this.index.removeArtifactDescriptor(artifactDescriptor);
            return this.artifactDescriptors.remove(artifactDescriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persist() throws IOException {
        if (this.artifactDescriptorPersister != null) {
            Object object = this.artifactsLock;
            synchronized (object) {
                this.artifactDescriptorPersister.persistArtifactDescriptors(this.artifactDescriptors);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<RepositoryAwareArtifactDescriptor> resolveArtifactDescriptors(Set<Attribute> filters) {
        Object object = this.artifactsLock;
        synchronized (object) {
            if (filters == null || filters.isEmpty()) {
                return new HashSet<RepositoryAwareArtifactDescriptor>(this.artifactDescriptors);
            }
            HashSet<RepositoryAwareArtifactDescriptor> results = new HashSet<RepositoryAwareArtifactDescriptor>(this.artifactDescriptors);
            for (Attribute filter : filters) {
                results.retainAll(this.findMatchingArtifacts(filter));
            }
            return results;
        }
    }

    private Set<ArtifactDescriptor> findMatchingArtifacts(Attribute filter) {
        Set<Attribute> attributes = this.index.findMatchingAttributes(filter.getKey(), filter.getValue());
        HashSet<Attribute> propertyFilteredAttributes = new HashSet<Attribute>();
        for (Attribute attribute : attributes) {
            if (!this.propertiesContains(filter.getProperties(), attribute.getProperties())) continue;
            propertyFilteredAttributes.add(attribute);
        }
        HashSet<ArtifactDescriptor> matches = new HashSet<ArtifactDescriptor>();
        for (Attribute attribute : propertyFilteredAttributes) {
            matches.add(this.index.getArtifactDescriptor(attribute));
        }
        return matches;
    }

    private boolean propertiesContains(Map<String, Set<String>> filterProperties, Map<String, Set<String>> attributeProperties) {
        for (Map.Entry<String, Set<String>> filterProperty : filterProperties.entrySet()) {
            if (attributeProperties.containsKey(filterProperty.getKey()) && attributeProperties.get(filterProperty.getKey()).containsAll((Collection)filterProperty.getValue())) continue;
            return false;
        }
        return true;
    }
}

