/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.shell.osgicommand.internal;

import java.io.IOException;
import org.apache.felix.service.command.Descriptor;
import org.eclipse.virgo.shell.CommandExecutor;
import org.eclipse.virgo.shell.osgicommand.internal.GogoLinePrinter;

public final class GogoKernelShellCommand {
    private static final String BUNDLE_OP = "bundle";
    private static final String CONFIG_OP = "config";
    private static final String PACKAGE_OP = "package";
    private static final String PAR_OP = "par";
    private static final String PLAN_OP = "plan";
    private static final String SERVICE_OP = "service";
    private static final String INSTALL_OP = "install";
    private static final String SHUTDOWN_OP = "shutdown";
    private static final String NULL_STRING = "";
    private static final String SPACE = " ";
    private final CommandExecutor commandExecutor;

    public GogoKernelShellCommand(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    @Descriptor(value="list bundle artifacts")
    public void bundle(@Descriptor(value="operation (list)") String op) {
        this.doBundle(op, NULL_STRING);
    }

    @Descriptor(value="examine or manage a bundle artifact")
    public void bundle(@Descriptor(value="operation (examine|diag|headers|start|stop|refresh|uninstall)") String op, @Descriptor(value="bundle symbolic name") String bsn, @Descriptor(value="bundle version") String bv) {
        this.doBundle(op, String.valueOf(bsn) + SPACE + bv);
    }

    @Descriptor(value="examine or manage a bundle artifact")
    public void bundle(@Descriptor(value="operation (examine|diag|headers|start|stop|refresh|uninstall)") String op, @Descriptor(value="  bundle id") long bundleId) {
        this.doBundle(op, String.valueOf(bundleId));
    }

    public void doBundle(String op, String argList) {
        this.doOp(BUNDLE_OP, op, argList);
    }

    @Descriptor(value="list configuration artifacts")
    public void config(@Descriptor(value="operation (list)") String op) {
        this.doConfig(op, NULL_STRING);
    }

    @Descriptor(value="examine or manage a configuration artifact")
    public void config(@Descriptor(value="operation (examine|start|stop|refresh|uninstall)") String op, @Descriptor(value="configuration name") String configName) {
        this.doConfig(op, configName);
    }

    @Descriptor(value="examine or manage a configuration artifact")
    public void config(@Descriptor(value="operation (examine|start|stop|refresh|uninstall)") String op, @Descriptor(value="configuration name") String configName, @Descriptor(value="configuration version") String configVersion) {
        this.doConfig(op, String.valueOf(configName) + SPACE + configVersion);
    }

    public void doConfig(String op, String argList) {
        this.doOp(CONFIG_OP, op, argList);
    }

    @Descriptor(value="list exported packages")
    public void packages(@Descriptor(value="operation (list)") String op) {
        this.doPackage(op, NULL_STRING);
    }

    @Descriptor(value="examine an exported package")
    public void packages(@Descriptor(value="operation (examine)") String op, @Descriptor(value="package name") String packageName, @Descriptor(value="package version") String packageVersion) {
        this.doPackage(op, String.valueOf(packageName) + SPACE + packageVersion);
    }

    public void doPackage(String op, String argList) {
        this.doOp(PACKAGE_OP, op, argList);
    }

    @Descriptor(value="list PAR artifacts")
    public void par(@Descriptor(value="operation (list)") String op) {
        this.doPar(op, NULL_STRING);
    }

    @Descriptor(value="examine or manage a PAR artifact")
    public void par(@Descriptor(value="operation (examine|start|stop|refresh|uninstall)") String op, @Descriptor(value="PAR name") String parName, @Descriptor(value="PAR version") String parVersion) {
        this.doPar(op, String.valueOf(parName) + SPACE + parVersion);
    }

    public void doPar(String op, String argList) {
        this.doOp(PAR_OP, op, argList);
    }

    @Descriptor(value="list plan artifacts")
    public void plan(@Descriptor(value="operation (list)") String op) {
        this.doPlan(op, NULL_STRING);
    }

    @Descriptor(value="examine or manage a plan artifact")
    public void plan(@Descriptor(value="operation (examine|start|stop|refresh|uninstall)") String op, @Descriptor(value="plan name") String planName, @Descriptor(value="plan version") String planVersion) {
        this.doPlan(op, String.valueOf(planName) + SPACE + planVersion);
    }

    public void doPlan(String op, String argList) {
        this.doOp(PLAN_OP, op, argList);
    }

    @Descriptor(value="list all services in the service registry")
    public void service(@Descriptor(value="operation (list)") String op) {
        this.doService(op, NULL_STRING);
    }

    @Descriptor(value="examine a service in the service registry")
    public void service(@Descriptor(value="operation (examine)") String op, @Descriptor(value="  service id") long serviceId) {
        this.doService(op, String.valueOf(serviceId));
    }

    public void doService(String op, String argList) {
        this.doOp(SERVICE_OP, op, argList);
    }

    @Descriptor(value="install (deploy) an artifact")
    public void install(@Descriptor(value="artifact URI") String configName) {
        this.doOp(INSTALL_OP, configName);
    }

    @Descriptor(value="shut down the kernel")
    public void shutdown() {
        this.doOp(SHUTDOWN_OP, NULL_STRING);
    }

    private void doOp(String mainOp, String subOp, String argList) {
        String args = this.concatArgs(mainOp, subOp, argList);
        try {
            boolean continueCommands = this.commandExecutor.execute(args, new GogoLinePrinter());
            if (!continueCommands) {
                System.out.println("vsh: command '" + args + "' requested exit");
            }
        }
        catch (IOException e) {
            System.out.println("vsh: command '" + args + "' threw an exception...");
            e.printStackTrace(System.out);
        }
    }

    private void doOp(String op, String argList) {
        String args = this.concatArgs(op, argList);
        try {
            boolean continueCommands = this.commandExecutor.execute(args, new GogoLinePrinter());
            if (!continueCommands) {
                System.out.println("vsh: command '" + args + "' requested exit");
            }
        }
        catch (IOException e) {
            System.out.println("vsh: command '" + args + "' threw an exception...");
            e.printStackTrace(System.out);
        }
    }

    private String concatArgs(String cmd, String ... args) {
        StringBuffer result = new StringBuffer(cmd).append(SPACE);
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            result.append(arg).append(SPACE);
            ++n2;
        }
        return result.toString();
    }
}

