/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.snaps.core.internal.webapp.container;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.eclipse.virgo.snaps.core.internal.SnapException;
import org.eclipse.virgo.snaps.core.internal.webapp.ImmutableFilterConfig;
import org.eclipse.virgo.snaps.core.internal.webapp.SnapServletContext;
import org.eclipse.virgo.snaps.core.internal.webapp.config.FilterDefinition;
import org.eclipse.virgo.snaps.core.internal.webapp.config.FilterDispatcherType;
import org.eclipse.virgo.snaps.core.internal.webapp.config.ServletNameFilterMappingDefinition;
import org.eclipse.virgo.snaps.core.internal.webapp.config.UrlPatternFilterMappingDefinition;
import org.eclipse.virgo.snaps.core.internal.webapp.config.WebXml;
import org.eclipse.virgo.snaps.core.internal.webapp.container.FilterHolder;
import org.eclipse.virgo.snaps.core.internal.webapp.container.ManagerUtils;
import org.eclipse.virgo.snaps.core.internal.webapp.url.FilterUrlPatternMatcher;

class FilterManager {
    private final List<SnapServletContext> snapServletContexts = new ArrayList<SnapServletContext>();
    private final ClassLoader classLoader;
    private final List<FilterHolder> filters = Collections.synchronizedList(new ArrayList());
    private final List<UrlPatternFilterMapping> urlPatternFilterMappings = Collections.synchronizedList(new ArrayList());
    private final List<ServletNameFilterMapping> servletNameFilterMappings = Collections.synchronizedList(new ArrayList());
    private WebXml webXml;
    private Map<String, FilterHolder> filtersMap;

    public FilterManager(WebXml webXml, SnapServletContext snapServletContext, ClassLoader classLoader) {
        this.webXml = webXml;
        this.snapServletContexts.add(snapServletContext);
        this.classLoader = classLoader;
        this.filtersMap = this.processFilters();
        this.reifyWebXml(snapServletContext);
    }

    private void reifyWebXml(SnapServletContext snapServletContext) {
        this.processUrlPatternFilterMappings(snapServletContext);
        this.processServletNameFilterMappings();
    }

    private Map<String, FilterHolder> processFilters() throws SnapException {
        HashMap<String, FilterHolder> filtersMap = new HashMap<String, FilterHolder>();
        FilterDefinition[] filterDefinitionArray = this.webXml.getFilterDefinitions();
        int n = filterDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                FilterDefinition filterDefinition = filterDefinitionArray[n2];
                try {
                    Class<?> filterClass = ManagerUtils.loadComponentClass(filterDefinition.getFilterClassName(), this.classLoader);
                    if (Filter.class.isAssignableFrom(filterClass)) {
                        Filter filter = (Filter)filterClass.newInstance();
                        FilterHolder filterHolder = new FilterHolder(filterDefinition, filter);
                        filtersMap.put(filterDefinition.getFilterName(), filterHolder);
                        this.filters.add(filterHolder);
                        break block6;
                    }
                    throw new SnapException("The class '" + filterClass.getName() + "' does not implement '" + Filter.class.getName() + "'");
                }
                catch (ClassNotFoundException e) {
                    throw new SnapException("The filter class '" + filterDefinition.getFilterClassName() + "' could not be loaded by " + this.classLoader, e);
                }
                catch (InstantiationException e) {
                    throw new SnapException("The filter class '" + filterDefinition.getFilterClassName() + "' could not be instantiated", e);
                }
                catch (IllegalAccessException e) {
                    throw new SnapException("The filter class '" + filterDefinition.getFilterClassName() + "' could not be instantiated due to access restrictions", e);
                }
            }
            ++n2;
        }
        return filtersMap;
    }

    private void processUrlPatternFilterMappings(SnapServletContext snapServletContext) throws SnapException {
        UrlPatternFilterMappingDefinition[] urlPatternFilterMappingDefinitionArray = this.webXml.getUrlPatternFilterMappingDefinitions();
        int n = urlPatternFilterMappingDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            UrlPatternFilterMappingDefinition definition = urlPatternFilterMappingDefinitionArray[n2];
            Filter filter = (Filter)this.filtersMap.get(definition.getFilterName()).getInstance();
            this.urlPatternFilterMappings.add(new UrlPatternFilterMapping(filter, ManagerUtils.expandMapping(definition.getUrlPattern(), snapServletContext), definition.getFilterDispatcherTypes()));
            ++n2;
        }
    }

    private void processServletNameFilterMappings() {
        ServletNameFilterMappingDefinition[] servletNameFilterMappingDefinitionArray = this.webXml.getServletNameFilterMappingDefinitions();
        int n = servletNameFilterMappingDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ServletNameFilterMappingDefinition definition = servletNameFilterMappingDefinitionArray[n2];
            Filter filter = (Filter)this.filtersMap.get(definition.getFilterName()).getInstance();
            this.servletNameFilterMappings.add(new ServletNameFilterMapping(filter, definition.getServletName(), definition.getFilterDispatcherTypes()));
            ++n2;
        }
    }

    void init() throws ServletException {
        try {
            ManagerUtils.doWithThreadContextClassLoader(this.classLoader, new ManagerUtils.ClassLoaderCallback<Void>(){

                @Override
                public Void doWithClassLoader() throws ServletException {
                    for (FilterHolder filterHolder : FilterManager.this.filters) {
                        ImmutableFilterConfig config = new ImmutableFilterConfig((FilterDefinition)filterHolder.getDefinition(), (ServletContext)FilterManager.this.snapServletContexts.get(0));
                        ((Filter)filterHolder.getInstance()).init((FilterConfig)config);
                    }
                    return null;
                }
            });
        }
        catch (IOException e) {
            throw new ServletException("Unexpected IOException from filter init", (Throwable)e);
        }
    }

    void destroy() {
        for (FilterHolder holder : this.filters) {
            ((Filter)holder.getInstance()).destroy();
        }
        this.filters.clear();
    }

    Filter[] findMatches(String path, String servletName, FilterDispatcherType dispatcherType) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        for (UrlPatternFilterMapping urlPatternFilterMapping : this.urlPatternFilterMappings) {
            if (!urlPatternFilterMapping.matches(path, dispatcherType)) continue;
            filters.add(urlPatternFilterMapping.getFilter());
        }
        for (ServletNameFilterMapping servletNameFilterMapping : this.servletNameFilterMappings) {
            if (!servletNameFilterMapping.matches(servletName, dispatcherType)) continue;
            filters.add(servletNameFilterMapping.getFilter());
        }
        return filters.toArray(new Filter[filters.size()]);
    }

    public void addSnapServletContext(SnapServletContext snapServletContext) {
        this.snapServletContexts.add(snapServletContext);
        this.processUrlPatternFilterMappings(snapServletContext);
    }

    private static abstract class FilterMapping {
        private final Filter filter;
        protected final Set<FilterDispatcherType> dispatcherTypes;

        private FilterMapping(Filter filter, Set<FilterDispatcherType> dispatcherTypes) {
            this.filter = filter;
            this.dispatcherTypes = dispatcherTypes;
        }

        Filter getFilter() {
            return this.filter;
        }
    }

    private static class ServletNameFilterMapping
    extends FilterMapping {
        private final String servletName;

        private ServletNameFilterMapping(Filter filter, String servletName, Set<FilterDispatcherType> dispatcherTypes) {
            super(filter, dispatcherTypes);
            this.servletName = servletName;
        }

        private boolean matches(String servletName, FilterDispatcherType dispatcherType) {
            return this.dispatcherTypes.contains((Object)dispatcherType) && this.servletName.equals(servletName);
        }
    }

    private static class UrlPatternFilterMapping
    extends FilterMapping {
        private final FilterUrlPatternMatcher patternMatcher;

        private UrlPatternFilterMapping(Filter filter, String pattern, Set<FilterDispatcherType> dispatcherTypes) {
            super(filter, dispatcherTypes);
            this.patternMatcher = new FilterUrlPatternMatcher(pattern);
        }

        private boolean matches(String path, FilterDispatcherType dispatcherType) {
            return this.dispatcherTypes.contains((Object)dispatcherType) && this.patternMatcher.matches(path);
        }
    }
}

