/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;
import org.apache.catalina.AccessLog;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.coyote.RequestInfo;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.B2CConverter;

public class AccessLogValve
extends ValveBase
implements AccessLog {
    private static final Log log = LogFactory.getLog(AccessLogValve.class);
    private volatile String dateStamp = "";
    private String directory = "logs";
    protected static final String info = "org.apache.catalina.valves.AccessLogValve/2.2";
    protected boolean enabled = true;
    protected String pattern = null;
    protected String prefix = "access_log.";
    protected boolean rotatable = true;
    private boolean buffered = true;
    protected String suffix = "";
    protected PrintWriter writer = null;
    protected SimpleDateFormat fileDateFormatter = null;
    private static final TimeZone timezone;
    private static final String timeZoneNoDST;
    private static final String timeZoneDST;
    private static final int globalCacheSize = 300;
    private static final int localCacheSize = 60;
    protected File currentLogFile = null;
    private static final DateFormatCache globalDateCache;
    private static final ThreadLocal<DateFormatCache> localDateCache;
    private static final ThreadLocal<Date> localDate;
    private boolean resolveHosts = false;
    private volatile long rotationLastChecked = 0L;
    private boolean checkExists = false;
    protected String condition = null;
    protected String conditionIf = null;
    protected String fileDateFormat = null;
    protected String localeName = Locale.getDefault().toString();
    protected Locale locale = Locale.getDefault();
    protected String encoding = null;
    protected AccessLogElement[] logElements = null;
    protected boolean requestAttributesEnabled = false;

    public AccessLogValve() {
        super(true);
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void setRequestAttributesEnabled(boolean requestAttributesEnabled) {
        this.requestAttributesEnabled = requestAttributesEnabled;
    }

    @Override
    public boolean getRequestAttributesEnabled() {
        return this.requestAttributesEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    @Override
    public String getInfo() {
        return info;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern == null ? "" : (pattern.equals("common") ? "%h %l %u %t \"%r\" %s %b" : (pattern.equals("combined") ? "%h %l %u %t \"%r\" %s %b \"%{Referer}i\" \"%{User-Agent}i\"" : pattern));
        this.logElements = this.createLogElements();
    }

    public boolean isCheckExists() {
        return this.checkExists;
    }

    public void setCheckExists(boolean checkExists) {
        this.checkExists = checkExists;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public boolean isRotatable() {
        return this.rotatable;
    }

    public void setRotatable(boolean rotatable) {
        this.rotatable = rotatable;
    }

    public boolean isBuffered() {
        return this.buffered;
    }

    public void setBuffered(boolean buffered) {
        this.buffered = buffered;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setResolveHosts(boolean resolveHosts) {
        this.resolveHosts = resolveHosts;
    }

    public boolean isResolveHosts() {
        return this.resolveHosts;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public String getConditionUnless() {
        return this.getCondition();
    }

    public void setConditionUnless(String condition) {
        this.setCondition(condition);
    }

    public String getConditionIf() {
        return this.conditionIf;
    }

    public void setConditionIf(String condition) {
        this.conditionIf = condition;
    }

    public String getFileDateFormat() {
        return this.fileDateFormat;
    }

    public void setFileDateFormat(String fileDateFormat) {
        this.fileDateFormat = fileDateFormat;
    }

    public String getLocale() {
        return this.localeName;
    }

    public void setLocale(String localeName) {
        this.localeName = localeName;
        this.locale = AccessLogValve.findLocale(localeName, this.locale);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding != null && encoding.length() > 0 ? encoding : null;
    }

    @Override
    public synchronized void backgroundProcess() {
        if (this.getState().isAvailable() && this.getEnabled() && this.writer != null && this.buffered) {
            this.writer.flush();
        }
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        this.getNext().invoke(request, response);
    }

    @Override
    public void log(Request request, Response response, long time) {
        if (!this.getState().isAvailable() || !this.getEnabled() || this.logElements == null || this.condition != null && null != request.getRequest().getAttribute(this.condition) || this.conditionIf != null && null == request.getRequest().getAttribute(this.conditionIf)) {
            return;
        }
        long start = request.getCoyoteRequest().getStartTime();
        Date date = AccessLogValve.getDate(start + time);
        StringBuilder result = new StringBuilder(128);
        for (int i = 0; i < this.logElements.length; ++i) {
            this.logElements[i].addElement(result, date, request, response, time);
        }
        this.log(result.toString());
    }

    public synchronized boolean rotate(String newFileName) {
        if (this.currentLogFile != null) {
            File holder = this.currentLogFile;
            this.close();
            try {
                holder.renameTo(new File(newFileName));
            }
            catch (Throwable e) {
                ExceptionUtils.handleThrowable((Throwable)e);
                log.error((Object)sm.getString("accessLogValve.rotateFail"), e);
            }
            this.dateStamp = this.fileDateFormatter.format(new Date(System.currentTimeMillis()));
            this.open();
            return true;
        }
        return false;
    }

    private synchronized void close() {
        if (this.writer == null) {
            return;
        }
        this.writer.flush();
        this.writer.close();
        this.writer = null;
        this.dateStamp = "";
        this.currentLogFile = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(String message) {
        long systime;
        if (this.rotatable && (systime = System.currentTimeMillis()) - this.rotationLastChecked > 1000L) {
            AccessLogValve accessLogValve = this;
            synchronized (accessLogValve) {
                if (systime - this.rotationLastChecked > 1000L) {
                    this.rotationLastChecked = systime;
                    String tsDate = this.fileDateFormatter.format(new Date(systime));
                    if (!this.dateStamp.equals(tsDate)) {
                        this.close();
                        this.dateStamp = tsDate;
                        this.open();
                    }
                }
            }
        }
        if (this.checkExists) {
            AccessLogValve accessLogValve = this;
            synchronized (accessLogValve) {
                if (this.currentLogFile != null && !this.currentLogFile.exists()) {
                    try {
                        this.close();
                    }
                    catch (Throwable e) {
                        ExceptionUtils.handleThrowable((Throwable)e);
                        log.info((Object)sm.getString("accessLogValve.closeFail"), e);
                    }
                    this.dateStamp = this.fileDateFormatter.format(new Date(System.currentTimeMillis()));
                    this.open();
                }
            }
        }
        AccessLogValve accessLogValve = this;
        synchronized (accessLogValve) {
            if (this.writer != null) {
                this.writer.println(message);
                if (!this.buffered) {
                    this.writer.flush();
                }
            }
        }
    }

    protected synchronized void open() {
        File pathname;
        File parent;
        File dir = new File(this.directory);
        if (!dir.isAbsolute()) {
            dir = new File(System.getProperty("catalina.base"), this.directory);
        }
        if (!dir.mkdirs() && !dir.isDirectory()) {
            log.error((Object)sm.getString("accessLogValve.openDirFail", new Object[]{dir}));
        }
        if (!(parent = (pathname = this.rotatable ? new File(dir.getAbsoluteFile(), this.prefix + this.dateStamp + this.suffix) : new File(dir.getAbsoluteFile(), this.prefix + this.suffix)).getParentFile()).mkdirs() && !parent.isDirectory()) {
            log.error((Object)sm.getString("accessLogValve.openDirFail", new Object[]{parent}));
        }
        Charset charset = null;
        if (this.encoding != null) {
            try {
                charset = B2CConverter.getCharset((String)this.encoding);
            }
            catch (UnsupportedEncodingException ex) {
                log.error((Object)sm.getString("accessLogValve.unsupportedEncoding", new Object[]{this.encoding}), (Throwable)ex);
            }
        }
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        try {
            this.writer = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(pathname, true), charset), 128000), false);
            this.currentLogFile = pathname;
        }
        catch (IOException e) {
            this.writer = null;
            this.currentLogFile = null;
            log.error((Object)sm.getString("accessLogValve.openFail", new Object[]{pathname}), (Throwable)e);
        }
    }

    private static Date getDate(long systime) {
        Date date = localDate.get();
        date.setTime(systime);
        return date;
    }

    private static String getTimeZone(Date date) {
        if (timezone.inDaylightTime(date)) {
            return timeZoneDST;
        }
        return timeZoneNoDST;
    }

    private static String calculateTimeZoneOffset(long offset) {
        StringBuilder tz = new StringBuilder();
        if (offset < 0L) {
            tz.append("-");
            offset = -offset;
        } else {
            tz.append("+");
        }
        long hourOffset = offset / 3600000L;
        long minuteOffset = offset / 60000L % 60L;
        if (hourOffset < 10L) {
            tz.append("0");
        }
        tz.append(hourOffset);
        if (minuteOffset < 10L) {
            tz.append("0");
        }
        tz.append(minuteOffset);
        return tz.toString();
    }

    protected static Locale findLocale(String name, Locale fallback) {
        if (name == null || name.isEmpty()) {
            return Locale.getDefault();
        }
        for (Locale l : Locale.getAvailableLocales()) {
            if (!name.equals(l.toString())) continue;
            return l;
        }
        log.error((Object)sm.getString("accessLogValve.invalidLocale", new Object[]{name}));
        return fallback;
    }

    @Override
    protected synchronized void startInternal() throws LifecycleException {
        String format = this.getFileDateFormat();
        if (format == null || format.length() == 0) {
            format = "yyyy-MM-dd";
            this.setFileDateFormat(format);
        }
        this.fileDateFormatter = new SimpleDateFormat(format, Locale.US);
        this.fileDateFormatter.setTimeZone(timezone);
        this.dateStamp = this.fileDateFormatter.format(new Date(System.currentTimeMillis()));
        this.open();
        this.setState(LifecycleState.STARTING);
    }

    @Override
    protected synchronized void stopInternal() throws LifecycleException {
        this.setState(LifecycleState.STOPPING);
        this.close();
    }

    protected AccessLogElement[] createLogElements() {
        ArrayList<AccessLogElement> list = new ArrayList<AccessLogElement>();
        boolean replace = false;
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.pattern.length(); ++i) {
            char ch = this.pattern.charAt(i);
            if (replace) {
                if ('{' == ch) {
                    int j;
                    StringBuilder name = new StringBuilder();
                    for (j = i + 1; j < this.pattern.length() && '}' != this.pattern.charAt(j); ++j) {
                        name.append(this.pattern.charAt(j));
                    }
                    if (j + 1 < this.pattern.length()) {
                        list.add(this.createAccessLogElement(name.toString(), this.pattern.charAt(++j)));
                        i = j;
                    } else {
                        list.add(this.createAccessLogElement(ch));
                    }
                } else {
                    list.add(this.createAccessLogElement(ch));
                }
                replace = false;
                continue;
            }
            if (ch == '%') {
                replace = true;
                list.add(new StringElement(buf.toString()));
                buf = new StringBuilder();
                continue;
            }
            buf.append(ch);
        }
        if (buf.length() > 0) {
            list.add(new StringElement(buf.toString()));
        }
        return list.toArray(new AccessLogElement[0]);
    }

    protected AccessLogElement createAccessLogElement(String header, char pattern) {
        switch (pattern) {
            case 'i': {
                return new HeaderElement(header);
            }
            case 'c': {
                return new CookieElement(header);
            }
            case 'o': {
                return new ResponseHeaderElement(header);
            }
            case 'r': {
                return new RequestAttributeElement(header);
            }
            case 's': {
                return new SessionAttributeElement(header);
            }
            case 't': {
                return new DateAndTimeElement(header);
            }
        }
        return new StringElement("???");
    }

    protected AccessLogElement createAccessLogElement(char pattern) {
        switch (pattern) {
            case 'a': {
                return new RemoteAddrElement();
            }
            case 'A': {
                return new LocalAddrElement();
            }
            case 'b': {
                return new ByteSentElement(true);
            }
            case 'B': {
                return new ByteSentElement(false);
            }
            case 'D': {
                return new ElapsedTimeElement(true);
            }
            case 'h': {
                return new HostElement();
            }
            case 'H': {
                return new ProtocolElement();
            }
            case 'l': {
                return new LogicalUserNameElement();
            }
            case 'm': {
                return new MethodElement();
            }
            case 'p': {
                return new LocalPortElement();
            }
            case 'q': {
                return new QueryElement();
            }
            case 'r': {
                return new RequestElement();
            }
            case 's': {
                return new HttpStatusCodeElement();
            }
            case 'S': {
                return new SessionIdElement();
            }
            case 't': {
                return new DateAndTimeElement();
            }
            case 'T': {
                return new ElapsedTimeElement(false);
            }
            case 'u': {
                return new UserElement();
            }
            case 'U': {
                return new RequestURIElement();
            }
            case 'v': {
                return new LocalServerNameElement();
            }
            case 'I': {
                return new ThreadNameElement();
            }
        }
        return new StringElement("???" + pattern + "???");
    }

    static {
        globalDateCache = new DateFormatCache(300, Locale.getDefault(), null);
        localDateCache = new ThreadLocal<DateFormatCache>(){

            @Override
            protected DateFormatCache initialValue() {
                return new DateFormatCache(60, Locale.getDefault(), globalDateCache);
            }
        };
        localDate = new ThreadLocal<Date>(){

            @Override
            protected Date initialValue() {
                return new Date();
            }
        };
        timezone = TimeZone.getDefault();
        timeZoneNoDST = AccessLogValve.calculateTimeZoneOffset(timezone.getRawOffset());
        int offset = timezone.getDSTSavings();
        timeZoneDST = AccessLogValve.calculateTimeZoneOffset(timezone.getRawOffset() + offset);
    }

    protected static class SessionAttributeElement
    implements AccessLogElement {
        private String header;

        public SessionAttributeElement(String header) {
            this.header = header;
        }

        @Override
        public void addElement(StringBuilder buf, Date date, Request request, Response response, long time) {
            Object value = null;
            if (null != request) {
                HttpSession sess = request.getSession(false);
                if (null != sess) {
                    value = sess.getAttribute(this.header);
                }
            } else {
                value = "??";
            }
            if (value != null) {
                if (value instanceof String) {
                    buf.append((String)value);
                } else {
                    buf.append(value.toString());
                }
            } else {
                buf.append('-');
            }
        }
    }

    protected static class RequestAttributeElement
    implements AccessLogElement {
        private String header;

        public RequestAttributeElement(String header) {
            this.header = header;
        }

        @Override
        public void addElement(StringBuilder buf, Date date, Request request, Response response, long time) {
            Object value = null;
            value = request != null ? request.getAttribute(this.header) : "??";
            if (value != null) {
                if (value instanceof String) {
                    buf.append((String)value);
                } else {
                    buf.append(value.toString());
                }
            } else {
                buf.append('-');
            }
        }
    }

    protected static class ResponseHeaderElement
    implements AccessLogElement {
        private String header;

        public ResponseHeaderElement(String header) {
            this.header = header;
        }

        @Override
        public void addElement(StringBuilder buf, Date date, Request request, Response response, long time) {
            Iterator<String> iter;
            if (null != response && (iter = response.getHeaders(this.header).iterator()).hasNext()) {
                buf.append(iter.next());
                while (iter.hasNext()) {
                    buf.append(',').append(iter.next());
                }
                return;
            }
            buf.append('-');
        }
    }

    protected static class CookieElement
    implements AccessLogElement {
        private String header;

        public CookieElement(String header) {
            this.header = header;
        }

        @Override
        public void addElement(StringBuilder buf, Date date, Request request, Response response, long time) {
            String value = "-";
            Cookie[] c = request.getCookies();
            if (c != null) {
                for (int i = 0; i < c.length; ++i) {
                    if (!this.header.equals(c[i].getName())) continue;
                    value = c[i].getValue();
                    break;
                }
            }
            buf.append(value);
        }
    }

    protected static class HeaderElement
    implements AccessLogElement {
        private String header;

        public HeaderElement(String header) {
            this.header = header;
        }

        @Override
        public void addElement(StringBuilder buf, Date date, Request request, Response response, long time) {
            Enumeration<String> iter = request.getHeaders(this.header);
            if (iter.hasMoreElements()) {
                buf.append(iter.nextElement());
                while (iter.hasMoreElements()) {
                    buf.append(',').append(iter.nextElement());
                }
                return;
            }
            buf.append('-');
        }
    }

    protected static class StringElement
    implements AccessLogElement {
        private String str;

        public StringElement(String str) {
            this.str = str;
        }

        @Override
        public void addElement(StringBuilder buf, Date date, Request request, Response response, long time) {
            buf.append(this.str);
        }
    }

    protected static class LocalServerNameElement
    implements AccessLogElement {
        protected LocalServerNameElement() {
        }

        @Override
        public void addElement(StringBuilder buf, Date date, Request request, Response response, long time) {
            buf.append(request.getServerName());
        }
    }

    protected static class RequestURIElement
    implements AccessLogElement {
        protected RequestURIElement() {
        }

        @Override
        public void addElement(StringBuilder buf, Date date, Request request, Response response, long time) {
            if (request != null) {
                buf.append(request.getRequestURI());
            } else {
                buf.append('-');
            }
        }
    }

    protected static class SessionIdElement
    implements AccessLogElement {
        protected SessionIdElement() {
        }

        @Override
        public void addElement(StringBuilder buf, Date date, Request request, Response response, long time) {
            if (request != null) {
                if (request.getSession(false) != null) {
                    buf.append(request.getSessionInternal(false).getIdInternal());
                } else {
                    buf.append('-');
                }
            } else {
                buf.append('-');
            }
        }
    }

    protected static class QueryElement
    implements AccessLogElement {
        protected QueryElement() {
        }

        @Override
        public void addElement(StringBuilder buf, Date date, Request request, Response response, long time) {
            String query = null;
            if (request != null) {
                query = request.getQueryString();
            }
            if (query != null) {
                buf.append('?');
                buf.append(query);
            }
        }
    }

    protected static class ElapsedTimeElement
    implements AccessLogElement {
        private boolean millis;

        public ElapsedTimeElement(boolean millis) {
            this.millis = millis;
        }

        @Override
        public void addElement(StringBuilder buf, Date date, Request request, Response response, long time) {
            if (this.millis) {
                buf.append(time);
            } else {
                buf.append(time / 1000L);
                buf.append('.');
                int remains = (int)(time % 1000L);
                buf.append(remains / 100);
                buf.append((remains %= 100) / 10);
                buf.append(remains % 10);
            }
        }
    }

    protected static class MethodElement
    implements AccessLogElement {
        protected MethodElement() {
        }

        @Override
        public void addElement(StringBuilder buf, Date date, Request request, Response response, long time) {
            if (request != null) {
                buf.append(request.getMethod());
            }
        }
    }

    protected static class ByteSentElement
    implements AccessLogElement {
        private boolean conversion;

        public ByteSentElement(boolean conversion) {
            this.conversion = conversion;
        }

        @Override
        public void addElement(StringBuilder buf, Date date, Request request, Response response, long time) {
            long length = response.getBytesWritten(false);
            if (length <= 0L && this.conversion) {
                buf.append('-');
            } else {
                buf.append(length);
            }
        }
    }

    protected class LocalPortElement
    implements AccessLogElement {
        protected LocalPortElement() {
        }

        @Override
        public void addElement(StringBuilder buf, Date date, Request request, Response response, long time) {
            if (AccessLogValve.this.requestAttributesEnabled) {
                Object port = request.getAttribute("org.apache.catalina.AccessLog.ServerPort");
                if (port == null) {
                    buf.append(request.getServerPort());
                } else {
                    buf.append(port);
                }
            } else {
                buf.append(request.getServerPort());
            }
        }
    }

    protected static class HttpStatusCodeElement
    implements AccessLogElement {
        protected HttpStatusCodeElement() {
        }

        @Override
        public void addElement(StringBuilder buf, Date date, Request request, Response response, long time) {
            if (response != null) {
                buf.append(response.getStatus());
            } else {
                buf.append('-');
            }
        }
    }

    protected static class RequestElement
    implements AccessLogElement {
        protected RequestElement() {
        }

        @Override
        public void addElement(StringBuilder buf, Date date, Request request, Response response, long time) {
            if (request != null) {
                String method = request.getMethod();
                if (method == null) {
                    buf.append('-');
                } else {
                    buf.append(request.getMethod());
                    buf.append(' ');
                    buf.append(request.getRequestURI());
                    if (request.getQueryString() != null) {
                        buf.append('?');
                        buf.append(request.getQueryString());
                    }
                    buf.append(' ');
                    buf.append(request.getProtocol());
                }
            } else {
                buf.append('-');
            }
        }
    }

    protected class DateAndTimeElement
    implements AccessLogElement {
        private static final String requestStartPrefix = "begin";
        private static final String responseEndPrefix = "end";
        private static final String prefixSeparator = ":";
        private static final String secFormat = "sec";
        private static final String msecFormat = "msec";
        private static final String msecFractionFormat = "msec_frac";
        private static final String msecPattern = "{#}";
        private static final String trippleMsecPattern = "{#}{#}{#}";
        private String format = null;
        private boolean usesBegin = false;
        private formatType type = formatType.CLF;
        private boolean usesMsecs = false;

        protected DateAndTimeElement() {
            this(null);
        }

        private void tidyFormat() {
            boolean escape = false;
            StringBuilder result = new StringBuilder();
            int len = this.format.length();
            for (int i = 0; i < len; ++i) {
                char x = this.format.charAt(i);
                if (escape || x != 'S') {
                    result.append(x);
                } else {
                    result.append(msecPattern);
                    this.usesMsecs = true;
                }
                if (x != '\'') continue;
                escape = !escape;
            }
        }

        protected DateAndTimeElement(String header) {
            this.format = header;
            if (this.format != null) {
                if (this.format.equals(requestStartPrefix)) {
                    this.usesBegin = true;
                    this.format = "";
                } else if (this.format.startsWith("begin:")) {
                    this.usesBegin = true;
                    this.format = this.format.substring(6);
                } else if (this.format.equals(responseEndPrefix)) {
                    this.usesBegin = false;
                    this.format = "";
                } else if (this.format.startsWith("end:")) {
                    this.usesBegin = false;
                    this.format = this.format.substring(4);
                }
                if (this.format.length() == 0) {
                    this.type = formatType.CLF;
                } else if (this.format.equals(secFormat)) {
                    this.type = formatType.SEC;
                } else if (this.format.equals(msecFormat)) {
                    this.type = formatType.MSEC;
                } else if (this.format.equals(msecFractionFormat)) {
                    this.type = formatType.MSEC_FRAC;
                } else {
                    this.type = formatType.SDF;
                    this.tidyFormat();
                }
            }
        }

        @Override
        public void addElement(StringBuilder buf, Date date, Request request, Response response, long time) {
            long timestamp = date.getTime();
            if (this.usesBegin) {
                timestamp -= time;
            }
            switch (this.type) {
                case CLF: {
                    buf.append(((DateFormatCache)localDateCache.get()).getFormat(timestamp));
                    break;
                }
                case SEC: {
                    buf.append(timestamp / 1000L);
                    break;
                }
                case MSEC: {
                    buf.append(timestamp);
                    break;
                }
                case MSEC_FRAC: {
                    long frac = timestamp % 1000L;
                    if (frac < 100L) {
                        if (frac < 10L) {
                            buf.append('0');
                            buf.append('0');
                        } else {
                            buf.append('0');
                        }
                    }
                    buf.append(frac);
                    break;
                }
                case SDF: {
                    String temp = ((DateFormatCache)localDateCache.get()).getFormat(this.format, AccessLogValve.this.locale, timestamp);
                    if (this.usesMsecs) {
                        long frac = timestamp % 1000L;
                        StringBuilder trippleMsec = new StringBuilder(4);
                        if (frac < 100L) {
                            if (frac < 10L) {
                                trippleMsec.append('0');
                                trippleMsec.append('0');
                            } else {
                                trippleMsec.append('0');
                            }
                        }
                        trippleMsec.append(frac);
                        temp = temp.replace(trippleMsecPattern, trippleMsec);
                        temp = temp.replace(msecPattern, Long.toString(frac));
                    }
                    buf.append(temp);
                }
            }
        }
    }

    protected static class UserElement
    implements AccessLogElement {
        protected UserElement() {
        }

        @Override
        public void addElement(StringBuilder buf, Date date, Request request, Response response, long time) {
            if (request != null) {
                String value = request.getRemoteUser();
                if (value != null) {
                    buf.append(value);
                } else {
                    buf.append('-');
                }
            } else {
                buf.append('-');
            }
        }
    }

    protected class ProtocolElement
    implements AccessLogElement {
        protected ProtocolElement() {
        }

        @Override
        public void addElement(StringBuilder buf, Date date, Request request, Response response, long time) {
            if (AccessLogValve.this.requestAttributesEnabled) {
                Object proto = request.getAttribute("org.apache.catalina.AccessLog.Protocol");
                if (proto == null) {
                    buf.append(request.getProtocol());
                } else {
                    buf.append(proto);
                }
            } else {
                buf.append(request.getProtocol());
            }
        }
    }

    protected static class LogicalUserNameElement
    implements AccessLogElement {
        protected LogicalUserNameElement() {
        }

        @Override
        public void addElement(StringBuilder buf, Date date, Request request, Response response, long time) {
            buf.append('-');
        }
    }

    protected class HostElement
    implements AccessLogElement {
        protected HostElement() {
        }

        @Override
        public void addElement(StringBuilder buf, Date date, Request request, Response response, long time) {
            Object host;
            String value = null;
            if (AccessLogValve.this.requestAttributesEnabled && (host = request.getAttribute("org.apache.catalina.AccessLog.RemoteHost")) != null) {
                value = host.toString();
            }
            if (value == null || value.length() == 0) {
                value = request.getRemoteHost();
            }
            if (value == null || value.length() == 0) {
                value = "-";
            }
            buf.append(value);
        }
    }

    protected class RemoteAddrElement
    implements AccessLogElement {
        protected RemoteAddrElement() {
        }

        @Override
        public void addElement(StringBuilder buf, Date date, Request request, Response response, long time) {
            if (AccessLogValve.this.requestAttributesEnabled) {
                Object addr = request.getAttribute("org.apache.catalina.AccessLog.RemoteAddr");
                if (addr == null) {
                    buf.append(request.getRemoteAddr());
                } else {
                    buf.append(addr);
                }
            } else {
                buf.append(request.getRemoteAddr());
            }
        }
    }

    protected static class LocalAddrElement
    implements AccessLogElement {
        private static final String LOCAL_ADDR_VALUE;

        protected LocalAddrElement() {
        }

        @Override
        public void addElement(StringBuilder buf, Date date, Request request, Response response, long time) {
            buf.append(LOCAL_ADDR_VALUE);
        }

        static {
            String init;
            try {
                init = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Throwable e) {
                ExceptionUtils.handleThrowable((Throwable)e);
                init = "127.0.0.1";
            }
            LOCAL_ADDR_VALUE = init;
        }
    }

    protected static class ThreadNameElement
    implements AccessLogElement {
        protected ThreadNameElement() {
        }

        @Override
        public void addElement(StringBuilder buf, Date date, Request request, Response response, long time) {
            RequestInfo info = request.getCoyoteRequest().getRequestProcessor();
            if (info != null) {
                buf.append(info.getWorkerThreadName());
            } else {
                buf.append("-");
            }
        }
    }

    protected static interface AccessLogElement {
        public void addElement(StringBuilder var1, Date var2, Request var3, Response var4, long var5);
    }

    private static enum formatType {
        CLF,
        SEC,
        MSEC,
        MSEC_FRAC,
        SDF;

    }

    private static class DateFormatCache {
        private int cacheSize = 0;
        private Locale cacheDefaultLocale;
        private DateFormatCache parent;
        private Cache cLFCache;
        private HashMap<String, Cache> formatCache = new HashMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DateFormatCache(int size, Locale loc, DateFormatCache parent) {
            this.cacheSize = size;
            this.cacheDefaultLocale = loc;
            this.parent = parent;
            Cache parentCache = null;
            if (parent != null) {
                DateFormatCache dateFormatCache = parent;
                synchronized (dateFormatCache) {
                    parentCache = parent.getCache(null, null);
                }
            }
            this.cLFCache = new Cache(parentCache);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Cache getCache(String format, Locale loc) {
            Cache cache;
            if (format == null) {
                cache = this.cLFCache;
            } else {
                cache = this.formatCache.get(format);
                if (cache == null) {
                    Cache parentCache = null;
                    if (this.parent != null) {
                        DateFormatCache dateFormatCache = this.parent;
                        synchronized (dateFormatCache) {
                            parentCache = this.parent.getCache(format, loc);
                        }
                    }
                    cache = new Cache(format, loc, parentCache);
                    this.formatCache.put(format, cache);
                }
            }
            return cache;
        }

        public String getFormat(long time) {
            return this.cLFCache.getFormatInternal(time);
        }

        public String getFormat(String format, Locale loc, long time) {
            return this.getCache(format, loc).getFormatInternal(time);
        }

        private class Cache {
            private static final String cLFFormat = "dd/MMM/yyyy:HH:mm:ss";
            private long previousSeconds = 0L;
            private String previousFormat = "";
            private long first = 0L;
            private long last = 0L;
            private int offset = 0;
            private final Date currentDate = new Date();
            private String[] cache;
            private SimpleDateFormat formatter;
            private boolean isCLF = false;
            private Cache parent = null;

            private Cache(Cache parent) {
                this(null, parent);
            }

            private Cache(String format, Cache parent) {
                this(format, null, parent);
            }

            private Cache(String format, Locale loc, Cache parent) {
                this.cache = new String[DateFormatCache.this.cacheSize];
                for (int i = 0; i < DateFormatCache.this.cacheSize; ++i) {
                    this.cache[i] = null;
                }
                if (loc == null) {
                    loc = DateFormatCache.this.cacheDefaultLocale;
                }
                if (format == null) {
                    this.isCLF = true;
                    format = cLFFormat;
                    this.formatter = new SimpleDateFormat(format, Locale.US);
                } else {
                    this.formatter = new SimpleDateFormat(format, loc);
                }
                this.formatter.setTimeZone(TimeZone.getDefault());
                this.parent = parent;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private String getFormatInternal(long time) {
                int i;
                long seconds = time / 1000L;
                if (seconds == this.previousSeconds) {
                    return this.previousFormat;
                }
                this.previousSeconds = seconds;
                int index = (this.offset + (int)(seconds - this.first)) % DateFormatCache.this.cacheSize;
                if (index < 0) {
                    index += DateFormatCache.this.cacheSize;
                }
                if (seconds >= this.first && seconds <= this.last) {
                    if (this.cache[index] != null) {
                        this.previousFormat = this.cache[index];
                        return this.previousFormat;
                    }
                } else if (seconds >= this.last + (long)DateFormatCache.this.cacheSize || seconds <= this.first - (long)DateFormatCache.this.cacheSize) {
                    this.first = seconds;
                    this.last = this.first + (long)DateFormatCache.this.cacheSize - 1L;
                    index = 0;
                    this.offset = 0;
                    for (i = 1; i < DateFormatCache.this.cacheSize; ++i) {
                        this.cache[i] = null;
                    }
                } else if (seconds > this.last) {
                    i = 1;
                    while ((long)i < seconds - this.last) {
                        this.cache[(index + ((DateFormatCache)DateFormatCache.this).cacheSize - i) % ((DateFormatCache)DateFormatCache.this).cacheSize] = null;
                        ++i;
                    }
                    this.first = seconds - (long)DateFormatCache.this.cacheSize;
                    this.last = seconds;
                } else if (seconds < this.first) {
                    i = 1;
                    while ((long)i < this.first - seconds) {
                        this.cache[(index + i) % ((DateFormatCache)DateFormatCache.this).cacheSize] = null;
                        ++i;
                    }
                    this.first = seconds;
                    this.last = seconds + (long)DateFormatCache.this.cacheSize;
                }
                if (this.parent != null) {
                    Cache i2 = this.parent;
                    synchronized (i2) {
                        this.previousFormat = this.parent.getFormatInternal(time);
                    }
                } else {
                    this.currentDate.setTime(time);
                    this.previousFormat = this.formatter.format(this.currentDate);
                    if (this.isCLF) {
                        StringBuilder current = new StringBuilder(32);
                        current.append('[');
                        current.append(this.previousFormat);
                        current.append(' ');
                        current.append(AccessLogValve.getTimeZone(this.currentDate));
                        current.append(']');
                        this.previousFormat = current.toString();
                    }
                }
                this.cache[index] = this.previousFormat;
                return this.previousFormat;
            }
        }
    }
}

