/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public abstract class OsgiBundleUtils {
    static /* synthetic */ Class class$org$osgi$framework$BundleContext;

    public static BundleContext getBundleContext(final Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        Method meth = ReflectionUtils.findMethod(bundle.getClass(), (String)"getContext", (Class[])new Class[0]);
        if (meth == null) {
            meth = ReflectionUtils.findMethod(bundle.getClass(), (String)"getBundleContext", (Class[])new Class[0]);
        }
        Method m = meth;
        if (meth != null) {
            ReflectionUtils.makeAccessible((Method)meth);
            return (BundleContext)ReflectionUtils.invokeMethod((Method)m, (Object)bundle);
        }
        final BundleContext[] ctx = new BundleContext[1];
        ReflectionUtils.doWithFields(bundle.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                ReflectionUtils.makeAccessible((Field)field);
                ctx[0] = (BundleContext)field.get(bundle);
            }
        }, (ReflectionUtils.FieldFilter)new ReflectionUtils.FieldFilter(){

            public boolean matches(Field field) {
                return (class$org$osgi$framework$BundleContext == null ? (class$org$osgi$framework$BundleContext = OsgiBundleUtils.class$("org.osgi.framework.BundleContext")) : class$org$osgi$framework$BundleContext).isAssignableFrom(field.getType());
            }
        });
        return ctx[0];
    }

    public static boolean isBundleActive(Bundle bundle) {
        Assert.notNull((Object)bundle, (String)"bundle is required");
        return bundle.getState() == 32;
    }

    public static boolean isBundleResolved(Bundle bundle) {
        Assert.notNull((Object)bundle, (String)"bundle is required");
        return bundle.getState() >= 4;
    }

    public static boolean isFragment(Bundle bundle) {
        Assert.notNull((Object)bundle, (String)"bundle is required");
        return bundle.getHeaders().get("Fragment-Host") != null;
    }

    public static boolean isSystemBundle(Bundle bundle) {
        Assert.notNull((Object)bundle);
        return bundle.getBundleId() == 0L;
    }

    public static Version getBundleVersion(Bundle bundle) {
        return OsgiBundleUtils.getHeaderAsVersion(bundle, "Bundle-Version");
    }

    public static Bundle findBundleBySymbolicName(BundleContext bundleContext, String symbolicName) {
        Assert.notNull((Object)bundleContext, (String)"bundleContext is required");
        Assert.hasText((String)symbolicName, (String)"a not-null/not-empty symbolicName isrequired");
        Bundle[] bundles = bundleContext.getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            if (!symbolicName.equals(bundles[i].getSymbolicName())) continue;
            return bundles[i];
        }
        return null;
    }

    public static Version getHeaderAsVersion(Bundle bundle, String header) {
        Assert.notNull((Object)bundle);
        return Version.parseVersion((String)((String)bundle.getHeaders().get(header)));
    }
}

