/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.filetransfer.identity;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.identity.BaseID;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.ecf.internal.provider.filetransfer.Messages;

public class FileTransferID
extends BaseID
implements IFileID {
    private static final long serialVersionUID = 1274308869502156992L;
    URL fileURL;
    URI fileURI;

    public FileTransferID(Namespace namespace, URL url) {
        super(namespace);
        Assert.isNotNull((Object)url, (String)Messages.FileTransferID_Exception_Url_Not_Null);
        this.fileURL = url;
    }

    public FileTransferID(Namespace namespace, URI uri) {
        super(namespace);
        Assert.isNotNull((Object)uri, (String)"FileTransferID URI cannot be null");
        this.fileURI = uri;
    }

    protected int namespaceCompareTo(BaseID o) {
        if (o == null) {
            return 1;
        }
        if (!(o instanceof FileTransferID)) {
            return 1;
        }
        return this.fileURI != null ? this.fileURI.compareTo(((FileTransferID)o).fileURI) : this.fileURL.toExternalForm().compareTo(((FileTransferID)o).toExternalForm());
    }

    protected boolean namespaceEquals(BaseID o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof FileTransferID)) {
            return false;
        }
        return this.fileURI != null ? this.fileURI.equals(((FileTransferID)o).fileURI) : this.fileURL.equals(((FileTransferID)o).fileURL);
    }

    protected String namespaceGetName() {
        return this.fileURI != null ? this.fileURI.toASCIIString() : this.fileURL.toExternalForm();
    }

    protected int namespaceHashCode() {
        return this.fileURI != null ? this.fileURI.hashCode() : this.fileURL.hashCode();
    }

    public String getFilename() {
        return this.getFileNameOnly();
    }

    public URL getURL() throws MalformedURLException {
        return this.fileURI != null ? this.fileURI.toURL() : this.fileURL;
    }

    protected String getFileNameOnly() {
        String path = this.fileURL.getPath();
        return path.substring(path.lastIndexOf("/") + 1);
    }

    public String toString() {
        StringBuffer b = new StringBuffer("FileTransferID[");
        b.append(this.toExternalForm());
        b.append("]");
        return b.toString();
    }

    public URI getURI() throws URISyntaxException {
        return this.fileURI != null ? this.fileURI : new URI(this.fileURL.toExternalForm());
    }
}

