/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.jdbc.logging;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.Statement;
import org.apache.openejb.resource.jdbc.logging.AbstractSQLLogger;
import org.apache.openejb.resource.jdbc.logging.TimeWatcherExecutor;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class LoggingSqlStatement
extends AbstractSQLLogger
implements InvocationHandler {
    private static final Logger LOGGER = Logger.getInstance(LogCategory.OPENEJB_SQL, LoggingSqlStatement.class);
    private final Statement delegate;

    public LoggingSqlStatement(Statement result) {
        this.delegate = result;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String mtdName = method.getName();
        boolean execute = mtdName.startsWith("execute") && args != null && args.length > 0;
        TimeWatcherExecutor.TimerWatcherResult result = TimeWatcherExecutor.execute(method, this.delegate, args, execute);
        if (execute) {
            LOGGER.info(this.format((String)args[0], result.getDuration()));
        }
        return result.getResult();
    }
}

