/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.queries.SQLResult;

public class SQLResultSetMapping {
    protected String name;
    protected List<SQLResult> results;

    public SQLResultSetMapping(String name) {
        this.name = name;
        if (this.name == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("null_value_in_sqlresultsetmapping"));
        }
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        Iterator<SQLResult> iterator = this.getResults().iterator();
        while (iterator.hasNext()) {
            iterator.next().convertClassNamesToClasses(classLoader);
        }
    }

    public String getName() {
        return this.name;
    }

    public void addResult(SQLResult result) {
        if (result == null) {
            return;
        }
        this.getResults().add(result);
        result.setSQLResultMapping(this);
    }

    public List<SQLResult> getResults() {
        if (this.results == null) {
            this.results = new ArrayList<SQLResult>();
        }
        return this.results;
    }
}

