/*******************************************************************************
 * Copyright (c) 2009, 2013 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0, which accompanies this distribution
 * and is available at https://www.eclipse.org/legal/epl-2.0/.
 * 
 * Contributors:
 *     Oracle - initial API and implementation
 ******************************************************************************/
package org.eclipse.jpt.common.utility.tests.internal.iterable;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.ListListIterable;
import org.eclipse.jpt.common.utility.internal.iterable.ReadOnlyCompositeListIterable;
import org.eclipse.jpt.common.utility.iterable.ListIterable;

@SuppressWarnings("nls")
public class ReadOnlyCompositeListIterableTests
	extends TestCase
{
	public ReadOnlyCompositeListIterableTests(String name) {
		super(name);
	}

	public void testIterator() {
		List<String> c1 = new ArrayList<String>();
		c1.add("0");
		c1.add("1");
		c1.add("2");
		c1.add("3");
		ListIterable<String> li1 = new ListListIterable<String>(c1);

		List<String> c2 = new ArrayList<String>();
		c2.add("4");
		c2.add("5");
		c2.add("6");
		c2.add("7");
		ListIterable<String> li2 = new ListListIterable<String>(c2);

		@SuppressWarnings("unchecked")
		Iterable<String> composite = IterableTools.concatenateReadOnly(new ListIterable[] { li1, li2 });
		int i = 0;
		for (String s : composite) {
			assertEquals(String.valueOf(i++), s);
		}
	}

	public void testExtraElement1() {
		List<String> c1 = new ArrayList<String>();
		c1.add("0");
		c1.add("1");
		c1.add("2");
		c1.add("3");
		ListIterable<String> li1 = new ListListIterable<String>(c1);

		Iterable<String> composite = IterableTools.addReadOnly(li1, "4");
		int i = 0;
		for (String s : composite) {
			assertEquals(String.valueOf(i++), s);
		}
	}

	public void testExtraElement2() {
		List<String> c1 = new ArrayList<String>();
		c1.add("1");
		c1.add("2");
		c1.add("3");
		ListIterable<String> li1 = new ListListIterable<String>(c1);

		Iterable<String> composite = IterableTools.insertReadOnly("0", li1);
		int i = 0;
		for (String s : composite) {
			assertEquals(String.valueOf(i++), s);
		}
	}

	public void testCollectionOfIterables() {
		List<String> c1 = new ArrayList<String>();
		c1.add("0");
		c1.add("1");
		c1.add("2");
		c1.add("3");
		ListIterable<String> li1 = new ListListIterable<String>(c1);

		List<String> c2 = new ArrayList<String>();
		c2.add("4");
		c2.add("5");
		c2.add("6");
		c2.add("7");
		ListIterable<String> li2 = new ListListIterable<String>(c2);

		List<ListIterable<String>> collection = new ArrayList<ListIterable<String>>();
		collection.add(li1);
		collection.add(li2);
		ListIterable<ListIterable<String>> li = new ListListIterable<ListIterable<String>>(collection);
		
		Iterable<String> composite = new ReadOnlyCompositeListIterable<String>(li);
		int i = 0;
		for (String s : composite) {
			assertEquals(String.valueOf(i++), s);
		}
	}

	public void testToString() {
		List<String> c1 = new ArrayList<String>();
		c1.add("0");
		c1.add("1");
		c1.add("2");
		c1.add("3");
		ListIterable<String> li1 = new ListListIterable<String>(c1);

		List<String> c2 = new ArrayList<String>();
		c2.add("4");
		c2.add("5");
		c2.add("6");
		c2.add("7");
		ListIterable<String> li2 = new ListListIterable<String>(c2);

		@SuppressWarnings("unchecked")
		Iterable<String> composite = IterableTools.concatenateReadOnly(new ListIterable[] { li1, li2 });
		assertNotNull(composite.toString());
	}
}
