/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.server.core.internal.ServerPreferences;
import org.eclipse.wst.server.discovery.Discovery;
import org.eclipse.wst.server.ui.ICacheUpdateListener;
import org.eclipse.wst.server.ui.ServerUIUtil;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.ServerUIPreferences;

public class ServerPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected ServerPreferences preferences = ServerPreferences.getInstance();
    protected ServerUIPreferences uiPreferences = ServerUIPlugin.getPreferences();
    protected Button showOnActivity;
    protected Button refreshNow;
    protected Text updateTime;
    protected Combo updateCacheFrequencyCombo;
    public static final String CACHE_LAST_UPDATED_DATE_FORMAT = "EEE MMM dd yyyy kk:mm:ss zzz";
    Job updateJob = null;

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        IWorkbenchHelpSystem whs = PlatformUI.getWorkbench().getHelpSystem();
        whs.setHelp((Control)parent, "org.eclipse.wst.server.ui.spge0000");
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(784);
        composite.setLayoutData((Object)data);
        this.showOnActivity = new Button(composite, 32);
        this.showOnActivity.setText(Messages.prefShowOnActivity);
        data = new GridData(256);
        data.horizontalSpan = 3;
        this.showOnActivity.setLayoutData((Object)data);
        this.showOnActivity.setSelection(this.uiPreferences.getShowOnActivity());
        whs.setHelp((Control)this.showOnActivity, "org.eclipse.wst.server.ui.spge0022");
        Label label = new Label(composite, 0);
        data = new GridData();
        data.horizontalSpan = 3;
        label.setLayoutData((Object)data);
        Group cacheGroup = new Group(composite, 0);
        cacheGroup.setText(Messages.cacheUpdate_boxTitle);
        layout = new GridLayout();
        layout.numColumns = 3;
        cacheGroup.setLayout((Layout)layout);
        data = new GridData(768);
        data.horizontalSpan = 3;
        cacheGroup.setLayoutData((Object)data);
        Label updateCacheLabel = new Label((Composite)cacheGroup, 0);
        updateCacheLabel.setText(Messages.cacheUpdate_frequencyLabel);
        this.updateCacheFrequencyCombo = new Combo((Composite)cacheGroup, 8);
        String[] frequency = new String[]{Messages.cacheFrequency_manual, Messages.cacheFrequency_daily, Messages.cacheFrequency_weekly, Messages.cacheFrequency_monthly, Messages.cacheFrequency_quarterly};
        this.updateCacheFrequencyCombo.setItems(frequency);
        int cacheFrequency = this.uiPreferences.getCacheFrequency();
        this.updateCacheFrequencyCombo.select(cacheFrequency);
        this.refreshNow = new Button((Composite)cacheGroup, 8);
        data = new GridData(128);
        this.refreshNow.setLayoutData((Object)data);
        String refreshButtonText = ServerUIUtil.refreshButtonText;
        ServerUIUtil.setListener(new UpdateJobChangeListener());
        if (refreshButtonText.equals(Messages.cacheUpdate_refreshNow) && ServerUIPlugin.getPreferences().getExtAdapter()) {
            this.refreshNow.setEnabled(true);
        } else {
            this.refreshNow.setEnabled(false);
        }
        this.refreshNow.setText(refreshButtonText);
        this.refreshNow.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServerPreferencePage.this.refreshNow.setEnabled(false);
                ServerPreferencePage.this.updateRefreshText(Messages.cacheUpdate_refreshing);
                ServerPreferencePage.this.updateJob = ServerUIUtil.refreshServerNode(true);
            }
        });
        Label lastUpdatedLabel = new Label((Composite)cacheGroup, 0);
        lastUpdatedLabel.setText(Messages.cacheUpdate_lastUpdatedOn);
        this.updateTime = new Text((Composite)cacheGroup, 8);
        this.updateTime.setText(this.getLastUpdateDate());
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    public void updateRefreshText(String refreshText) {
        this.refreshNow.setText(refreshText);
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        this.showOnActivity.setSelection(this.uiPreferences.getDefaultShowOnActivity());
        this.updateCacheFrequencyCombo.select(2);
        super.performDefaults();
    }

    public boolean performOk() {
        this.uiPreferences.setShowOnActivity(this.showOnActivity.getSelection());
        this.uiPreferences.setCacheFrequency(this.updateCacheFrequencyCombo.getSelectionIndex());
        return true;
    }

    public void dispose() {
        ServerUIUtil.setListener(null);
    }

    public String getLastUpdateDate() {
        String lastUpdatedDate = Discovery.getLastUpdatedDate();
        lastUpdatedDate = lastUpdatedDate.trim();
        SimpleDateFormat format = new SimpleDateFormat(CACHE_LAST_UPDATED_DATE_FORMAT, Locale.ENGLISH);
        try {
            int value;
            Date oldDate = format.parse(lastUpdatedDate);
            Date now = new Date();
            long diffInMillies = now.getTime() - oldDate.getTime();
            long msPerMinute = 60000L;
            long msPerHour = msPerMinute * 60L;
            long msPerDay = msPerHour * 24L;
            long msPerWeek = msPerDay * 7L;
            long msPerMonth = msPerDay * 30L;
            long msPerYear = msPerDay * 365L;
            lastUpdatedDate = diffInMillies < msPerMinute ? ((value = (int)diffInMillies / 1000) > 1 ? NLS.bind((String)Messages.secondsAgo, (Object)value) : Messages.secondAgo) : (diffInMillies < msPerHour ? ((value = (int)(diffInMillies / msPerMinute)) > 1 ? NLS.bind((String)Messages.minutesAgo, (Object)value) : Messages.minuteAgo) : (diffInMillies < msPerDay ? ((value = (int)(diffInMillies / msPerHour)) > 1 ? NLS.bind((String)Messages.hoursAgo, (Object)value) : Messages.hourAgo) : (diffInMillies < msPerWeek ? ((value = (int)(diffInMillies / msPerDay)) > 1 ? NLS.bind((String)Messages.daysAgo, (Object)value) : Messages.dayAgo) : (diffInMillies < msPerMonth ? ((value = (int)(diffInMillies / msPerWeek)) > 1 ? NLS.bind((String)Messages.weeksAgo, (Object)value) : Messages.weekAgo) : (diffInMillies < msPerYear ? ((value = (int)(diffInMillies / msPerMonth)) > 1 ? NLS.bind((String)Messages.monthsAgo, (Object)value) : Messages.monthAgo) : ((value = (int)(diffInMillies / msPerYear)) > 1 ? NLS.bind((String)Messages.yearsAgo, (Object)value) : Messages.yearAgo))))));
        }
        catch (ParseException parseException) {}
        return lastUpdatedDate;
    }

    private class UpdateJobChangeListener
    implements ICacheUpdateListener {
        public void start() {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (((UpdateJobChangeListener)UpdateJobChangeListener.this).ServerPreferencePage.this.refreshNow != null && !((UpdateJobChangeListener)UpdateJobChangeListener.this).ServerPreferencePage.this.refreshNow.isDisposed()) {
                        ((UpdateJobChangeListener)UpdateJobChangeListener.this).ServerPreferencePage.this.refreshNow.setText(Messages.cacheUpdate_refreshing);
                        ((UpdateJobChangeListener)UpdateJobChangeListener.this).ServerPreferencePage.this.refreshNow.setEnabled(false);
                    }
                }
            });
        }

        public void done() {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (((UpdateJobChangeListener)UpdateJobChangeListener.this).ServerPreferencePage.this.refreshNow != null && !((UpdateJobChangeListener)UpdateJobChangeListener.this).ServerPreferencePage.this.refreshNow.isDisposed()) {
                        ((UpdateJobChangeListener)UpdateJobChangeListener.this).ServerPreferencePage.this.refreshNow.setEnabled(true);
                        ((UpdateJobChangeListener)UpdateJobChangeListener.this).ServerPreferencePage.this.refreshNow.setText(Messages.cacheUpdate_refreshNow);
                        ((UpdateJobChangeListener)UpdateJobChangeListener.this).ServerPreferencePage.this.updateTime.setText(ServerPreferencePage.this.getLastUpdateDate());
                    }
                }
            });
        }
    }
}

