/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.ui.views.contentoutline;

import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleDeclItem;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSValue;
import org.eclipse.wst.css.ui.internal.CSSUIPlugin;
import org.eclipse.wst.css.ui.views.contentoutline.JFaceNodeContentProviderCSS;
import org.eclipse.wst.css.ui.views.contentoutline.JFaceNodeLabelProviderCSS;
import org.eclipse.wst.css.ui.views.contentoutline.SortAction;
import org.eclipse.wst.sse.ui.internal.contentoutline.PropertyChangeUpdateAction;
import org.eclipse.wst.sse.ui.internal.contentoutline.PropertyChangeUpdateActionContributionItem;
import org.eclipse.wst.sse.ui.views.contentoutline.ContentOutlineConfiguration;

public class CSSContentOutlineConfiguration
extends ContentOutlineConfiguration {
    private IContentProvider fContentProvider = null;
    private ILabelProvider fLabelProvider = null;
    private final String OUTLINE_SORT_PREF = "outline-sort";
    private static final String OUTLINE_FILTER_PREF = "org.eclipse.wst.css.ui.OutlinePage";

    public IContributionItem[] createToolbarContributions(TreeViewer viewer) {
        IContributionItem[] items = super.createToolbarContributions(viewer);
        SortAction sortAction = new SortAction(viewer, CSSUIPlugin.getDefault().getPreferenceStore(), "outline-sort");
        PropertyChangeUpdateActionContributionItem sortItem = new PropertyChangeUpdateActionContributionItem((PropertyChangeUpdateAction)sortAction);
        if (items == null) {
            items = new IContributionItem[]{sortItem};
        } else {
            IContributionItem[] combinedItems = new IContributionItem[items.length + 1];
            combinedItems[0] = sortItem;
            System.arraycopy(items, 0, combinedItems, 1, items.length);
            items = combinedItems;
        }
        return items;
    }

    public IContentProvider getContentProvider(TreeViewer viewer) {
        if (this.fContentProvider == null) {
            this.fContentProvider = new JFaceNodeContentProviderCSS();
        }
        return this.fContentProvider;
    }

    private Object getFilteredNode(Object o) {
        ICSSNode node = null;
        if (o instanceof ICSSNode) {
            node = (ICSSNode)o;
            short nodeType = node.getNodeType();
            if (node instanceof ICSSValue) {
                while (node != null && !(node instanceof ICSSStyleDeclItem)) {
                    node = node.getParentNode();
                }
            } else if (nodeType == 8) {
                node = node.getParentNode();
            } else if (nodeType == 12) {
                node = node.getParentNode();
            }
        }
        return node;
    }

    private Object[] getFilteredNodes(Object[] objects) {
        Object[] filtered = new Object[objects.length];
        int i = 0;
        while (i < filtered.length) {
            filtered[i] = this.getFilteredNode(objects[i]);
            ++i;
        }
        return filtered;
    }

    public ILabelProvider getLabelProvider(TreeViewer viewer) {
        if (this.fLabelProvider == null) {
            this.fLabelProvider = new JFaceNodeLabelProviderCSS();
        }
        return this.fLabelProvider;
    }

    protected IPreferenceStore getPreferenceStore() {
        return CSSUIPlugin.getDefault().getPreferenceStore();
    }

    public ISelection getSelection(TreeViewer viewer, ISelection selection) {
        ISelection filteredSelection = selection;
        if (selection instanceof IStructuredSelection) {
            Object[] filteredNodes = this.getFilteredNodes(((IStructuredSelection)selection).toArray());
            filteredSelection = new StructuredSelection(filteredNodes);
        }
        return filteredSelection;
    }

    protected String getOutlineFilterTarget() {
        return OUTLINE_FILTER_PREF;
    }
}

