/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.json.impl.schema;

import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import org.eclipse.json.IValidationReporter;
import org.eclipse.json.impl.schema.JSONSchemaNode;
import org.eclipse.json.jsonpath.IJSONPath;
import org.eclipse.json.provisonnal.com.eclipsesource.json.JsonObject;
import org.eclipse.json.provisonnal.com.eclipsesource.json.JsonValue;
import org.eclipse.json.schema.IJSONSchemaDocument;
import org.eclipse.json.schema.IJSONSchemaProperty;

public class JSONSchemaDocument
extends JSONSchemaNode
implements IJSONSchemaDocument {
    public JSONSchemaDocument(Reader reader) throws IOException {
        super(JsonObject.readFrom(reader), null);
    }

    @Override
    public IJSONSchemaProperty getProperty(IJSONPath path) {
        if (path == null || path.getSegments() == null || path.getSegments().length <= 0) {
            return this;
        }
        String[] segments = path.getSegments();
        String segment = segments[0];
        if (segment == null) {
            return null;
        }
        IJSONSchemaProperty property = this.getProperties().get(segment);
        if (property != null) {
            return this.getProperty(property, segments, 1);
        }
        return null;
    }

    private IJSONSchemaProperty getProperty(IJSONSchemaProperty node, String[] segments, int level) {
        if (segments.length < level + 1) {
            return node;
        }
        String segment = segments[level];
        Collection<IJSONSchemaProperty> props = node.getProperties().values();
        for (IJSONSchemaProperty property : props) {
            if (!segment.equals(property.getName())) continue;
            return this.getProperty(property, segments, level + 1);
        }
        return null;
    }

    public void validate(JsonValue value, IValidationReporter reporter) {
    }

    @Override
    public String getName() {
        return "";
    }
}

