/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.details;

import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.iterable.SuperListIterableWrapper;
import org.eclipse.jpt.common.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.ListPropertyValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.ReadOnlyModifiablePropertyValueModelWrapper;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.ValueListAdapter;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.common.utility.model.event.StateChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.StateChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.StateChangeListener;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.JoinTable;
import org.eclipse.jpt.jpa.core.context.SpecifiedBaseJoinColumn;
import org.eclipse.jpt.jpa.core.context.SpecifiedJoinColumn;
import org.eclipse.jpt.jpa.core.context.SpecifiedJoinTable;
import org.eclipse.jpt.jpa.ui.details.JptJpaUiDetailsMessages;
import org.eclipse.jpt.jpa.ui.internal.JpaHelpContextIds;
import org.eclipse.jpt.jpa.ui.internal.details.InverseJoinColumnInJoinTableDialog;
import org.eclipse.jpt.jpa.ui.internal.details.InverseJoinColumnInJoinTableStateObject;
import org.eclipse.jpt.jpa.ui.internal.details.JoinColumnsComposite;
import org.eclipse.jpt.jpa.ui.internal.details.ReferenceTableComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

public class JoinTableComposite
extends ReferenceTableComposite<JoinTable> {
    private Button overrideDefaultInverseJoinColumnsCheckBox;
    private JoinColumnsComposite<JoinTable> inverseJoinColumnsComposite;

    public JoinTableComposite(Pane<?> parentPane, PropertyValueModel<? extends JoinTable> tableModel, PropertyValueModel<Boolean> enabledModel, Composite parentComposite) {
        super(parentPane, tableModel, enabledModel, parentComposite);
    }

    @Override
    protected boolean tableIsVirtual(JoinTable joinTable) {
        return joinTable.getParent().getRelationship().isVirtual();
    }

    protected Composite addComposite(Composite container) {
        return this.addSubPane(container, 2, 0, 0, 0, 0);
    }

    protected void initializeLayout(Composite container) {
        this.addLabel(container, JptJpaUiDetailsMessages.JOIN_TABLE_COMPOSITE_NAME);
        this.addTableCombo(container, JpaHelpContextIds.MAPPING_JOIN_TABLE_NAME);
        this.addLabel(container, JptJpaUiDetailsMessages.JOIN_TABLE_COMPOSITE_SCHEMA);
        this.addSchemaCombo(container, JpaHelpContextIds.MAPPING_JOIN_TABLE_SCHEMA);
        this.addLabel(container, JptJpaUiDetailsMessages.JOIN_TABLE_COMPOSITE_CATALOG);
        this.addCatalogCombo(container, JpaHelpContextIds.MAPPING_JOIN_TABLE_CATALOG);
        Group joinColumnGroupPane = this.addTitledGroup(container, JptJpaUiDetailsMessages.JOIN_TABLE_COMPOSITE_JOIN_COLUMN);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        joinColumnGroupPane.setLayoutData((Object)gridData);
        this.overrideDefaultJoinColumnsCheckBox = this.addCheckBox((Composite)joinColumnGroupPane, JptJpaUiDetailsMessages.JOIN_TABLE_COMPOSITE_OVERRIDE_DEFAULT_JOIN_COLUMNS, this.buildOverrideDefaultJoinColumnHolder(), null);
        this.joinColumnsComposite = new JoinColumnsComposite<JoinTable>(this, (Composite)joinColumnGroupPane, this.buildJoinColumnsEditor(), this.buildJoinColumnsEnabledModel());
        Group inverseJoinColumnGroupPane = this.addTitledGroup(container, JptJpaUiDetailsMessages.JOIN_TABLE_COMPOSITE_INVERSE_JOIN_COLUMN);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        inverseJoinColumnGroupPane.setLayoutData((Object)gridData);
        this.overrideDefaultInverseJoinColumnsCheckBox = this.addCheckBox((Composite)inverseJoinColumnGroupPane, JptJpaUiDetailsMessages.JOIN_TABLE_COMPOSITE_OVERRIDE_DEFAULT_INVERSE_JOIN_COLUMNS, this.buildOverrideDefaultInverseJoinColumnHolder(), null);
        this.inverseJoinColumnsComposite = new JoinColumnsComposite<JoinTable>(this, (Composite)inverseJoinColumnGroupPane, this.buildInverseJoinColumnsEditor(), (PropertyValueModel<Boolean>)new InverseJoinColumnPaneEnablerHolder());
    }

    SpecifiedJoinColumn addInverseJoinColumn(JoinTable joinTable) {
        InverseJoinColumnInJoinTableDialog dialog = new InverseJoinColumnInJoinTableDialog(this.getShell(), this.getResourceManager(), joinTable);
        dialog.setBlockOnOpen(true);
        dialog.open();
        if (dialog.wasConfirmed()) {
            return this.addInverseJoinColumnFromDialog((InverseJoinColumnInJoinTableStateObject)dialog.getSubject());
        }
        return null;
    }

    SpecifiedJoinColumn addInverseJoinColumnFromDialog(InverseJoinColumnInJoinTableStateObject stateObject) {
        SpecifiedJoinTable subject = (SpecifiedJoinTable)this.getSubject();
        int index = subject.getSpecifiedInverseJoinColumnsSize();
        SpecifiedJoinColumn joinColumn = subject.addSpecifiedInverseJoinColumn(index);
        stateObject.updateJoinColumn((SpecifiedBaseJoinColumn)joinColumn);
        return joinColumn;
    }

    private void setSelectedInverseJoinColumn(SpecifiedJoinColumn joinColumn) {
        this.inverseJoinColumnsComposite.setSelectedJoinColumn(joinColumn);
    }

    private InverseJoinColumnsProvider buildInverseJoinColumnsEditor() {
        return new InverseJoinColumnsProvider();
    }

    private ModifiablePropertyValueModel<Boolean> buildOverrideDefaultInverseJoinColumnHolder() {
        return new OverrideDefaultInverseJoinColumnHolder();
    }

    ListValueModel<JoinColumn> buildSpecifiedInverseJoinColumnsListHolder() {
        return new ListAspectAdapter<JoinTable, JoinColumn>(this.getSubjectHolder(), new String[]{"specifiedInverseJoinColumns"}){

            protected ListIterable<JoinColumn> getListIterable() {
                return new SuperListIterableWrapper(((JoinTable)this.subject).getSpecifiedInverseJoinColumns());
            }

            protected int size_() {
                return ((JoinTable)this.subject).getSpecifiedInverseJoinColumnsSize();
            }
        };
    }

    void editInverseJoinColumn(InverseJoinColumnInJoinTableStateObject stateObject) {
        stateObject.updateJoinColumn((SpecifiedBaseJoinColumn)stateObject.getJoinColumn());
    }

    void editInverseJoinColumn(JoinColumn joinColumn) {
        InverseJoinColumnInJoinTableDialog dialog = new InverseJoinColumnInJoinTableDialog(this.getShell(), this.getResourceManager(), (JoinTable)this.getSubject(), joinColumn);
        dialog.setBlockOnOpen(true);
        dialog.open();
        if (dialog.wasConfirmed()) {
            this.editInverseJoinColumn((InverseJoinColumnInJoinTableStateObject)dialog.getSubject());
        }
    }

    void updateInverseJoinColumns() {
        if (this.isPopulating()) {
            return;
        }
        SpecifiedJoinTable joinTable = (SpecifiedJoinTable)this.getSubject();
        if (joinTable == null) {
            return;
        }
        boolean selected = this.overrideDefaultInverseJoinColumnsCheckBox.getSelection();
        this.setPopulating(true);
        try {
            if (selected) {
                joinTable.convertDefaultInverseJoinColumnToSpecified();
                this.setSelectedInverseJoinColumn(joinTable.getSpecifiedInverseJoinColumn(0));
            } else {
                joinTable.clearSpecifiedInverseJoinColumns();
            }
        }
        finally {
            this.setPopulating(false);
        }
    }

    private class InverseJoinColumnPaneEnablerHolder
    extends TransformationPropertyValueModel<JoinTable, Boolean> {
        private StateChangeListener stateListener;

        public InverseJoinColumnPaneEnablerHolder() {
            super((PropertyValueModel)new ValueListAdapter((ModifiablePropertyValueModel)new ReadOnlyModifiablePropertyValueModelWrapper(JoinTableComposite.this.getSubjectHolder()), new String[]{"specifiedInverseJoinColumns"}));
            this.stateListener = new StateListener();
        }

        void wrappedValueStateChanged() {
            Object old = this.value;
            this.value = this.transform((JoinTable)this.valueModel.getValue());
            this.firePropertyChanged("value", old, this.value);
        }

        protected Boolean transform(JoinTable table) {
            return table == null ? Boolean.FALSE : (Boolean)super.transform((Object)table);
        }

        protected Boolean transform_(JoinTable table) {
            boolean virtual = JoinTableComposite.this.tableIsVirtual(table);
            return !virtual && table.getSpecifiedInverseJoinColumnsSize() > 0;
        }

        protected void engageModel() {
            super.engageModel();
            this.valueModel.addStateChangeListener(this.stateListener);
        }

        protected void disengageModel() {
            this.valueModel.removeStateChangeListener(this.stateListener);
            super.disengageModel();
        }

        class StateListener
        extends StateChangeAdapter {
            StateListener() {
            }

            public void stateChanged(StateChangeEvent event) {
                InverseJoinColumnPaneEnablerHolder.this.wrappedValueStateChanged();
            }
        }
    }

    class InverseJoinColumnsProvider
    implements JoinColumnsComposite.JoinColumnsEditor<JoinTable> {
        InverseJoinColumnsProvider() {
        }

        @Override
        public SpecifiedJoinColumn addJoinColumn(JoinTable subject) {
            return JoinTableComposite.this.addInverseJoinColumn(subject);
        }

        @Override
        public JoinColumn getDefaultJoinColumn(JoinTable subject) {
            return subject.getDefaultInverseJoinColumn();
        }

        @Override
        public String getDefaultPropertyName() {
            return "defaultInverseJoinColumn";
        }

        @Override
        public void editJoinColumn(JoinTable subject, JoinColumn joinColumn) {
            JoinTableComposite.this.editInverseJoinColumn(joinColumn);
        }

        @Override
        public boolean hasSpecifiedJoinColumns(JoinTable subject) {
            return subject.hasSpecifiedInverseJoinColumns();
        }

        @Override
        public void removeJoinColumn(JoinTable subject, SpecifiedJoinColumn joinColumn) {
            ((SpecifiedJoinTable)subject).removeSpecifiedInverseJoinColumn(joinColumn);
        }

        @Override
        public ListIterable<JoinColumn> getSpecifiedJoinColumns(JoinTable subject) {
            return new SuperListIterableWrapper(subject.getSpecifiedInverseJoinColumns());
        }

        @Override
        public int getSpecifiedJoinColumnsSize(JoinTable subject) {
            return subject.getSpecifiedInverseJoinColumnsSize();
        }

        @Override
        public String getSpecifiedJoinColumnsListPropertyName() {
            return "specifiedInverseJoinColumns";
        }
    }

    private class OverrideDefaultInverseJoinColumnHolder
    extends ListPropertyValueModelAdapter<Boolean>
    implements ModifiablePropertyValueModel<Boolean> {
        public OverrideDefaultInverseJoinColumnHolder() {
            super(JoinTableComposite.this.buildSpecifiedInverseJoinColumnsListHolder());
        }

        protected Boolean buildValue() {
            return this.listModel.size() > 0;
        }

        public void setValue(Boolean value) {
            JoinTableComposite.this.updateInverseJoinColumns();
        }
    }
}

