/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.xml.namespace.QName;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcessVisitor;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.ErrorList;
import org.eclipse.wst.wsi.internal.core.util.NullUtil;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversal;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversalContext;

public class BP2104
extends AssertionProcessVisitor
implements WSITag {
    private final WSDLValidatorImpl validator;
    private ErrorList errors = new ErrorList();
    private boolean importFound = false;

    public BP2104(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    @Override
    public void visit(Import im, Object parent, WSDLTraversalContext ctx) {
        this.importFound = true;
        Definition def = im.getDefinition();
        if (def != null && !NullUtil.equals(im.getNamespaceURI(), def.getTargetNamespace())) {
            this.errors.add(new QName(im.getNamespaceURI(), im.getLocationURI()), new QName(def.getTargetNamespace(), def.getDocumentBaseURI()));
        }
    }

    @Override
    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "failed";
        WSDLTraversal traversal = new WSDLTraversal();
        traversal.setVisitor(this);
        traversal.visitImport(true);
        traversal.ignoreReferences();
        traversal.traverse((Definition)entryContext.getEntry().getEntryDetail());
        if (!this.errors.isEmpty()) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(this.errors.toString(), entryContext);
        } else {
            this.result = !this.importFound ? "notApplicable" : "passed";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

