/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.tests.model;

import junit.framework.TestCase;
import org.eclipse.wst.css.core.internal.provisional.adapters.ICSSModelAdapter;
import org.eclipse.wst.html.core.internal.htmlcss.StyleAdapterFactory;
import org.eclipse.wst.html.core.tests.utils.FileUtil;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TestCSS
extends TestCase {
    private static final String MARKUP = "<html><head></head><body></body></html>";

    public void testStyleElementAdapter() {
        IDOMModel model = FileUtil.createHTMLModel();
        try {
            IStructuredDocument structuredDocument = model.getStructuredDocument();
            structuredDocument.set(MARKUP);
            IDOMDocument doc = model.getDocument();
            NodeList list = doc.getElementsByTagName("HEAD");
            Element head = (Element)list.item(0);
            Element ele = doc.createElement("STYLE");
            ele.setAttribute("type", "text/css");
            head.appendChild(ele);
            INodeAdapter adapter = StyleAdapterFactory.getInstance().adapt((INodeNotifier)((IDOMNode)ele));
            TestCSS.assertNotNull((String)("No adapter on " + ele), (Object)adapter);
            TestCSS.assertTrue((String)"Adapter is not an ICSSModelAdapter", (boolean)(adapter instanceof ICSSModelAdapter));
            ICSSModelAdapter modelAdapter = (ICSSModelAdapter)adapter;
            TestCSS.assertNotNull((String)"There should be a CSS model for the node", (Object)modelAdapter.getModel());
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testTypeFooBarStyleElementAdapter() {
        IDOMModel model = FileUtil.createHTMLModel();
        try {
            IStructuredDocument structuredDocument = model.getStructuredDocument();
            structuredDocument.set(MARKUP);
            IDOMDocument doc = model.getDocument();
            NodeList list = doc.getElementsByTagName("HEAD");
            Element head = (Element)list.item(0);
            Element ele = doc.createElement("STYLE");
            ele.setAttribute("type", "foo/bar");
            head.appendChild(ele);
            INodeAdapter adapter = StyleAdapterFactory.getInstance().adapt((INodeNotifier)((IDOMNode)ele));
            TestCSS.assertNotNull((String)("No adapter on " + ele), (Object)adapter);
            TestCSS.assertTrue((String)"Adapter is not an ICSSModelAdapter", (boolean)(adapter instanceof ICSSModelAdapter));
            ICSSModelAdapter modelAdapter = (ICSSModelAdapter)adapter;
            TestCSS.assertNull((String)"There should be no CSS model for the node", (Object)modelAdapter.getModel());
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }
}

