/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.wip.tools.protocolgenerator;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException;
import org.eclipse.wst.jsdt.chromium.internal.wip.tools.protocolgenerator.Generator;
import org.eclipse.wst.jsdt.chromium.internal.wip.tools.protocolgenerator.WipMetamodel;
import org.eclipse.wst.jsdt.chromium.internal.wip.tools.protocolgenerator.WipMetamodelParser;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class WipProtocolGeneratorMain {
    private static final ModelResourceLocation JSON_MODEL_FILE_URL = new LocalFileLocation("Inspector-1.0.json.r107603.manual_fix");

    public static void main(String[] args) {
        WipMetamodel.Root metamodel;
        Object jsonValue;
        JsonModelData jsonModelData;
        Params params = WipProtocolGeneratorMain.parseParams(args);
        try {
            jsonModelData = WipProtocolGeneratorMain.loadJsonModelText(JSON_MODEL_FILE_URL);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load JSON", e);
        }
        try {
            jsonValue = new JSONParser().parse(jsonModelData.getJsonText());
        }
        catch (ParseException e) {
            throw new RuntimeException("Failed to parse json", e);
        }
        WipMetamodelParser metaModelParser = WipMetamodelParser.Impl.get();
        try {
            metamodel = metaModelParser.parseRoot(jsonValue);
        }
        catch (JsonProtocolParseException e) {
            throw new RuntimeException("Failed to parse metamodel", e);
        }
        Generator generator = new Generator(params.getOutputDir(), jsonModelData.getOriginReference());
        try {
            generator.go(metamodel);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static JsonModelData loadJsonModelText(ModelResourceLocation location) throws IOException {
        int res;
        StringBuilder result = new StringBuilder();
        ModelResourceLocation.Connected connection = location.connect();
        final String originReference = connection.getResourceDescription();
        InputStream stream = connection.getContent();
        InputStreamReader reader = new InputStreamReader(stream, "UTF-8");
        char[] buffer = new char[1024];
        while ((res = reader.read(buffer)) != -1) {
            result.append(buffer, 0, res);
        }
        ((Reader)reader).close();
        stream.close();
        final String resultString = result.toString();
        return new JsonModelData(){

            @Override
            public String getOriginReference() {
                return originReference;
            }

            @Override
            public String getJsonText() {
                return resultString;
            }
        };
    }

    private static Params parseParams(String[] args) {
        if (args.length != 1) {
            throw new IllegalArgumentException("One argument <dest dir> expected");
        }
        final String outputDir = args[0];
        return new Params(){

            @Override
            public String getOutputDir() {
                return outputDir;
            }
        };
    }

    private static interface JsonModelData {
        public String getJsonText();

        public String getOriginReference();
    }

    private static class LocalFileLocation
    implements ModelResourceLocation {
        private final String fileName;

        LocalFileLocation(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public ModelResourceLocation.Connected connect() throws IOException {
            return new ModelResourceLocation.Connected(){

                @Override
                public String getResourceDescription() {
                    return "Local file " + LocalFileLocation.this.fileName;
                }

                @Override
                public InputStream getContent() throws IOException {
                    File file = new File(LocalFileLocation.this.fileName);
                    return new FileInputStream(file);
                }
            };
        }
    }

    private static interface ModelResourceLocation {
        public Connected connect() throws IOException;

        public static interface Connected {
            public String getResourceDescription();

            public InputStream getContent() throws IOException;
        }
    }

    private static interface Params {
        public String getOutputDir();
    }

    private static class RemoteSvnLocation
    implements ModelResourceLocation {
        private final URL url;
        private static final Pattern REVISION_PATTERN = Pattern.compile("^\"([\\d]+)//");

        RemoteSvnLocation(String urlSpec) {
            try {
                this.url = new URL(urlSpec);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public ModelResourceLocation.Connected connect() throws IOException {
            final URLConnection connection = this.url.openConnection();
            return new ModelResourceLocation.Connected(){

                @Override
                public String getResourceDescription() {
                    return RemoteSvnLocation.buildOriginReference(RemoteSvnLocation.this.url.toExternalForm(), connection);
                }

                @Override
                public InputStream getContent() throws IOException {
                    return connection.getInputStream();
                }
            };
        }

        private static String buildOriginReference(String url, URLConnection connection) {
            Matcher matcher;
            String revision = "<unknown>";
            String eTag = connection.getHeaderField("ETag");
            if (eTag != null && (matcher = REVISION_PATTERN.matcher(eTag)).find()) {
                revision = matcher.group(1);
            }
            return String.valueOf(url) + "@" + revision;
        }
    }
}

