/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.util.ArrayList;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptElementDelta;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.SimpleDelta;

public class JavaElementDelta
extends SimpleDelta
implements IJavaScriptElementDelta {
    protected IJavaScriptElementDelta[] affectedChildren = EMPTY_DELTA;
    protected JavaScriptUnit ast = null;
    protected IJavaScriptElement changedElement;
    protected IResourceDelta[] resourceDeltas = null;
    protected int resourceDeltasCounter;
    protected IJavaScriptElement movedFromHandle = null;
    protected IJavaScriptElement movedToHandle = null;
    protected static IJavaScriptElementDelta[] EMPTY_DELTA = new IJavaScriptElementDelta[0];

    public JavaElementDelta(IJavaScriptElement element) {
        this.changedElement = element;
    }

    protected void addAffectedChild(JavaElementDelta child) {
        switch (this.kind) {
            case 1: 
            case 2: {
                return;
            }
            case 4: {
                this.changeFlags |= 8;
                break;
            }
            default: {
                this.kind = 4;
                this.changeFlags |= 8;
            }
        }
        if (this.changedElement.getElementType() >= 5) {
            this.fineGrained();
        }
        if (this.affectedChildren.length == 0) {
            this.affectedChildren = new IJavaScriptElementDelta[]{child};
            return;
        }
        SimpleDelta existingChild = null;
        int existingChildIndex = -1;
        if (this.affectedChildren != null) {
            int i = 0;
            while (i < this.affectedChildren.length) {
                if (this.equalsAndSameParent(this.affectedChildren[i].getElement(), child.getElement())) {
                    existingChild = (JavaElementDelta)this.affectedChildren[i];
                    existingChildIndex = i;
                    break;
                }
                ++i;
            }
        }
        if (existingChild == null) {
            this.affectedChildren = this.growAndAddToArray(this.affectedChildren, child);
        } else {
            switch (existingChild.getKind()) {
                case 1: {
                    switch (child.getKind()) {
                        case 1: 
                        case 4: {
                            return;
                        }
                        case 2: {
                            this.affectedChildren = this.removeAndShrinkArray(this.affectedChildren, existingChildIndex);
                            return;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (child.getKind()) {
                        case 1: {
                            child.kind = 4;
                            this.affectedChildren[existingChildIndex] = child;
                            return;
                        }
                        case 2: 
                        case 4: {
                            return;
                        }
                    }
                    break;
                }
                case 4: {
                    switch (child.getKind()) {
                        case 1: 
                        case 2: {
                            this.affectedChildren[existingChildIndex] = child;
                            return;
                        }
                        case 4: {
                            IResourceDelta[] resDeltas;
                            IJavaScriptElementDelta[] children = child.getAffectedChildren();
                            int i = 0;
                            while (i < children.length) {
                                JavaElementDelta childsChild = (JavaElementDelta)children[i];
                                ((JavaElementDelta)existingChild).addAffectedChild(childsChild);
                                ++i;
                            }
                            boolean childHadContentFlag = (child.changeFlags & 1) != 0;
                            boolean existingChildHadChildrenFlag = (((JavaElementDelta)existingChild).changeFlags & 8) != 0;
                            ((JavaElementDelta)existingChild).changeFlags |= child.changeFlags;
                            if (childHadContentFlag && existingChildHadChildrenFlag) {
                                ((JavaElementDelta)existingChild).changeFlags &= 0xFFFFFFFE;
                            }
                            if ((resDeltas = child.getResourceDeltas()) != null) {
                                ((JavaElementDelta)existingChild).resourceDeltas = resDeltas;
                                ((JavaElementDelta)existingChild).resourceDeltasCounter = child.resourceDeltasCounter;
                            }
                            return;
                        }
                    }
                    break;
                }
                default: {
                    int flags = existingChild.getFlags();
                    this.affectedChildren[existingChildIndex] = child;
                    child.changeFlags |= flags;
                }
            }
        }
    }

    public void added(IJavaScriptElement element) {
        this.added(element, 0);
    }

    public void added(IJavaScriptElement element, int flags) {
        JavaElementDelta addedDelta = new JavaElementDelta(element);
        addedDelta.added();
        addedDelta.changeFlags |= flags;
        this.insertDeltaTree(element, addedDelta);
    }

    protected void addResourceDelta(IResourceDelta child) {
        switch (this.kind) {
            case 1: 
            case 2: {
                return;
            }
            case 4: {
                this.changeFlags |= 1;
                break;
            }
            default: {
                this.kind = 4;
                this.changeFlags |= 1;
            }
        }
        if (this.resourceDeltas == null) {
            this.resourceDeltas = new IResourceDelta[5];
            this.resourceDeltas[this.resourceDeltasCounter++] = child;
            return;
        }
        if (this.resourceDeltas.length == this.resourceDeltasCounter) {
            this.resourceDeltas = new IResourceDelta[this.resourceDeltasCounter * 2];
            System.arraycopy(this.resourceDeltas, 0, this.resourceDeltas, 0, this.resourceDeltasCounter);
        }
        this.resourceDeltas[this.resourceDeltasCounter++] = child;
    }

    public JavaElementDelta changed(IJavaScriptElement element, int changeFlag) {
        JavaElementDelta changedDelta = new JavaElementDelta(element);
        changedDelta.changed(changeFlag);
        this.insertDeltaTree(element, changedDelta);
        return changedDelta;
    }

    public void changedAST(JavaScriptUnit changedAST) {
        this.ast = changedAST;
        this.changed(524288);
    }

    public void contentChanged() {
        this.changeFlags |= 1;
    }

    public void closed(IJavaScriptElement element) {
        JavaElementDelta delta = new JavaElementDelta(element);
        delta.changed(1024);
        this.insertDeltaTree(element, delta);
    }

    protected JavaElementDelta createDeltaTree(IJavaScriptElement element, JavaElementDelta delta) {
        JavaElementDelta childDelta = delta;
        ArrayList ancestors = this.getAncestors(element);
        if (ancestors == null) {
            if (this.equalsAndSameParent(delta.getElement(), this.getElement())) {
                this.kind = delta.kind;
                this.changeFlags = delta.changeFlags;
                this.movedToHandle = delta.movedToHandle;
                this.movedFromHandle = delta.movedFromHandle;
            }
        } else {
            int i = 0;
            int size = ancestors.size();
            while (i < size) {
                IJavaScriptElement ancestor = (IJavaScriptElement)ancestors.get(i);
                JavaElementDelta ancestorDelta = new JavaElementDelta(ancestor);
                ancestorDelta.addAffectedChild(childDelta);
                childDelta = ancestorDelta;
                ++i;
            }
        }
        return childDelta;
    }

    protected boolean equalsAndSameParent(IJavaScriptElement e1, IJavaScriptElement e2) {
        IJavaScriptElement parent1;
        return e1.equals(e2) && (parent1 = e1.getParent()) != null && parent1.equals(e2.getParent());
    }

    protected JavaElementDelta find(IJavaScriptElement e) {
        if (this.equalsAndSameParent(this.changedElement, e)) {
            return this;
        }
        int i = 0;
        while (i < this.affectedChildren.length) {
            JavaElementDelta delta = ((JavaElementDelta)this.affectedChildren[i]).find(e);
            if (delta != null) {
                return delta;
            }
            ++i;
        }
        return null;
    }

    public void fineGrained() {
        this.changed(16384);
    }

    @Override
    public IJavaScriptElementDelta[] getAddedChildren() {
        return this.getChildrenOfType(1);
    }

    @Override
    public IJavaScriptElementDelta[] getAffectedChildren() {
        return this.affectedChildren;
    }

    private ArrayList getAncestors(IJavaScriptElement element) {
        IJavaScriptElement parent = element.getParent();
        if (parent == null) {
            return null;
        }
        ArrayList<IJavaScriptElement> parents = new ArrayList<IJavaScriptElement>();
        while (!parent.equals(this.changedElement)) {
            parents.add(parent);
            parent = parent.getParent();
            if (parent != null) continue;
            return null;
        }
        parents.trimToSize();
        return parents;
    }

    @Override
    public JavaScriptUnit getJavaScriptUnitAST() {
        return this.ast;
    }

    @Override
    public IJavaScriptElementDelta[] getChangedChildren() {
        return this.getChildrenOfType(4);
    }

    protected IJavaScriptElementDelta[] getChildrenOfType(int type) {
        int length = this.affectedChildren.length;
        if (length == 0) {
            return new IJavaScriptElementDelta[0];
        }
        ArrayList<IJavaScriptElementDelta> children = new ArrayList<IJavaScriptElementDelta>(length);
        int i = 0;
        while (i < length) {
            if (this.affectedChildren[i].getKind() == type) {
                children.add(this.affectedChildren[i]);
            }
            ++i;
        }
        IJavaScriptElementDelta[] childrenOfType = new IJavaScriptElementDelta[children.size()];
        children.toArray(childrenOfType);
        return childrenOfType;
    }

    protected JavaElementDelta getDeltaFor(IJavaScriptElement element) {
        if (this.equalsAndSameParent(this.getElement(), element)) {
            return this;
        }
        if (this.affectedChildren.length == 0) {
            return null;
        }
        int childrenCount = this.affectedChildren.length;
        int i = 0;
        while (i < childrenCount) {
            JavaElementDelta delta = (JavaElementDelta)this.affectedChildren[i];
            if (this.equalsAndSameParent(delta.getElement(), element)) {
                return delta;
            }
            if ((delta = delta.getDeltaFor(element)) != null) {
                return delta;
            }
            ++i;
        }
        return null;
    }

    @Override
    public IJavaScriptElement getElement() {
        return this.changedElement;
    }

    @Override
    public IJavaScriptElement getMovedFromElement() {
        return this.movedFromHandle;
    }

    @Override
    public IJavaScriptElement getMovedToElement() {
        return this.movedToHandle;
    }

    @Override
    public IJavaScriptElementDelta[] getRemovedChildren() {
        return this.getChildrenOfType(2);
    }

    @Override
    public IResourceDelta[] getResourceDeltas() {
        if (this.resourceDeltas == null) {
            return null;
        }
        if (this.resourceDeltas.length != this.resourceDeltasCounter) {
            this.resourceDeltas = new IResourceDelta[this.resourceDeltasCounter];
            System.arraycopy(this.resourceDeltas, 0, this.resourceDeltas, 0, this.resourceDeltasCounter);
        }
        return this.resourceDeltas;
    }

    protected IJavaScriptElementDelta[] growAndAddToArray(IJavaScriptElementDelta[] array, IJavaScriptElementDelta addition) {
        IJavaScriptElementDelta[] old = array;
        array = new IJavaScriptElementDelta[old.length + 1];
        System.arraycopy(old, 0, array, 0, old.length);
        array[old.length] = addition;
        return array;
    }

    protected void insertDeltaTree(IJavaScriptElement element, JavaElementDelta delta) {
        JavaElementDelta childDelta = this.createDeltaTree(element, delta);
        if (!this.equalsAndSameParent(element, this.getElement())) {
            this.addAffectedChild(childDelta);
        }
    }

    public void movedFrom(IJavaScriptElement movedFromElement, IJavaScriptElement movedToElement) {
        JavaElementDelta removedDelta = new JavaElementDelta(movedFromElement);
        removedDelta.kind = 2;
        removedDelta.changeFlags |= 0x20;
        removedDelta.movedToHandle = movedToElement;
        this.insertDeltaTree(movedFromElement, removedDelta);
    }

    public void movedTo(IJavaScriptElement movedToElement, IJavaScriptElement movedFromElement) {
        JavaElementDelta addedDelta = new JavaElementDelta(movedToElement);
        addedDelta.kind = 1;
        addedDelta.changeFlags |= 0x10;
        addedDelta.movedFromHandle = movedFromElement;
        this.insertDeltaTree(movedToElement, addedDelta);
    }

    public void opened(IJavaScriptElement element) {
        JavaElementDelta delta = new JavaElementDelta(element);
        delta.changed(512);
        this.insertDeltaTree(element, delta);
    }

    protected void removeAffectedChild(JavaElementDelta child) {
        int index = -1;
        if (this.affectedChildren != null) {
            int i = 0;
            while (i < this.affectedChildren.length) {
                if (this.equalsAndSameParent(this.affectedChildren[i].getElement(), child.getElement())) {
                    index = i;
                    break;
                }
                ++i;
            }
        }
        if (index >= 0) {
            this.affectedChildren = this.removeAndShrinkArray(this.affectedChildren, index);
        }
    }

    protected IJavaScriptElementDelta[] removeAndShrinkArray(IJavaScriptElementDelta[] old, int index) {
        int rest;
        IJavaScriptElementDelta[] array = new IJavaScriptElementDelta[old.length - 1];
        if (index > 0) {
            System.arraycopy(old, 0, array, 0, index);
        }
        if ((rest = old.length - index - 1) > 0) {
            System.arraycopy(old, index + 1, array, index, rest);
        }
        return array;
    }

    public void removed(IJavaScriptElement element) {
        this.removed(element, 0);
    }

    public void removed(IJavaScriptElement element, int flags) {
        JavaElementDelta removedDelta = new JavaElementDelta(element);
        this.insertDeltaTree(element, removedDelta);
        JavaElementDelta actualDelta = this.getDeltaFor(element);
        if (actualDelta != null) {
            actualDelta.removed();
            actualDelta.changeFlags |= flags;
            actualDelta.affectedChildren = EMPTY_DELTA;
        }
    }

    public void sourceAttached(IJavaScriptElement element) {
        JavaElementDelta attachedDelta = new JavaElementDelta(element);
        attachedDelta.changed(4096);
        this.insertDeltaTree(element, attachedDelta);
    }

    public void sourceDetached(IJavaScriptElement element) {
        JavaElementDelta detachedDelta = new JavaElementDelta(element);
        detachedDelta.changed(8192);
        this.insertDeltaTree(element, detachedDelta);
    }

    public String toDebugString(int depth) {
        int i;
        StringBuffer buffer = new StringBuffer();
        int i2 = 0;
        while (i2 < depth) {
            buffer.append('\t');
            ++i2;
        }
        buffer.append(((JavaElement)this.getElement()).toDebugString());
        this.toDebugString(buffer);
        IJavaScriptElementDelta[] children = this.getAffectedChildren();
        if (children != null) {
            i = 0;
            while (i < children.length) {
                buffer.append("\n");
                buffer.append(((JavaElementDelta)children[i]).toDebugString(depth + 1));
                ++i;
            }
        }
        i = 0;
        while (i < this.resourceDeltasCounter) {
            buffer.append("\n");
            int j = 0;
            while (j < depth + 1) {
                buffer.append('\t');
                ++j;
            }
            IResourceDelta resourceDelta = this.resourceDeltas[i];
            buffer.append(resourceDelta.toString());
            buffer.append("[");
            switch (resourceDelta.getKind()) {
                case 1: {
                    buffer.append('+');
                    break;
                }
                case 2: {
                    buffer.append('-');
                    break;
                }
                case 4: {
                    buffer.append('*');
                    break;
                }
                default: {
                    buffer.append('?');
                }
            }
            buffer.append("]");
            ++i;
        }
        return buffer.toString();
    }

    @Override
    protected boolean toDebugString(StringBuffer buffer, int flags) {
        boolean prev = super.toDebugString(buffer, flags);
        if ((flags & 8) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("CHILDREN");
            prev = true;
        }
        if ((flags & 1) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("CONTENT");
            prev = true;
        }
        if ((flags & 0x10) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("MOVED_FROM(" + ((JavaElement)this.getMovedFromElement()).toStringWithAncestors() + ")");
            prev = true;
        }
        if ((flags & 0x20) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("MOVED_TO(" + ((JavaElement)this.getMovedToElement()).toStringWithAncestors() + ")");
            prev = true;
        }
        if ((flags & 0x40) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("ADDED TO CLASSPATH");
            prev = true;
        }
        if ((flags & 0x80) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("REMOVED FROM CLASSPATH");
            prev = true;
        }
        if ((flags & 0x100) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("REORDERED");
            prev = true;
        }
        if ((flags & 0x8000) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("ARCHIVE CONTENT CHANGED");
            prev = true;
        }
        if ((flags & 0x1000) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("SOURCE ATTACHED");
            prev = true;
        }
        if ((flags & 0x2000) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("SOURCE DETACHED");
            prev = true;
        }
        if ((flags & 0x4000) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("FINE GRAINED");
            prev = true;
        }
        if ((flags & 0x10000) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("PRIMARY WORKING COPY");
            prev = true;
        }
        if ((flags & 0x20000) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("CLASSPATH CHANGED");
            prev = true;
        }
        if ((flags & 0x40000) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("PRIMARY RESOURCE");
            prev = true;
        }
        if ((flags & 0x200) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("OPENED");
            prev = true;
        }
        if ((flags & 0x400) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("CLOSED");
            prev = true;
        }
        if ((flags & 0x80000) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("AST AFFECTED");
            prev = true;
        }
        if ((flags & 0x100000) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("CATEGORIES");
            prev = true;
        }
        return prev;
    }

    @Override
    public String toString() {
        return this.toDebugString(0);
    }
}

