/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.perspective;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.FormToolPropertiesInterface;

public class FormToolProperties
implements FormToolPropertiesInterface {
    private Hashtable propertyTable_ = new Hashtable();
    private Hashtable errantValues_ = new Hashtable();

    public final Object getProperty(Object key) {
        return this.propertyTable_.get(key);
    }

    public final void setProperty(Object key, Object value) {
        this.propertyTable_.put(key, value);
    }

    public final void removeProperty(Object key) {
        this.propertyTable_.remove(key);
    }

    public final void clearPropertyTable() {
        this.propertyTable_.clear();
    }

    public final void updatePropertyTable(Hashtable newPropertyTable) {
        Enumeration e = newPropertyTable.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            this.propertyTable_.put(key, newPropertyTable.get(key));
        }
    }

    public final void setPropertyTable(Hashtable newPropertyTable) {
        this.clearPropertyTable();
        this.updatePropertyTable(newPropertyTable);
    }

    public final void flagError(Object inputKey) {
        if (this.isInputValid(inputKey)) {
            this.errantValues_.put(inputKey, Boolean.TRUE);
        }
    }

    public final void flagRowError(Object inputKey, int rowNumber) {
        this.flagRowError(inputKey, String.valueOf(rowNumber));
    }

    public final void flagRowError(Object inputKey, Object rowId) {
        Object errorObject = this.errantValues_.get(inputKey);
        Hashtable<Object, Boolean> rowHash = errorObject instanceof Hashtable ? (Hashtable<Object, Boolean>)errorObject : new Hashtable<Object, Boolean>();
        rowHash.put(rowId, Boolean.TRUE);
        this.errantValues_.put(inputKey, rowHash);
    }

    public final void clearErrors() {
        this.errantValues_.clear();
    }

    public final boolean isInputValid(Object inputKey) {
        return this.errantValues_.get(inputKey) == null;
    }

    public final boolean isRowInputValid(Object inputKey, int rowNumber) {
        return this.isRowInputValid(inputKey, String.valueOf(rowNumber));
    }

    public final boolean isRowInputValid(Object inputKey, Object rowId) {
        Hashtable rowHash = (Hashtable)this.errantValues_.get(inputKey);
        if (rowHash == null) {
            return true;
        }
        return rowHash.get(rowId) == null;
    }
}

