/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.jaxp.launching.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.xsl.launching.config.PreferenceUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OutputPropertyPreferences {
    private final Map<String, Map<String, String>> typeProperties = new HashMap<String, Map<String, String>>();

    public Map<String, String> getOutputPropertyValues(String typeId) {
        return this.typeProperties.get(typeId);
    }

    public void setOutputPropertyValues(String typeId, Map<String, String> properties) {
        this.typeProperties.put(typeId, properties);
    }

    public String getAsXML() throws ParserConfigurationException, IOException, TransformerException {
        Document doc = PreferenceUtil.getDocument();
        Element config = doc.createElement("outputPropertyPreferences");
        doc.appendChild(config);
        for (String type : this.typeProperties.keySet()) {
            Element processorTypeElement = OutputPropertyPreferences.typeAsElement(doc, type);
            Map<String, String> propertyValues = this.typeProperties.get(type);
            OutputPropertyPreferences.featureValuesAsElement(doc, processorTypeElement, propertyValues);
            config.appendChild(processorTypeElement);
        }
        return PreferenceUtil.serializeDocument((Document)doc);
    }

    public static OutputPropertyPreferences fromXML(InputStream inputStream) throws CoreException {
        OutputPropertyPreferences prefs = new OutputPropertyPreferences();
        Document doc = PreferenceUtil.getDocument((InputStream)inputStream);
        Element config = doc.getDocumentElement();
        Element[] processorTypeEls = PreferenceUtil.getChildElements((Element)config, (String)"processorType");
        int i = 0;
        while (i < processorTypeEls.length) {
            Element processorTypeEl = processorTypeEls[i];
            String type = OutputPropertyPreferences.elementAsType(processorTypeEl);
            Map<String, String> featureValues = OutputPropertyPreferences.elementAsPropertyValues(processorTypeEl);
            prefs.setOutputPropertyValues(type, featureValues);
            ++i;
        }
        return prefs;
    }

    private static String elementAsType(Element parent) {
        String id = parent.getAttribute("id");
        return id;
    }

    private static Element typeAsElement(Document doc, String type) {
        Element element = doc.createElement("processorType");
        element.setAttribute("id", type);
        return element;
    }

    private static Map<String, String> elementAsPropertyValues(Element element) {
        Element[] propertyEls = PreferenceUtil.getChildElements((Element)element, (String)"property");
        HashMap<String, String> propertyValues = new HashMap<String, String>();
        Element[] elementArray = propertyEls;
        int n = propertyEls.length;
        int n2 = 0;
        while (n2 < n) {
            Element featureEl = elementArray[n2];
            String name = featureEl.getAttribute("name");
            String value = featureEl.getAttribute("value");
            propertyValues.put(name, value);
            ++n2;
        }
        return propertyValues;
    }

    private static void featureValuesAsElement(Document doc, Element featuresEl, Map<String, String> propertyValues) {
        if (propertyValues != null) {
            for (Map.Entry<String, String> entry : propertyValues.entrySet()) {
                String name = entry.getKey();
                String value = entry.getValue();
                Element element = doc.createElement("property");
                element.setAttribute("name", name);
                element.setAttribute("value", value);
                featuresEl.appendChild(element);
            }
        }
    }
}

