/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.wst.wsdl.util;


import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.w3c.dom.Node;


/**
 * Generated by the WSDL model parsing and validation mechanisms.
 * 
 * <p>
 * <b>Note:</b> This class/interface is part of an interim API that is still
 * under development and expected to change significantly before reaching
 * stability. It is being made available at this early stage to solicit feedback
 * from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.
 * </p>
 * 
 * This interface is a candidate to becoming a first class WSDL model object.
 */
public interface WSDLDiagnostic extends Resource.Diagnostic
{
  /**
   * Provides this diagnostic's severity.
   * 
   * @return an XSDDiagnosticSeverity
   */
  WSDLDiagnosticSeverity getSeverity();

  /**
   * Sets this diagnostic's severity.
   * 
   * @param severity
   *          the new diagnostic severity.
   */
  void setSeverity(WSDLDiagnosticSeverity severity);

  /**
   * Gets the original message key.
   * 
   * @return a String with the original message key.
   */
  String getKey();

  /**
   * Sets the original message key.
   * @param value the new message key value.
   */
  void setKey(String value);

  /**
   * Gets the DOM Node where the error occurs
   * 
   * @return The DOM node where the error occurs
   */
  Node getNode();

  /**
   * Sets the DOM Node where the error occurs
   * @param node
   */
  void setNode(Node node);

  /**
   * returns the Element where the error occurs
   * @return - Object of type XSDConcreteComponent if the error
   * 			comes from the inline schema of a wsdl file
   * 		 - object of type WSDLElement if the error comes from
   * 			other part of the wsdl file
   */
  Object getContainer();

  /**
   * Sets the Container of the error
   * @param container
   * 			an Object of either XSDConcreteComponent or WSDLElement 
   */
  void setContainer(Object container);

  /**
   * Returns a list with the original message parameters as Strings.
   * @return  a list with the original message parameters as Strings.
   */
  EList getSubstitutions();
}
