/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tests;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class FileTool {
    private static byte[] buffer = new byte[8192];

    public static String changeSeparator(String path, char oldSeparator, char newSeparator) {
        return path.replace(oldSeparator, newSeparator);
    }

    public static boolean compare(File file1, File file2) throws IOException {
        boolean bl;
        BufferedInputStream is1;
        block15: {
            if (file1.length() != file2.length()) {
                return false;
            }
            is1 = null;
            InputStream is2 = null;
            try {
                is1 = new BufferedInputStream(new FileInputStream(file1));
                is2 = new BufferedInputStream(new FileInputStream(file2));
                int a = 0;
                int b = 0;
                boolean same = true;
                while (same && a != -1 && b != -1) {
                    a = ((InputStream)is1).read();
                    boolean bl2 = same = a == (b = is2.read());
                }
                bl = same;
                if (is2 == null) break block15;
            }
            catch (Throwable throwable) {
                if (is2 != null) {
                    try {
                        is2.close();
                    }
                    catch (IOException iOException) {}
                }
                if (is1 != null) {
                    try {
                        ((InputStream)is1).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                is2.close();
            }
            catch (IOException iOException) {}
        }
        if (is1 != null) {
            try {
                ((InputStream)is1).close();
            }
            catch (IOException iOException) {}
        }
        return bl;
    }

    public static void copy(File src, File dst) throws IOException {
        FileTool.copy(src.getParentFile(), src, dst);
    }

    public static void copy(File root, File src, File dst) throws IOException {
        if (src.isDirectory()) {
            String[] children = src.list();
            int i = 0;
            while (i < children.length) {
                File child = new File(src, children[i]);
                FileTool.copy(root, child, dst);
                ++i;
            }
        } else {
            String rootString = root.toString();
            String srcString = src.toString();
            File dstFile = new File(dst, srcString.substring(rootString.length() + 1));
            FileTool.transferData(src, dstFile);
        }
    }

    public static void delete(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                String[] children = file.list();
                int i = 0;
                while (i < children.length) {
                    File child = new File(file, children[i]);
                    FileTool.delete(child);
                    ++i;
                }
            }
            if (!file.delete()) {
                System.out.println("WARNING: could not delete " + file);
            }
        }
    }

    public static File getFile(String[] segments) {
        File result = new File(segments[0]);
        int i = 1;
        while (i < segments.length) {
            result = new File(result, segments[i]);
            ++i;
        }
        return result;
    }

    public static File[] getFiles(File dir, String[] include, String[] exclude) {
        ArrayList<File> list = new ArrayList<File>();
        String[] children = dir.list();
        if (children == null) {
            return new File[0];
        }
        int i = 0;
        while (i < children.length) {
            int j;
            File child = new File(dir, children[i]);
            String name = child.getName();
            if (child.isDirectory()) {
                File[] result = FileTool.getFiles(child, include, exclude);
                j = 0;
                while (j < result.length) {
                    list.add(result[j]);
                    ++j;
                }
            } else {
                boolean excludeFile;
                boolean includeFile;
                boolean bl = includeFile = include == null;
                if (include != null) {
                    j = 0;
                    while (j < include.length) {
                        if (name.endsWith(include[j])) {
                            includeFile = true;
                            break;
                        }
                        ++j;
                    }
                }
                boolean bl2 = excludeFile = exclude != null;
                if (exclude != null) {
                    int j2 = 0;
                    while (j2 < exclude.length) {
                        if (name.endsWith(exclude[j2])) {
                            excludeFile = true;
                            break;
                        }
                        ++j2;
                    }
                }
                if (includeFile && !excludeFile) {
                    list.add(child);
                }
            }
            ++i;
        }
        return list.toArray(new File[0]);
    }

    public static String[] getSegments(File file) {
        return FileTool.getSegments(file.toString(), File.separatorChar);
    }

    public static String[] getSegments(String s, char separator) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(s, "" + separator);
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken());
        }
        return result.toArray(new String[0]);
    }

    public static File[] parsePaths(String paths) {
        ArrayList<File> result = new ArrayList<File>();
        StringTokenizer tokenizer = new StringTokenizer(paths, ";");
        while (tokenizer.hasMoreTokens()) {
            result.add(new File(tokenizer.nextToken()));
        }
        return result.toArray(new File[0]);
    }

    public static void transferData(File source, File destination) throws IOException {
        destination.getParentFile().mkdirs();
        FileInputStream is = null;
        OutputStream os = null;
        try {
            is = new FileInputStream(source);
            os = new FileOutputStream(destination);
            FileTool.transferData(is, os);
        }
        catch (Throwable throwable) {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException iOException) {}
        }
        if (is != null) {
            try {
                ((InputStream)is).close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void transferData(InputStream source, OutputStream destination) throws IOException {
        int bytesRead = 0;
        while (bytesRead != -1) {
            bytesRead = source.read(buffer, 0, buffer.length);
            if (bytesRead == -1) continue;
            destination.write(buffer, 0, bytesRead);
        }
    }

    public static void unzip(IZipFilter filter, ZipFile zipFile, File dstDir) throws IOException {
        FileTool.unzip(filter, zipFile, dstDir, dstDir, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void unzip(IZipFilter filter, ZipFile zipFile, File rootDstDir, File dstDir, int depth) throws IOException {
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        try {
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                String entryName = entry.getName();
                File file = new File(dstDir, FileTool.changeSeparator(entryName, '/', File.separatorChar));
                String fullEntryName = FileTool.changeSeparator(file.toString().substring(rootDstDir.toString().length() + 1), File.separatorChar, '/');
                if (filter != null && !filter.shouldExtract(fullEntryName, entryName, depth)) continue;
                file.getParentFile().mkdirs();
                InputStream src = null;
                OutputStream dst = null;
                try {
                    src = zipFile.getInputStream(entry);
                    dst = new FileOutputStream(file);
                    FileTool.transferData(src, dst);
                }
                catch (Throwable throwable) {
                    if (dst != null) {
                        try {
                            dst.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (src == null) throw throwable;
                    try {
                        src.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                if (dst != null) {
                    try {
                        dst.close();
                    }
                    catch (IOException iOException) {}
                }
                if (src != null) {
                    try {
                        src.close();
                    }
                    catch (IOException iOException) {}
                }
                if (!entryName.endsWith(".zip") && !entryName.endsWith(".jar") || filter != null && !filter.shouldUnzip(fullEntryName, entryName, depth)) continue;
                String fileName = file.getName();
                String dirName = String.valueOf(fileName.substring(0, fileName.length() - 4)) + "_" + fileName.substring(fileName.length() - 3);
                ZipFile innerZipFile = null;
                try {
                    innerZipFile = new ZipFile(file);
                    File innerDstDir = new File(file.getParentFile(), dirName);
                    FileTool.unzip(filter, innerZipFile, rootDstDir, innerDstDir, depth + 1);
                    file.delete();
                }
                catch (IOException e) {
                    if (innerZipFile != null) {
                        try {
                            innerZipFile.close();
                        }
                        catch (IOException iOException) {}
                    }
                    System.out.println("Could not unzip: " + fileName + ". InnerZip = " + innerZipFile.getName() + ". Lenght: " + innerZipFile.getName().length());
                    e.printStackTrace();
                }
            }
        }
        catch (Throwable throwable) {
            try {
                zipFile.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            zipFile.close();
            return;
        }
        catch (IOException iOException) {}
    }

    public static void unzip(IZipFilter filter, File dstDir) throws IOException {
        FileTool.unzip(filter, dstDir, dstDir, 0);
    }

    private static void unzip(IZipFilter filter, File rootDstDir, File dstDir, int depth) throws IOException {
        File[] entries = rootDstDir.listFiles();
        try {
            int i = 0;
            while (i < entries.length) {
                if (entries[i].isDirectory()) {
                    FileTool.unzip(filter, entries[i], dstDir, depth);
                }
                File entry = entries[i];
                String entryName = entry.getName();
                File file = new File(dstDir, FileTool.changeSeparator(entryName, '/', File.separatorChar));
                if (entryName.endsWith(".zip") || entryName.endsWith(".jar")) {
                    String fileName = file.getName();
                    String dirName = String.valueOf(fileName.substring(0, fileName.length() - 4)) + "_" + fileName.substring(fileName.length() - 3);
                    ZipFile innerZipFile = null;
                    try {
                        innerZipFile = new ZipFile(entry);
                        File innerDstDir = new File(entry.getParentFile(), dirName);
                        FileTool.unzip(filter, innerZipFile, rootDstDir, innerDstDir, depth + 1);
                    }
                    catch (IOException e) {
                        if (innerZipFile != null) {
                            try {
                                innerZipFile.close();
                            }
                            catch (IOException iOException) {}
                        }
                        System.out.println("Could not unzip: " + fileName + ". InnerZip = " + innerZipFile.getName() + ". Lenght: " + innerZipFile.getName().length());
                        e.printStackTrace();
                    }
                }
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void zip(File dir, File zipFile) throws IOException {
        BufferedOutputStream bos = null;
        ZipOutputStream zos = null;
        try {
            bos = new BufferedOutputStream(new FileOutputStream(zipFile));
            zos = new ZipOutputStream(bos);
            FileTool.zip(dir, dir, zos);
        }
        catch (Throwable throwable) {
            if (zos == null) {
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (IOException iOException) {}
                }
            } else {
                try {
                    zos.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (zos == null) {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException iOException) {}
            }
        } else {
            try {
                zos.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static void zip(File root, File file, ZipOutputStream zos) throws IOException {
        if (file.isDirectory()) {
            String name = file.getName();
            if (name.endsWith("_zip") || name.endsWith("_jar")) {
                String rootString = root.toString();
                String fileString = file.toString();
                String zipEntryName = fileString.substring(rootString.length() + 1);
                int underscoreIndex = zipEntryName.lastIndexOf("_");
                zipEntryName = String.valueOf(zipEntryName.substring(0, underscoreIndex)) + "." + zipEntryName.substring(underscoreIndex + 1);
                ZipEntry zipEntry = new ZipEntry(FileTool.changeSeparator(zipEntryName, File.separatorChar, '/'));
                zos.putNextEntry(zipEntry);
                ZipOutputStream zos2 = new ZipOutputStream(zos);
                String[] list = file.list();
                int i = 0;
                while (i < list.length) {
                    File item = new File(file, list[i]);
                    FileTool.zip(file, item, zos2);
                    ++i;
                }
                zos2.finish();
                zos.closeEntry();
            } else {
                String[] list = file.list();
                int i = 0;
                while (i < list.length) {
                    File item = new File(file, list[i]);
                    FileTool.zip(root, item, zos);
                    ++i;
                }
            }
        } else {
            String rootString = root.toString();
            String fileString = file.toString();
            String zipEntryName = fileString.substring(rootString.length() + 1);
            ZipEntry zipEntry = new ZipEntry(FileTool.changeSeparator(zipEntryName, File.separatorChar, '/'));
            zos.putNextEntry(zipEntry);
            FileInputStream fos = null;
            try {
                fos = new FileInputStream(file);
                FileTool.transferData(fos, zos);
            }
            catch (Throwable throwable) {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
            zos.closeEntry();
        }
    }

    public static interface IZipFilter {
        public boolean shouldExtract(String var1, String var2, int var3);

        public boolean shouldUnzip(String var1, String var2, int var3);
    }
}

