/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal;

import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.AbstractPair;

public class AbstractPairTests
extends TestCase {
    public AbstractPairTests(String name) {
        super(name);
    }

    public void testEquals1() {
        LocalPair pair1 = new LocalPair("foo", "bar");
        LocalPair pair2 = new LocalPair("foo", "bar");
        AbstractPairTests.assertEquals((Object)((Object)pair1), (Object)((Object)pair2));
    }

    public void testEquals1a() {
        LocalPair pair1 = new LocalPair("foo", null);
        LocalPair pair2 = new LocalPair("foo", null);
        AbstractPairTests.assertEquals((Object)((Object)pair1), (Object)((Object)pair2));
    }

    public void testEquals1b() {
        LocalPair pair1 = new LocalPair(null, "bar");
        LocalPair pair2 = new LocalPair(null, "bar");
        AbstractPairTests.assertEquals((Object)((Object)pair1), (Object)((Object)pair2));
    }

    public void testEquals2() {
        LocalPair pair = new LocalPair("foo", "bar");
        AbstractPairTests.assertFalse((boolean)pair.equals("foo"));
    }

    public void testEquals3() {
        LocalPair pair1 = new LocalPair("foo", "bar");
        LocalPair pair2 = new LocalPair("bar", "foo");
        AbstractPairTests.assertFalse((boolean)pair1.equals((Object)pair2));
    }

    public void testEquals4() {
        LocalPair pair1 = new LocalPair("foo", "bar");
        LocalPair pair2 = new LocalPair("foo", "foo");
        AbstractPairTests.assertFalse((boolean)pair1.equals((Object)pair2));
    }

    public void testEquals5() {
        LocalPair pair1 = new LocalPair("foo", "bar");
        LocalPair pair2 = new LocalPair(null, "bar");
        AbstractPairTests.assertFalse((boolean)pair1.equals((Object)pair2));
    }

    public void testEquals6() {
        LocalPair pair1 = new LocalPair("foo", "bar");
        LocalPair pair2 = new LocalPair("foo", null);
        AbstractPairTests.assertFalse((boolean)pair1.equals((Object)pair2));
    }

    public void testEquals7() {
        LocalPair pair1 = new LocalPair(null, "bar");
        LocalPair pair2 = new LocalPair("foo", "bar");
        AbstractPairTests.assertFalse((boolean)pair1.equals((Object)pair2));
    }

    public void testEquals8() {
        LocalPair pair1 = new LocalPair("foo", null);
        LocalPair pair2 = new LocalPair("foo", "bar");
        AbstractPairTests.assertFalse((boolean)pair1.equals((Object)pair2));
    }

    public void testToHashCode1() {
        LocalPair pair = new LocalPair("foo", "bar");
        AbstractPairTests.assertEquals((int)("foo".hashCode() ^ "bar".hashCode()), (int)pair.hashCode());
    }

    public void testToHashCode2() {
        LocalPair pair = new LocalPair(null, "bar");
        AbstractPairTests.assertEquals((int)"bar".hashCode(), (int)pair.hashCode());
    }

    public void testToHashCode3() {
        LocalPair pair = new LocalPair("foo", null);
        AbstractPairTests.assertEquals((int)"foo".hashCode(), (int)pair.hashCode());
    }

    public void testToString() {
        LocalPair pair = new LocalPair("foo", "bar");
        AbstractPairTests.assertEquals((String)"foo|bar", (String)((Object)((Object)pair)).toString());
    }

    public static class LocalPair
    extends AbstractPair<String, String> {
        private final String left;
        private final String right;

        public LocalPair(String left, String right) {
            this.left = left;
            this.right = right;
        }

        public String getLeft() {
            return this.left;
        }

        public String getRight() {
            return this.right;
        }
    }
}

