/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.tests.internal.swt.bindings;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.jpt.common.ui.internal.swt.bindings.SWTBindingTools;
import org.eclipse.jpt.common.utility.internal.model.value.SimpleListValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class BooleanStateControllerUITest
extends ApplicationWindow {
    private final ModifiablePropertyValueModel<Boolean> enabledModel = new SimplePropertyValueModel((Object)Boolean.TRUE);
    private final ModifiablePropertyValueModel<Boolean> visibleModel = new SimplePropertyValueModel((Object)Boolean.TRUE);
    private final SimpleListValueModel<String> listModel = this.buildListModel();
    private final ModifiablePropertyValueModel<String> listSelectionModel = new SimplePropertyValueModel(null);

    public static void main(String[] args) throws Exception {
        BooleanStateControllerUITest window = new BooleanStateControllerUITest(args);
        window.setBlockOnOpen(true);
        window.open();
        Display.getCurrent().dispose();
        System.exit(0);
    }

    private BooleanStateControllerUITest(String[] args) {
        super(null);
    }

    private SimpleListValueModel<String> buildListModel() {
        SimpleListValueModel result = new SimpleListValueModel();
        result.add((Object)"zero");
        result.add((Object)"one");
        result.add((Object)"two");
        result.add((Object)"three");
        result.add((Object)"four");
        result.add((Object)"five");
        result.add((Object)"six");
        result.add((Object)"seven");
        return result;
    }

    protected Control createContents(Composite parent) {
        ((Shell)parent).setText(((Object)((Object)this)).getClass().getSimpleName());
        parent.setSize(500, 150);
        Composite mainPanel = new Composite(parent, 0);
        mainPanel.setLayout((Layout)new FormLayout());
        Control widgetPanel = this.buildWidgetPanels(mainPanel);
        this.buildControlPanel(mainPanel, widgetPanel);
        return mainPanel;
    }

    private Control buildWidgetPanels(Composite parent) {
        Composite panel = new Composite(parent, 0);
        FormData fd = new FormData();
        fd.top = new FormAttachment(0);
        fd.bottom = new FormAttachment(100, -35);
        fd.left = new FormAttachment(0);
        fd.right = new FormAttachment(100);
        panel.setLayoutData((Object)fd);
        panel.setLayout((Layout)new FillLayout(512));
        this.buildWidgetPanel1(panel);
        this.buildWidgetPanel2(panel);
        return panel;
    }

    private void buildWidgetPanel1(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new FillLayout(256));
        Button enabledComboBoxCheckBox = this.buildEnabledComboBoxCheckBox(panel);
        SWTBindingTools.bind(this.enabledModel, (Button)enabledComboBoxCheckBox);
        Button visibleComboBoxCheckBox = this.buildVisibleComboBoxCheckBox(panel);
        SWTBindingTools.bind(this.visibleModel, (Button)visibleComboBoxCheckBox);
        Label comboBoxLabel = this.buildComboBoxLabel(panel);
        Combo comboBox = this.buildComboBox(panel);
        SWTBindingTools.bindDropDownListBox(this.listModel, this.listSelectionModel, (Combo)comboBox);
        SWTBindingTools.bindEnabledState(this.enabledModel, (Control[])new Control[]{comboBoxLabel, comboBox});
        SWTBindingTools.bindVisibleState(this.visibleModel, (Control[])new Control[]{comboBoxLabel, comboBox});
    }

    private Button buildEnabledComboBoxCheckBox(Composite parent) {
        return this.buildCheckBox(parent, "enabled");
    }

    private Button buildVisibleComboBoxCheckBox(Composite parent) {
        return this.buildCheckBox(parent, "visible");
    }

    private Button buildCheckBox(Composite parent, String text) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(text);
        return checkBox;
    }

    private Label buildComboBoxLabel(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setText("list:");
        return label;
    }

    private Combo buildComboBox(Composite parent) {
        return new Combo(parent, 8);
    }

    private void buildWidgetPanel2(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new FillLayout(256));
        Button checkBox1 = this.buildCheckBox(panel, "one");
        this.buildCheckBox(panel, "two");
        this.buildCheckBox(panel, "three");
        this.buildCheckBox(panel, "four");
        SWTBindingTools.bindEnabledState(this.enabledModel, (Control[])new Control[]{panel, checkBox1});
        SWTBindingTools.bindVisibleState(this.visibleModel, (Control[])new Control[]{panel});
    }

    private void buildControlPanel(Composite parent, Control widgetPanel) {
        Composite panel = new Composite(parent, 0);
        FormData fd = new FormData();
        fd.top = new FormAttachment(widgetPanel);
        fd.bottom = new FormAttachment(100);
        fd.left = new FormAttachment(0);
        fd.right = new FormAttachment(100);
        panel.setLayoutData((Object)fd);
        panel.setLayout((Layout)new FillLayout());
        this.buildClearEnabledModelButton(panel);
        this.buildClearVisibleModelButton(panel);
        this.buildNullSelectionModelButton(panel);
        this.buildNextButton(panel);
    }

    private void buildClearEnabledModelButton(Composite parent) {
        this.buildClearEnabledModelACI().fill(parent);
    }

    private ActionContributionItem buildClearEnabledModelACI() {
        Action action = new Action("clear enabled model", 1){

            public void run() {
                BooleanStateControllerUITest.this.clearEnabledModel();
            }
        };
        action.setToolTipText("clear enabled model");
        return new ActionContributionItem((IAction)action);
    }

    void clearEnabledModel() {
        this.enabledModel.setValue(null);
    }

    private void buildClearVisibleModelButton(Composite parent) {
        this.buildClearVisibleModelACI().fill(parent);
    }

    private ActionContributionItem buildClearVisibleModelACI() {
        Action action = new Action("clear visible model", 1){

            public void run() {
                BooleanStateControllerUITest.this.clearVisibleModel();
            }
        };
        action.setToolTipText("clear visible model");
        return new ActionContributionItem((IAction)action);
    }

    void clearVisibleModel() {
        this.visibleModel.setValue(null);
    }

    private void buildNullSelectionModelButton(Composite parent) {
        this.buildNullSelectionModelACI().fill(parent);
    }

    private ActionContributionItem buildNullSelectionModelACI() {
        Action action = new Action("null selection model", 1){

            public void run() {
                BooleanStateControllerUITest.this.setSelectionModelNull();
            }
        };
        action.setToolTipText("null selection model");
        return new ActionContributionItem((IAction)action);
    }

    void setSelectionModelNull() {
        this.listSelectionModel.setValue(null);
    }

    private void buildNextButton(Composite parent) {
        this.buildNextACI().fill(parent);
    }

    private ActionContributionItem buildNextACI() {
        Action action = new Action("next", 1){

            public void run() {
                BooleanStateControllerUITest.this.next();
            }
        };
        action.setToolTipText("next");
        return new ActionContributionItem((IAction)action);
    }

    void next() {
        this.listSelectionModel.setValue((Object)this.getNextListSelection());
    }

    private String getNextListSelection() {
        return (String)this.listModel.get(this.getNextListSelectionIndex());
    }

    private int getNextListSelectionIndex() {
        int index = this.getListSelectionIndex();
        if (index == -1) {
            return 0;
        }
        return ++index == this.listModel.size() ? 0 : index;
    }

    private int getListSelectionIndex() {
        return this.listModel.indexOf((Object)this.getListSelection());
    }

    private String getListSelection() {
        return (String)this.listSelectionModel.getValue();
    }
}

