/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.dtmanager.converter.operations;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.dtmanager.converter.ITransformOperation;
import org.eclipse.jst.pagedesigner.dtmanager.converter.operations.AbstractTransformOperation;
import org.osgi.framework.Bundle;

public final class TransformOperationFactory {
    public static final String OP_AppendChildElementOperation = String.valueOf(PDPlugin.getPluginId()) + ".AppendChildElementOperation";
    public static final String OP_AppendChildTextFromXPathOperation = String.valueOf(PDPlugin.getPluginId()) + ".AppendChildTextFromXPathOperation";
    public static final String OP_AppendChildTextOperation = String.valueOf(PDPlugin.getPluginId()) + ".AppendChildTextOperation";
    public static final String OP_ConvertAttributeToTextOperation = String.valueOf(PDPlugin.getPluginId()) + ".ConvertAttributeToTextOperation";
    public static final String OP_CopyAllAttributesOperation = String.valueOf(PDPlugin.getPluginId()) + ".CopyAllAttributesOperation";
    public static final String OP_CopyAttributeOperation = String.valueOf(PDPlugin.getPluginId()) + ".CopyAttributeOperation";
    public static final String OP_CopyAttributeWithRenameOperation = String.valueOf(PDPlugin.getPluginId()) + ".CopyAttributeWithRenameOperation";
    public static final String OP_CopyChildrenOperation = String.valueOf(PDPlugin.getPluginId()) + ".CopyChildrenOperation";
    public static final String OP_CreateAttributeFromXPathOperation = String.valueOf(PDPlugin.getPluginId()) + ".CreateAttributeFromXPathOperation";
    public static final String OP_CreateAttributeOperation = String.valueOf(PDPlugin.getPluginId()) + ".CreateAttributeOperation";
    public static final String OP_CreateElementOperation = String.valueOf(PDPlugin.getPluginId()) + ".CreateElementOperation";
    public static final String OP_CustomTransformOperation = String.valueOf(PDPlugin.getPluginId()) + ".CustomTransformOperation";
    public static final String OP_IfNotOperation = String.valueOf(PDPlugin.getPluginId()) + ".IfNotOperation";
    public static final String OP_IfOperation = String.valueOf(PDPlugin.getPluginId()) + ".IfOperation";
    public static final String OP_IterateOverElementsOperation = String.valueOf(PDPlugin.getPluginId()) + ".IterateOverElementsOperation";
    public static final String OP_MakeParentElementCurrentOperation = String.valueOf(PDPlugin.getPluginId()) + ".MakeParentElementCurrentOperation";
    public static final String OP_RemoveAttributeOperation = String.valueOf(PDPlugin.getPluginId()) + ".RemoveAttributeOperation";
    public static final String OP_RenameAttributeOperation = String.valueOf(PDPlugin.getPluginId()) + ".RenameAttributeOperation";
    private static TransformOperationFactory instance;
    private Logger log = PDPlugin.getLogger(TransformOperationFactory.class);
    private Map<String, Class> _tagTransformOpsRegistry;

    private TransformOperationFactory() {
        this.readAllTagTransformOperations();
    }

    public static synchronized TransformOperationFactory getInstance() {
        if (instance == null) {
            instance = new TransformOperationFactory();
        }
        return instance;
    }

    public ITransformOperation getTransformOperation(String opID, String[] params) {
        Class opClass = null;
        try {
            opClass = this._tagTransformOpsRegistry.get(opID);
            if (opClass != null) {
                Object opObject = opClass.newInstance();
                if (opObject instanceof AbstractTransformOperation) {
                    ((AbstractTransformOperation)opObject).setParameters(params);
                    ((AbstractTransformOperation)opObject).setTransformOperationID(opID);
                    return (AbstractTransformOperation)opObject;
                }
                this.log.error("Warning.TransformOperationFactory.NotAbstractTransformOperation", opClass.getName());
            } else {
                this.log.error("Warning.TransformOperationFactory.ExtensionNotFound", opID);
            }
        }
        catch (IllegalAccessException iae) {
            this.log.error("Warning.TransformOperationFactory.IllegalAccess", opClass.getName(), (Throwable)iae);
        }
        catch (InstantiationException ie) {
            this.log.error("Warning.TransformOperationFactory.Instantiation", opClass.getName(), (Throwable)ie);
        }
        return null;
    }

    private void readAllTagTransformOperations() {
        try {
            this._tagTransformOpsRegistry = new HashMap<String, Class>();
            IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(PDPlugin.getPluginId(), "pageDesignerExtension");
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension ext = extensions[i];
                int j = 0;
                while (j < ext.getConfigurationElements().length) {
                    if (ext.getConfigurationElements()[j].getName().equals("tagTransformOperation")) {
                        this.registerTransformOperation(ext.getConfigurationElements()[j]);
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (InvalidRegistryObjectException e) {
            this.log.error("Warning.TransformOperationFactory.RegistryError", String.valueOf(PDPlugin.getPluginId()) + "pageDesignerExtension" + "." + "tagTransformOperation", (Throwable)e);
        }
    }

    private void registerTransformOperation(IConfigurationElement element) {
        Bundle bundle = Platform.getBundle((String)element.getContributor().getName());
        String id = String.valueOf(element.getContributor().getName()) + "." + element.getAttribute("id");
        if (bundle != null) {
            try {
                Class transformClass = bundle.loadClass(element.getAttribute("class"));
                this._tagTransformOpsRegistry.put(id, transformClass);
            }
            catch (Exception e) {
                this.log.error("Warning.TransformOperationFactory.CannotLoadOpClass", id, (Throwable)e);
            }
        }
    }
}

