/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.tools.v8;

import java.util.concurrent.CountDownLatch;
import org.eclipse.wst.jsdt.chromium.Breakpoint;
import org.eclipse.wst.jsdt.chromium.JavascriptVm;
import org.eclipse.wst.jsdt.chromium.RelayOk;
import org.eclipse.wst.jsdt.chromium.SyncCallback;
import org.eclipse.wst.jsdt.chromium.internal.TestUtil;
import org.eclipse.wst.jsdt.chromium.internal.browserfixture.AbstractAttachedTest;
import org.eclipse.wst.jsdt.chromium.internal.transport.FakeConnection;
import org.eclipse.wst.jsdt.chromium.internal.v8native.BreakpointImpl;
import org.eclipse.wst.jsdt.chromium.internal.v8native.BreakpointManager;
import org.eclipse.wst.jsdt.chromium.internal.v8native.DebugSession;
import org.junit.Assert;
import org.junit.Test;

public class BreakpointImplTest
extends AbstractAttachedTest<FakeConnection> {
    public boolean isBreakpointChanged;
    public boolean isBreakpointCleared;

    @Test(timeout=5000L)
    public void testCreateChange() throws Exception {
        final String[] resultMessage = new String[1];
        final Breakpoint[] resultBreakpoint = new Breakpoint[1];
        final CountDownLatch latch = new CountDownLatch(1);
        this.javascriptVm.setBreakpoint((Breakpoint.Target)new Breakpoint.Target.ScriptName("1"), 4, 1, true, "false", new JavascriptVm.BreakpointCallback(){

            public void failure(String errorMessage) {
                resultMessage[0] = errorMessage;
                latch.countDown();
            }

            public void success(Breakpoint breakpoint) {
                resultBreakpoint[0] = breakpoint;
                latch.countDown();
            }
        }, null);
        latch.await();
        Assert.assertNull((String)resultMessage[0], (Object)resultMessage[0]);
        Assert.assertNotNull((Object)resultBreakpoint[0]);
        Breakpoint breakpoint = resultBreakpoint[0];
        Assert.assertEquals((Object)"false", (Object)breakpoint.getCondition());
        Assert.assertTrue((boolean)breakpoint.isEnabled());
        breakpoint.setCondition("true");
        breakpoint.setEnabled(false);
        resultBreakpoint[0] = null;
        final CountDownLatch latch2 = new CountDownLatch(1);
        breakpoint.flush(new JavascriptVm.BreakpointCallback(){

            public void failure(String errorMessage) {
                resultMessage[0] = errorMessage;
                latch2.countDown();
            }

            public void success(Breakpoint breakpoint) {
                resultBreakpoint[0] = breakpoint;
                latch2.countDown();
            }
        }, null);
        latch2.await();
        Assert.assertNull((String)resultMessage[0], (Object)resultMessage[0]);
        Assert.assertNotNull((Object)resultBreakpoint[0]);
        TestUtil.assertBreakpointsEqual(breakpoint, resultBreakpoint[0]);
    }

    @Test(timeout=5000L)
    public void testClear() throws Exception {
        BreakpointImpl bp = new BreakpointImpl(1L, (Breakpoint.Target)new Breakpoint.Target.ScriptName("abc.js"), 10L, true, null, (BreakpointManager)new TestBreakpointManager(this.javascriptVm.getDebugSession()));
        final CountDownLatch latch = new CountDownLatch(1);
        final String[] resultMessage = new String[1];
        final Breakpoint[] resultBreakpoint = new Breakpoint[1];
        bp.clear(new JavascriptVm.BreakpointCallback(){

            public void failure(String errorMessage) {
                resultMessage[0] = errorMessage;
                latch.countDown();
            }

            public void success(Breakpoint breakpoint) {
                resultBreakpoint[0] = breakpoint;
                latch.countDown();
            }
        }, null);
        latch.await();
        Assert.assertNull((String)resultMessage[0], (Object)resultMessage[0]);
        Assert.assertTrue((boolean)this.isBreakpointCleared);
    }

    @Test
    public void testNonDirtyChanges() throws Exception {
        String condition = "true";
        boolean enabled = true;
        BreakpointImpl bp = new BreakpointImpl(1L, (Breakpoint.Target)new Breakpoint.Target.ScriptName("abc.js"), 10L, enabled, condition, (BreakpointManager)new TestBreakpointManager(this.javascriptVm.getDebugSession()));
        bp.setCondition(condition);
        bp.flush(null, null);
        Assert.assertFalse((boolean)this.isBreakpointChanged);
        bp.setEnabled(enabled);
        bp.flush(null, null);
        Assert.assertFalse((boolean)this.isBreakpointChanged);
        bp.flush(null, null);
        Assert.assertFalse((boolean)this.isBreakpointChanged);
    }

    @Override
    protected FakeConnection createConnection() {
        return new FakeConnection(this.messageResponder);
    }

    private class TestBreakpointManager
    extends BreakpointManager {
        public TestBreakpointManager(DebugSession debugSession) {
            super(debugSession);
        }

        public RelayOk changeBreakpoint(BreakpointImpl breakpointImpl, JavascriptVm.BreakpointCallback callback, SyncCallback syncCallback) {
            BreakpointImplTest.this.isBreakpointChanged = true;
            return super.changeBreakpoint(breakpointImpl, callback, syncCallback);
        }

        public RelayOk clearBreakpoint(BreakpointImpl breakpointImpl, JavascriptVm.BreakpointCallback callback, SyncCallback syncCallback, long originalId) {
            BreakpointImplTest.this.isBreakpointCleared = true;
            return super.clearBreakpoint(breakpointImpl, callback, syncCallback, originalId);
        }
    }
}

