/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.test.util.mock;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jst.jsf.test.util.mock.MockWorkspace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockResource
implements IResource {
    private final int _type;
    private final IPath _path;
    private boolean _exists = true;
    private MockWorkspace _workspace;
    private IProject _project;
    private long _modificationStamp = -1L;
    private Map<QualifiedName, Object> _sessionProps;
    public static final List<Integer> VALID_TYPES;
    private boolean _isSynchronized = true;

    static {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1);
        list.add(2);
        list.add(4);
        list.add(8);
        VALID_TYPES = Collections.unmodifiableList(list);
    }

    public MockResource(int type, IPath path) {
        this._path = path;
        this._type = type;
        Assert.assertTrue((boolean)VALID_TYPES.contains(type));
    }

    public int getType() {
        return this._type;
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (!(target instanceof MockResource)) {
            return false;
        }
        MockResource resource = (MockResource)target;
        return this.getType() == resource.getType() && this._path.equals((Object)resource._path) && this._workspace.equals(resource._workspace);
    }

    public int hashCode() {
        int code = this._path.hashCode();
        return code ^= this.getType();
    }

    public Object getAdapter(Class adapter) {
        throw new UnsupportedOperationException();
    }

    public boolean contains(ISchedulingRule rule) {
        throw new UnsupportedOperationException();
    }

    public boolean isConflicting(ISchedulingRule rule) {
        throw new UnsupportedOperationException();
    }

    public void accept(IResourceProxyVisitor visitor, int memberFlags) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void accept(IResourceProxyVisitor visitor, int depth, int memberFlags) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void accept(IResourceVisitor visitor) throws CoreException {
        this.accept(visitor, 2, 0);
    }

    public void accept(IResourceVisitor visitor, int depth, boolean includePhantoms) throws CoreException {
        this.accept(visitor, depth, includePhantoms ? 1 : 0);
    }

    public void accept(IResourceVisitor visitor, int depth, int memberFlags) throws CoreException {
        boolean visit = visitor.visit((IResource)this);
        if (visit) {
            this.visitMembers(visitor, depth, memberFlags);
        }
    }

    protected void visitMembers(IResourceVisitor visitor, int depth, int memberFlags) throws CoreException {
    }

    public void clearHistory(IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void copy(IPath destination, boolean force, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void copy(IPath destination, int updateFlags, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void copy(IProjectDescription description, boolean force, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void copy(IProjectDescription description, int updateFlags, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public IMarker createMarker(String type) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public IMarker createMarker(String type, Map<String, ? extends Object> attributes) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public IResourceProxy createProxy() {
        throw new UnsupportedOperationException();
    }

    public void delete(boolean force, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void delete(int updateFlags, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void deleteMarkers(String type, boolean includeSubtypes, int depth) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public boolean exists() {
        return this._exists;
    }

    public void setExists(boolean exists) {
        this._exists = exists;
    }

    public IMarker findMarker(long id) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public IMarker[] findMarkers(String type, boolean includeSubtypes, int depth) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public int findMaxProblemSeverity(String type, boolean includeSubtypes, int depth) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public String getFileExtension() {
        String name = this.getName();
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        if (index == name.length() - 1) {
            return "";
        }
        return name.substring(index + 1);
    }

    public IPath getFullPath() {
        return this._path;
    }

    public long getLocalTimeStamp() {
        throw new UnsupportedOperationException();
    }

    public IPath getLocation() {
        throw new UnsupportedOperationException();
    }

    public URI getLocationURI() {
        throw new UnsupportedOperationException();
    }

    public IMarker getMarker(long id) {
        throw new UnsupportedOperationException();
    }

    public long getModificationStamp() {
        return this._modificationStamp;
    }

    public String getName() {
        return this._path.lastSegment();
    }

    public IContainer getParent() {
        IPath myParent = this.getProjectRelativePath().removeLastSegments(1);
        if (myParent.segmentCount() == 0) {
            return this.getProject();
        }
        return this._project.getFolder(this.getProjectRelativePath().removeLastSegments(1));
    }

    public Map<QualifiedName, String> getPersistentProperties() throws CoreException {
        throw new UnsupportedOperationException();
    }

    public String getPersistentProperty(QualifiedName key) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public IProject getProject() {
        return this._project;
    }

    public void setProject(IProject project) {
        this._project = project;
    }

    public IPath getProjectRelativePath() {
        if (this.getType() == 8 || this.getType() == 4) {
            return Path.EMPTY;
        }
        IPath projectPath = this.getProject().getFullPath();
        Assert.assertTrue((boolean)projectPath.isPrefixOf(this.getFullPath()));
        return this.getFullPath().removeFirstSegments(projectPath.segmentCount());
    }

    public IPath getRawLocation() {
        throw new UnsupportedOperationException();
    }

    public URI getRawLocationURI() {
        throw new UnsupportedOperationException();
    }

    public ResourceAttributes getResourceAttributes() {
        throw new UnsupportedOperationException();
    }

    public Map<QualifiedName, Object> getSessionProperties() throws CoreException {
        return this.getSessionPropsMap();
    }

    public Object getSessionProperty(QualifiedName key) throws CoreException {
        return this.getSessionProperties().get(key);
    }

    public MockWorkspace getWorkspace() {
        return this._workspace;
    }

    public void setWorkspace(MockWorkspace workspace) {
        this._workspace = workspace;
    }

    public boolean isAccessible() {
        return this.exists();
    }

    public boolean isDerived() {
        throw new UnsupportedOperationException();
    }

    public boolean isDerived(int options) {
        throw new UnsupportedOperationException();
    }

    public boolean isHidden() {
        throw new UnsupportedOperationException();
    }

    public boolean isHidden(int options) {
        throw new UnsupportedOperationException();
    }

    public boolean isLinked() {
        throw new UnsupportedOperationException();
    }

    public boolean isVirtual() {
        throw new UnsupportedOperationException();
    }

    public boolean hasFilters() {
        throw new UnsupportedOperationException();
    }

    public boolean isLinked(int options) {
        throw new UnsupportedOperationException();
    }

    public boolean isLocal(int depth) {
        throw new UnsupportedOperationException();
    }

    public boolean isPhantom() {
        throw new UnsupportedOperationException();
    }

    public boolean isReadOnly() {
        throw new UnsupportedOperationException();
    }

    public boolean isSynchronized(int depth) {
        return this._isSynchronized;
    }

    public void setSynchronized(boolean isSynchronized) {
        this._isSynchronized = isSynchronized;
    }

    public boolean isTeamPrivateMember() {
        throw new UnsupportedOperationException();
    }

    public boolean isTeamPrivateMember(int options) {
        throw new UnsupportedOperationException();
    }

    public void move(IPath destination, boolean force, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void move(IPath destination, int updateFlags, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void move(IProjectDescription description, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void move(IProjectDescription description, int updateFlags, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void refreshLocal(int depth, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void revertModificationStamp(long value) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void setDerived(boolean isDerived) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void setDerived(boolean isDerived, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void setHidden(boolean isHidden) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void setLocal(boolean flag, int depth, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public long setLocalTimeStamp(long value) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void setPersistentProperty(QualifiedName key, String value) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void setReadOnly(boolean readOnly) {
        throw new UnsupportedOperationException();
    }

    public void setResourceAttributes(ResourceAttributes attributes) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void setSessionProperty(QualifiedName key, Object value) throws CoreException {
        this.getSessionPropsMap().put(key, value);
    }

    private Map<QualifiedName, Object> getSessionPropsMap() {
        if (this._sessionProps == null) {
            this._sessionProps = new HashMap<QualifiedName, Object>();
        }
        return this._sessionProps;
    }

    public void setTeamPrivateMember(boolean isTeamPrivate) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void touch(IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public boolean isFiltered() {
        throw new UnsupportedOperationException();
    }

    public IPathVariableManager getPathVariableManager() {
        throw new UnsupportedOperationException();
    }

    public void dispose() throws Exception {
        this._project = null;
        this._workspace = null;
    }

    public String toString() {
        return this._path.toString();
    }

    public void incrementModStamp() {
        ++this._modificationStamp;
    }
}

