/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.core.annotation.validation.tests;

import javax.jws.soap.SOAPBinding;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.internal.jaxws.core.JAXWSCoreMessages;
import org.eclipse.jst.ws.jaxws.core.annotation.validation.tests.AbstractDocumentBareValidationTest;
import org.eclipse.ltk.core.refactoring.Change;

public class DocBareVoidOneINOneOutParameterRuleTest
extends AbstractDocumentBareValidationTest {
    protected String getClassContents() {
        StringBuilder classContents = new StringBuilder("package com.example;\n\n");
        classContents.append("import javax.jws.WebParam;\n");
        classContents.append("import javax.xml.ws.Holder;\n\n");
        classContents.append("public class MyClass {\n\n\t");
        classContents.append("public void oneIn(@WebParam(name=\"inOne\", mode=WebParam.Mode.INOUT) ");
        classContents.append("Holder<String> inOne, @WebParam(name=\"inTwo\", mode=WebParam.Mode.IN) ");
        classContents.append("String inTwo) {\n\n\t}\n\n\t");
        classContents.append("public void oneOut(@WebParam(name=\"outOne\", mode=WebParam.Mode.INOUT) ");
        classContents.append("Holder<String> outOne, @WebParam(name=\"outTwo\", mode=WebParam.Mode.OUT) ");
        classContents.append("Holder<String> outTwo) {\n\n\t}\n\n}");
        return classContents.toString();
    }

    public void testVoidOneInParameterRule() {
        try {
            DocBareVoidOneINOneOutParameterRuleTest.assertNotNull((Object)this.annotation);
            DocBareVoidOneINOneOutParameterRuleTest.assertEquals((String)SOAPBinding.class.getSimpleName(), (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation));
            IMethod method = this.source.findPrimaryType().getMethod("oneIn", new String[]{"QHolder<QString;>;", "QString;"});
            DocBareVoidOneINOneOutParameterRuleTest.assertNotNull((Object)method);
            this.textFileChange.addEdit(AnnotationUtils.createAddImportTextEdit((IJavaElement)method, (String)SOAPBinding.class.getCanonicalName()));
            this.textFileChange.addEdit(AnnotationUtils.createAddAnnotationTextEdit((IJavaElement)method, (Annotation)this.annotation));
            DocBareVoidOneINOneOutParameterRuleTest.assertTrue((boolean)this.executeChange((IProgressMonitor)new NullProgressMonitor(), (Change)this.textFileChange));
            DocBareVoidOneINOneOutParameterRuleTest.assertTrue((boolean)AnnotationUtils.isAnnotationPresent((IJavaElement)method, (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation)));
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
            IMarker[] allmarkers = this.source.getResource().findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            DocBareVoidOneINOneOutParameterRuleTest.assertEquals((int)1, (int)allmarkers.length);
            IMarker annotationProblemMarker = allmarkers[0];
            DocBareVoidOneINOneOutParameterRuleTest.assertEquals((Object)this.source.getResource(), (Object)annotationProblemMarker.getResource());
            DocBareVoidOneINOneOutParameterRuleTest.assertEquals((Object)JAXWSCoreMessages.DOC_BARE_VOID_RETURN_ONE_IN_PARAMETER, (Object)annotationProblemMarker.getAttribute("message"));
        }
        catch (CoreException ce) {
            DocBareVoidOneINOneOutParameterRuleTest.fail((String)ce.getLocalizedMessage());
        }
        catch (OperationCanceledException oce) {
            DocBareVoidOneINOneOutParameterRuleTest.fail((String)oce.getLocalizedMessage());
        }
        catch (InterruptedException ie) {
            DocBareVoidOneINOneOutParameterRuleTest.fail((String)ie.getLocalizedMessage());
        }
    }

    public void testVoidOneOutParameterRule() {
        try {
            DocBareVoidOneINOneOutParameterRuleTest.assertNotNull((Object)this.annotation);
            DocBareVoidOneINOneOutParameterRuleTest.assertEquals((String)SOAPBinding.class.getSimpleName(), (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation));
            IMethod method = this.source.findPrimaryType().getMethod("oneOut", new String[]{"QHolder<QString;>;", "QHolder<QString;>;"});
            DocBareVoidOneINOneOutParameterRuleTest.assertNotNull((Object)method);
            this.textFileChange.addEdit(AnnotationUtils.createAddImportTextEdit((IJavaElement)method, (String)SOAPBinding.class.getCanonicalName()));
            this.textFileChange.addEdit(AnnotationUtils.createAddAnnotationTextEdit((IJavaElement)method, (Annotation)this.annotation));
            DocBareVoidOneINOneOutParameterRuleTest.assertTrue((boolean)this.executeChange((IProgressMonitor)new NullProgressMonitor(), (Change)this.textFileChange));
            DocBareVoidOneINOneOutParameterRuleTest.assertTrue((boolean)AnnotationUtils.isAnnotationPresent((IJavaElement)method, (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation)));
            DocBareVoidOneINOneOutParameterRuleTest.assertTrue((boolean)this.source.getImport(SOAPBinding.class.getCanonicalName()).exists());
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
            IMarker[] allmarkers = this.source.getResource().findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            DocBareVoidOneINOneOutParameterRuleTest.assertEquals((int)1, (int)allmarkers.length);
            IMarker annotationProblemMarker = allmarkers[0];
            DocBareVoidOneINOneOutParameterRuleTest.assertEquals((Object)this.source.getResource(), (Object)annotationProblemMarker.getResource());
            DocBareVoidOneINOneOutParameterRuleTest.assertEquals((Object)JAXWSCoreMessages.DOC_BARE_VOID_RETURN_ONE_OUT_PARAMETER, (Object)annotationProblemMarker.getAttribute("message"));
        }
        catch (CoreException ce) {
            DocBareVoidOneINOneOutParameterRuleTest.fail((String)ce.getLocalizedMessage());
        }
        catch (OperationCanceledException oce) {
            DocBareVoidOneINOneOutParameterRuleTest.fail((String)oce.getLocalizedMessage());
        }
        catch (InterruptedException ie) {
            DocBareVoidOneINOneOutParameterRuleTest.fail((String)ie.getLocalizedMessage());
        }
    }
}

