/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.jaxp.launching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.xsl.jaxp.launching.IDebugger;
import org.eclipse.wst.xsl.jaxp.launching.IProcessorInstall;
import org.eclipse.wst.xsl.jaxp.launching.IProcessorJar;
import org.eclipse.wst.xsl.jaxp.launching.IProcessorType;
import org.eclipse.wst.xsl.jaxp.launching.JAXPRuntime;
import org.eclipse.wst.xsl.jaxp.launching.internal.JAXPLaunchingPlugin;
import org.eclipse.wst.xsl.jaxp.launching.internal.PluginProcessorJar;
import org.eclipse.wst.xsl.jaxp.launching.internal.Utils;

public class ProcessorInstall
implements IProcessorInstall {
    private final String id;
    private String name;
    private String type;
    private IProcessorJar[] jars;
    private final boolean contributed;
    private String debuggerId;
    private String supports;

    public ProcessorInstall(String id, String label, String typeId, IProcessorJar[] jars, String debuggerId, String supports, boolean contributed) {
        this.id = id;
        this.name = label;
        this.type = typeId;
        this.debuggerId = debuggerId;
        this.contributed = contributed;
        this.jars = jars;
        this.supports = supports;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public IProcessorJar[] getProcessorJars() {
        return this.jars;
    }

    public void setProcessorJars(IProcessorJar[] jars) {
        this.jars = jars;
    }

    public String getProcessorTypeId() {
        return this.type;
    }

    @Override
    public IProcessorType getProcessorType() {
        return JAXPRuntime.getProcessorType(this.type);
    }

    public void setProcessorTypeId(String id) {
        this.type = id;
    }

    @Override
    public boolean isContributed() {
        return this.contributed;
    }

    public static IProcessorJar[] createJars(String bundleId, String classpath) {
        if (classpath == null) {
            return new IProcessorJar[0];
        }
        String[] jarstring = classpath.split(";");
        IProcessorJar[] jars = new IProcessorJar[jarstring.length];
        int i = 0;
        while (i < jarstring.length) {
            String jar = jarstring[i];
            try {
                if (jar.startsWith("${eclipse_orbit:") && jar.endsWith("}")) {
                    jar = jar.substring("${eclipse_orbit:".length());
                    jar = jar.substring(0, jar.length() - 1);
                    jars[i] = new PluginProcessorJar(jar, null);
                } else {
                    jar = Utils.getFileLocation(bundleId, jar);
                    jars[i] = new PluginProcessorJar(bundleId, (IPath)new Path(jar));
                }
            }
            catch (CoreException e) {
                JAXPLaunchingPlugin.log(e);
            }
            ++i;
        }
        return jars;
    }

    public boolean hasDebugger() {
        return this.debuggerId != null;
    }

    @Override
    public boolean supports(String xsltVersion) {
        return this.supports.indexOf(xsltVersion) >= 0;
    }

    @Override
    public String getSupports() {
        return this.supports;
    }

    public void setSupports(String supports) {
        this.supports = supports;
    }

    @Override
    public IDebugger getDebugger() {
        return JAXPRuntime.getDebugger(this.debuggerId);
    }

    public void setDebuggerId(String debuggerId) {
        this.debuggerId = debuggerId;
    }
}

