/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.viewer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.jst.pagedesigner.css2.layout.CSSFigure;
import org.eclipse.jst.pagedesigner.css2.layout.CSSTextFigure;
import org.eclipse.jst.pagedesigner.css2.layout.FlowBox;
import org.eclipse.jst.pagedesigner.dom.DOMPosition;
import org.eclipse.jst.pagedesigner.dom.DOMPositionHelper;
import org.eclipse.jst.pagedesigner.dom.DOMRefPosition;
import org.eclipse.jst.pagedesigner.dom.EditModelQuery;
import org.eclipse.jst.pagedesigner.parts.NodeEditPart;
import org.eclipse.jst.pagedesigner.parts.TextEditPart;
import org.eclipse.jst.pagedesigner.validation.caret.IMovementMediator;
import org.eclipse.jst.pagedesigner.validation.caret.IPositionMediator;
import org.eclipse.jst.pagedesigner.validation.caret.Target;
import org.eclipse.jst.pagedesigner.viewer.DesignPosition;
import org.eclipse.jst.pagedesigner.viewer.DesignRefPosition;
import org.eclipse.jst.pagedesigner.viewer.FlowBoxLine;
import org.eclipse.jst.pagedesigner.viewer.LayoutPart;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditPartPositionHelper {
    private static void addToCurrentLine(FlowBoxLine lineBox, EditPart host, Point point, IPositionMediator validator) {
        Node node = Target.resolveNode(host);
        if (node != null && !EditModelQuery.isDocument(node) && (validator.isValidPosition(new DOMRefPosition(node, true)) || validator.isValidPosition(new DOMRefPosition(node, false)) || validator.isValidPosition(new DOMPosition(node, 0)))) {
            lineBox.addLayoutPart(host, point);
        }
    }

    public static Rectangle convertToAbsoluteCaretRect(DesignPosition position) {
        Rectangle ret;
        block10: {
            ret = null;
            if (position != null && position.isValid()) break block10;
            return null;
        }
        try {
            EditPart containerEditPart = position.getContainerPart();
            if (containerEditPart instanceof TextEditPart) {
                CSSTextFigure figure = (CSSTextFigure)((TextEditPart)containerEditPart).getFigure();
                ret = figure.calculateCaretPosition(position.getOffset());
                figure.translateToAbsolute((Translatable)ret);
                ret.width = 2;
            } else {
                int offset = position.getOffset();
                if (containerEditPart.getChildren().isEmpty() || LayoutPart.getConcretePart(containerEditPart) == null) {
                    List fragments;
                    IFigure figure = ((GraphicalEditPart)containerEditPart).getFigure();
                    Rectangle bounds = figure.getBounds();
                    if (figure instanceof CSSFigure && (fragments = ((CSSFigure)figure).getFragmentsForRead()).size() > 0) {
                        FlowBox box = (FlowBox)fragments.get(fragments.size() - 1);
                        bounds = LayoutPart.getBounds(box);
                    }
                    ret = new Rectangle(bounds.x + 1, bounds.y, 2, bounds.height);
                    figure.translateToAbsolute((Translatable)ret);
                } else if (offset >= 0 && offset <= containerEditPart.getChildren().size()) {
                    ret = EditPartPositionHelper.getRefRect(position);
                }
            }
        }
        catch (Exception exception) {
            ret = new Rectangle(0, 0, 0, 0);
        }
        if (ret == null) {
            ret = new Rectangle(0, 0, 0, 0);
        }
        return ret;
    }

    public static DesignPosition findEditPartPosition(EditPart host, Point p, IPositionMediator validator) {
        try {
            EditPart part;
            host = validator.getEditableContainer(new Target(host));
            FlowBoxLine boxLine = new FlowBoxLine(new Rectangle(p.x, p.y, 0, 0), validator, p);
            DesignPosition position = EditPartPositionHelper.innerFindEditPartPosition(host, host, p, boxLine, validator);
            if (position == null && (position = EditPartPositionHelper.innerFindEditPartPosition(host, host, p, boxLine, validator)) == null && (part = boxLine.getClosestPart()) != null) {
                LayoutPart layoutPart = new LayoutPart(part, p);
                position = layoutPart.resolvePosition(validator);
            }
            return position;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static DesignPosition innerFindEditPartPosition(EditPart rootHost, EditPart host, Point p, FlowBoxLine boxLine, IPositionMediator validator) {
        Target target = new Target(host);
        LayoutPart lPart = new LayoutPart(host, p);
        if (host instanceof TextEditPart) {
            if (lPart.contains(p)) {
                DesignPosition position = null;
                position = EditPartPositionHelper.findTextEditPartPosition((TextEditPart)host, p);
                if (position == null) {
                    EditPartPositionHelper.addToCurrentLine(boxLine, host, p, validator);
                }
                return position;
            }
            EditPartPositionHelper.addToCurrentLine(boxLine, host, p, validator);
            return null;
        }
        if (EditPartPositionHelper.isWidget(host)) {
            if (lPart.contains(p) && (validator.isValidPosition(new DOMRefPosition(target.getNode(), true)) || validator.isValidPosition(new DOMRefPosition(target.getNode(), false)))) {
                if ("br".equalsIgnoreCase(Target.resolveNode(host).getNodeName())) {
                    return new DesignRefPosition(host, lPart.isBeforePoint(p));
                }
                return new DesignRefPosition(host, lPart.isBeforePoint(p) || !lPart.atLeftPart(p));
            }
            EditPartPositionHelper.addToCurrentLine(boxLine, host, p, validator);
        } else if (host == rootHost) {
            if (host.getChildren().size() > 0) {
                List children = host.getChildren();
                int i = 0;
                int size = children.size();
                while (i < size) {
                    GraphicalEditPart child = (GraphicalEditPart)children.get(i);
                    DesignPosition position = EditPartPositionHelper.innerFindEditPartPosition(rootHost, (EditPart)child, p, boxLine, validator);
                    if (position != null) {
                        return position;
                    }
                    ++i;
                }
            }
            if (boxLine.getPartsList().size() == 0) {
                if (lPart.contains(p)) {
                    return new DesignPosition(host, 0);
                }
                EditPartPositionHelper.addToCurrentLine(boxLine, host, p, validator);
            }
        } else if (!validator.hasEditableArea(target)) {
            if (lPart.contains(p) && (validator.isValidPosition(new DesignRefPosition(target.getPart(), true)) || validator.isValidPosition(new DesignRefPosition(target.getPart(), false)))) {
                return new DesignRefPosition(host, lPart.isBeforePoint(p) || !lPart.atLeftPart(p));
            }
            EditPartPositionHelper.addToCurrentLine(boxLine, host, p, validator);
        } else if (lPart.contains(p) || !validator.isValidPosition(new DesignRefPosition(target.getPart(), true)) && !validator.isValidPosition(new DesignRefPosition(target.getPart(), false))) {
            if (host.getChildren().size() > 0) {
                List children = host.getChildren();
                int i = 0;
                int size = children.size();
                while (i < size) {
                    GraphicalEditPart child = (GraphicalEditPart)children.get(i);
                    DesignPosition position = EditPartPositionHelper.innerFindEditPartPosition(rootHost, (EditPart)child, p, boxLine, validator);
                    if (position != null) {
                        return position;
                    }
                    ++i;
                }
            } else {
                if (lPart.contains(p)) {
                    return new DesignPosition(host, 0);
                }
                EditPartPositionHelper.addToCurrentLine(boxLine, host, p, validator);
            }
        } else {
            EditPartPositionHelper.addToCurrentLine(boxLine, host, p, validator);
        }
        return null;
    }

    public static DesignPosition findEditPartPositionConstrained(EditPart host, Point p, IMovementMediator validator) {
        try {
            EditPart part;
            FlowBoxLine boxLine = new FlowBoxLine(new Rectangle(p.x, p.y, 0, 0), validator, p);
            DesignPosition position = EditPartPositionHelper.innerFindEditPartPositionConstrained(host, host, p, boxLine, validator);
            if (position == null && (position = EditPartPositionHelper.innerFindEditPartPositionConstrained(host, host, p, boxLine, validator)) == null && (part = boxLine.getClosestPart()) != null) {
                LayoutPart layoutPart = new LayoutPart(part, p);
                position = layoutPart.resolvePosition(validator);
            }
            return position;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static DesignPosition innerFindEditPartPositionConstrained(EditPart rootHost, EditPart host, Point p, FlowBoxLine boxLine, IMovementMediator validator) {
        Target target = new Target(host);
        LayoutPart lPart = new LayoutPart(host, p);
        if (host instanceof TextEditPart) {
            if (lPart.contains(p)) {
                DesignPosition position = null;
                position = EditPartPositionHelper.findTextEditPartPosition((TextEditPart)host, p);
                if (position == null) {
                    EditPartPositionHelper.addToCurrentLine(boxLine, host, p, validator);
                }
                return position;
            }
            EditPartPositionHelper.addToCurrentLine(boxLine, host, p, validator);
            return null;
        }
        if (EditPartPositionHelper.isWidget(host)) {
            if (lPart.contains(p)) {
                if ("br".equalsIgnoreCase(Target.resolveNode(host).getNodeName())) {
                    return new DesignRefPosition(host, lPart.isBeforePoint(p));
                }
                return new DesignRefPosition(host, lPart.isBeforePoint(p) || !lPart.atLeftPart(p));
            }
            EditPartPositionHelper.addToCurrentLine(boxLine, host, p, validator);
        } else if (host == rootHost) {
            if (host.getChildren().size() > 0) {
                List children = host.getChildren();
                int i = 0;
                int size = children.size();
                while (i < size) {
                    GraphicalEditPart child = (GraphicalEditPart)children.get(i);
                    DesignPosition position = EditPartPositionHelper.innerFindEditPartPositionConstrained(rootHost, (EditPart)child, p, boxLine, validator);
                    if (position != null) {
                        return position;
                    }
                    ++i;
                }
            } else {
                if (lPart.contains(p)) {
                    return new DesignPosition(host, 0);
                }
                EditPartPositionHelper.addToCurrentLine(boxLine, host, p, validator);
            }
        } else if (!validator.hasEditableArea(target) || !validator.allowsMoveIn(target)) {
            if (validator.canReference(target, true) || validator.canReference(target, false)) {
                if (lPart.contains(p)) {
                    return new DesignRefPosition(host, lPart.isBeforePoint(p) || !lPart.atLeftPart(p));
                }
                EditPartPositionHelper.addToCurrentLine(boxLine, host, p, validator);
            }
        } else if (lPart.contains(p)) {
            if (host.getChildren().size() > 0) {
                List children = host.getChildren();
                int i = 0;
                int size = children.size();
                while (i < size) {
                    GraphicalEditPart child = (GraphicalEditPart)children.get(i);
                    DesignPosition position = EditPartPositionHelper.innerFindEditPartPositionConstrained(rootHost, (EditPart)child, p, boxLine, validator);
                    if (position != null) {
                        return position;
                    }
                    ++i;
                }
            } else {
                if (lPart.contains(p)) {
                    return new DesignPosition(host, 0);
                }
                EditPartPositionHelper.addToCurrentLine(boxLine, host, p, validator);
            }
        } else {
            EditPartPositionHelper.addToCurrentLine(boxLine, host, p, validator);
        }
        return null;
    }

    private static DesignPosition findTextEditPartPosition(TextEditPart host, Point p) {
        if (host.getFigure() instanceof CSSTextFigure) {
            CSSTextFigure figure = (CSSTextFigure)host.getFigure();
            p = p.getCopy();
            figure.translateToRelative((Translatable)p);
            int offset = figure.getInsertionOffset(p);
            if (offset >= 0) {
                return new DesignPosition((EditPart)host, offset);
            }
            return null;
        }
        return new DesignPosition((EditPart)host, 0);
    }

    public static Rectangle getAbsoluteBounds(EditPart child) {
        if (child instanceof GraphicalEditPart) {
            Rectangle bounds = ((GraphicalEditPart)child).getFigure().getBounds().getCopy();
            ((GraphicalEditPart)child).getFigure().translateToAbsolute((Translatable)bounds);
            return bounds;
        }
        return new Rectangle(0, 0, 0, 0);
    }

    private static boolean isWidget(EditPart host) {
        if (host instanceof NodeEditPart) {
            return ((NodeEditPart)host).isWidget();
        }
        return false;
    }

    private static EditPart tryTwoWays(DesignPosition position, List<Boolean> caretRefResult) {
        EditPart result = null;
        Node node = EditModelQuery.getInstance().getSibling(DOMPositionHelper.toDOMPosition(position), true);
        if (node != null && !EditModelQuery.isTransparentText(node)) {
            result = Target.resolvePart(node);
            caretRefResult.add(Boolean.FALSE);
        } else {
            node = EditModelQuery.getInstance().getSibling(DOMPositionHelper.toDOMPosition(position), false);
            if (node != null && !EditModelQuery.isTransparentText(node)) {
                result = Target.resolvePart(node);
                caretRefResult.add(Boolean.TRUE);
            }
        }
        if (result == null) {
            if (EditPartPositionHelper.getConcretePart(position, false) != null) {
                result = EditPartPositionHelper.getConcretePart(position, false);
                caretRefResult.add(Boolean.TRUE);
            } else if (EditPartPositionHelper.getConcretePart(position, true) != null) {
                result = EditPartPositionHelper.getConcretePart(position, true);
                caretRefResult.add(Boolean.FALSE);
            }
        }
        return result;
    }

    private static EditPart getNextConcretPart(DesignPosition position, List<Boolean> caretIsAtRightTest) {
        EditPart result = null;
        boolean caretIsAtRight = true;
        if (position instanceof DesignRefPosition) {
            caretIsAtRight = ((DesignRefPosition)position).caretIsAtRight();
            result = ((DesignRefPosition)position).getRefPart();
            caretIsAtRightTest.add(caretIsAtRight);
        }
        if (result == null || EditModelQuery.isTransparentText(Target.resolveNode(result))) {
            caretIsAtRightTest.clear();
            result = EditPartPositionHelper.tryTwoWays(position, caretIsAtRightTest);
        }
        return result;
    }

    public static EditPart getConcretePart(DesignPosition position, boolean forward) {
        EditPart result = null;
        Node node = EditModelQuery.getInstance().getSibling(DOMPositionHelper.toDOMPosition(position), forward);
        while (node != null && EditModelQuery.isTransparentText(node)) {
            node = EditModelQuery.getInstance().getSibling(node, forward);
        }
        if (node != null) {
            result = Target.resolvePart(node);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public static EditPart getNextConcretPart(DesignPosition position, boolean forward) {
        block4: {
            result = null;
            node = EditModelQuery.getInstance().getSibling(DOMPositionHelper.toDOMPosition(position), forward);
            if (node == null) break block4;
            if (!forward) ** GOTO lbl16
            while (node != null) {
                if (!EditModelQuery.isTransparentText(node) && (result = Target.resolvePart(node)) != null) {
                    result = Target.resolvePart(node);
                    break block4;
                }
                node = node.getNextSibling();
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                if (!EditModelQuery.isTransparentText(node) && (result = Target.resolvePart(node)) != null) {
                    result = Target.resolvePart(node);
                    break;
                }
                node = node.getPreviousSibling();
lbl16:
                // 2 sources

                ** while (node != null)
            }
        }
        return result;
    }

    private static Rectangle getRefRect(DesignPosition position) {
        ArrayList<Boolean> caretLocation = new ArrayList<Boolean>();
        EditPart part = EditPartPositionHelper.getNextConcretPart(position, caretLocation);
        Rectangle rect = null;
        if (part != null) {
            LayoutPart layoutPart = new LayoutPart(part, null);
            boolean caretIsAtRight = (Boolean)caretLocation.get(0);
            Rectangle bounds = null;
            IFigure figure = ((GraphicalEditPart)part).getFigure();
            if (!caretIsAtRight) {
                FlowBox box = layoutPart.getLine(0);
                if (box != null) {
                    bounds = LayoutPart.getBounds(box);
                }
            } else {
                FlowBox box = layoutPart.getLastLine();
                if (box != null) {
                    bounds = LayoutPart.getBounds(box);
                }
            }
            if (bounds == null) {
                bounds = figure.getBounds();
            }
            rect = !caretIsAtRight ? new Rectangle(bounds.x - 1, bounds.y, 2, bounds.height) : new Rectangle(bounds.getRight().x + 1, bounds.y, 2, bounds.height);
            figure.translateToAbsolute((Translatable)rect);
        } else {
            System.out.println("No concrete part?");
        }
        return rect;
    }
}

