/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.taglib;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.jsp.core.taglib.ITaglibIndexDelta;
import org.eclipse.jst.jsp.core.taglib.ITaglibRecord;

public class TaglibIndexDelta
implements ITaglibIndexDelta {
    private Collection fChildren;
    private int fExplicitKind = -1;
    private int fImplicitKind = -1;
    private IProject fProject;
    private ITaglibRecord fTaglibRecord = null;
    long time;
    Object trigger = null;

    TaglibIndexDelta(IProject project, ITaglibRecord record, int kind) {
        this.fProject = project;
        this.fTaglibRecord = record;
        this.fExplicitKind = kind;
        this.time = System.currentTimeMillis();
    }

    void addChildDelta(ITaglibIndexDelta delta) {
        if (this.fChildren == null) {
            this.fChildren = new ArrayList();
        }
        this.fChildren.add(delta);
        this.fImplicitKind = -1;
    }

    private int computeKind() {
        int added = 0;
        int removed = 0;
        ITaglibIndexDelta[] children = this.fChildren.toArray(new ITaglibIndexDelta[this.fChildren.size()]);
        int i = 0;
        while (i < children.length) {
            int kind = children[i].getKind();
            if (kind == 1) {
                ++added;
            }
            if (kind == 2) {
                ++removed;
            }
            if (added > 0 && removed > 0) break;
            ++i;
        }
        if (added > 0 && removed > 0) {
            return 4;
        }
        if (added > 0) {
            return 1;
        }
        if (removed > 0) {
            return 2;
        }
        return 4;
    }

    @Override
    public ITaglibIndexDelta[] getAffectedChildren() {
        if (this.fChildren == null) {
            return new ITaglibIndexDelta[0];
        }
        return this.fChildren.toArray(new ITaglibIndexDelta[this.fChildren.size()]);
    }

    @Override
    public int getKind() {
        if (this.fChildren == null) {
            return this.fExplicitKind;
        }
        if (this.fImplicitKind == -1) {
            this.fImplicitKind = this.computeKind();
        }
        return this.fImplicitKind;
    }

    @Override
    public IProject getProject() {
        return this.fProject;
    }

    @Override
    public ITaglibRecord getTaglibRecord() {
        return this.fTaglibRecord;
    }

    public long getTime() {
        return this.time;
    }

    public Object getTrigger() {
        return this.trigger;
    }

    public String toString() {
        if (this.fTaglibRecord != null) {
            String string = this.fTaglibRecord.toString();
            int kind = this.getKind();
            switch (kind) {
                case 1: {
                    string = " ADDED (" + string + ")";
                    break;
                }
                case 4: {
                    string = " CHANGED (" + string + ")";
                    break;
                }
                case 2: {
                    string = " REMOVED (" + string + ")";
                    break;
                }
                default: {
                    string = " other:" + kind + " (" + string + ")";
                }
            }
            return string;
        }
        StringBuffer buffer = new StringBuffer();
        int kind = this.getKind();
        switch (kind) {
            case 1: {
                buffer.append("TaglibIndexDelta(" + this.fProject + "):ADDED\n");
                break;
            }
            case 4: {
                buffer.append("TaglibIndexDelta(" + this.fProject + "):CHANGED\n");
                break;
            }
            case 2: {
                buffer.append("TaglibIndexDelta(" + this.fProject + "):REMOVED\n");
            }
        }
        ITaglibIndexDelta[] children = this.getAffectedChildren();
        int i = 0;
        while (i < children.length) {
            buffer.append('\t');
            buffer.append(children[i].toString());
            if (i < children.length - 1) {
                buffer.append('\n');
            }
            ++i;
        }
        return buffer.toString();
    }
}

